/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.network.abstractpackets.ModernPacket;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public abstract class StringListPacket
extends ModernPacket {
    private List<String> stringList = new ArrayList<String>();

    public StringListPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            this.getStringList().add(input.readUTF());
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.getStringList().size());
        for (int i = 0; i < this.getStringList().size(); ++i) {
            output.writeUTF(this.getStringList().get(i));
        }
    }

    public List<String> getStringList() {
        return this.stringList;
    }

    public StringListPacket setStringList(List<String> stringList) {
        this.stringList = stringList;
        return this;
    }
}

