/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.module;

import logisticspipes.interfaces.IStringBasedModule;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ModuleBasedItemSinkList
extends ModuleCoordinatesPacket {
    private NBTTagCompound nbt;

    public ModuleBasedItemSinkList(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new ModuleBasedItemSinkList(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        IStringBasedModule module = this.getLogisticsModule(player, IStringBasedModule.class);
        if (module == null) {
            return;
        }
        module.readFromNBT(this.nbt);
        if (MainProxy.isServer((IBlockAccess)player.func_130014_f_()) && this.getType().isInWorld()) {
            module.listChanged();
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeNBTTagCompound(this.nbt);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.nbt = input.readNBTTagCompound();
    }

    public NBTTagCompound getNbt() {
        return this.nbt;
    }

    public ModuleBasedItemSinkList setNbt(NBTTagCompound nbt) {
        this.nbt = nbt;
        return this;
    }
}

