/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.module;

import java.util.Objects;
import javax.annotation.Nonnull;
import logisticspipes.logisticspipes.ItemModuleInformationManager;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.property.PropertyHolder;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ModulePropertiesUpdate
extends ModuleCoordinatesPacket {
    @Nonnull
    public NBTTagCompound tag = new NBTTagCompound();

    public ModulePropertiesUpdate(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeNBTTagCompound(this.tag);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.tag = Objects.requireNonNull(input.readNBTTagCompound(), "read null NBT in ModulePropertiesUpdate");
    }

    @Override
    public ModernPacket template() {
        return new ModulePropertiesUpdate(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsModule module = this.getLogisticsModule(player, LogisticsModule.class);
        if (module == null) {
            return;
        }
        module.readFromNBT(this.tag);
        if (!this.getType().isInWorld() && player.field_71070_bA instanceof ContainerPlayer) {
            ItemModuleInformationManager.saveInformation((ItemStack)player.field_71071_by.field_70462_a.get(this.getPositionInt()), module);
            player.field_71071_by.func_70296_d();
        }
        MainProxy.runOnServer((IBlockAccess)player.field_70170_p, () -> () -> MainProxy.sendPacketToPlayer(ModulePropertiesUpdate.fromPropertyHolder(module).setModulePos(module), player));
    }

    @Nonnull
    public static ModuleCoordinatesPacket fromPropertyHolder(PropertyHolder holder) {
        ModulePropertiesUpdate packet = PacketHandler.getPacket(ModulePropertiesUpdate.class);
        holder.writeToNBT(packet.tag);
        return packet;
    }
}

