/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import logisticspipes.modules.ModuleCrafter;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class CraftingPipeUpdatePacket
extends ModuleCoordinatesPacket {
    private int[] amount = new int[3];
    private String[] liquidSatelliteNameArray = new String[3];
    private String liquidSatelliteName = "";
    private String satelliteName = "";
    private String[] advancedSatelliteNameArray = new String[9];
    private int priority = 0;

    public CraftingPipeUpdatePacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ModuleCrafter module = this.getLogisticsModule(player, ModuleCrafter.class);
        if (module == null) {
            return;
        }
        module.handleCraftingUpdatePacket(this);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeIntArray(this.amount);
        output.writeUTFArray(this.liquidSatelliteNameArray);
        output.writeUTF(this.liquidSatelliteName);
        output.writeUTF(this.satelliteName);
        output.writeUTFArray(this.advancedSatelliteNameArray);
        output.writeInt(this.priority);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.amount = input.readIntArray();
        this.liquidSatelliteNameArray = input.readUTFArray();
        this.liquidSatelliteName = input.readUTF();
        this.satelliteName = input.readUTF();
        this.advancedSatelliteNameArray = input.readUTFArray();
        this.priority = input.readInt();
    }

    @Override
    public ModernPacket template() {
        return new CraftingPipeUpdatePacket(this.getId());
    }

    public int[] getAmount() {
        return this.amount;
    }

    public CraftingPipeUpdatePacket setAmount(int[] amount) {
        this.amount = amount;
        return this;
    }

    public String[] getLiquidSatelliteNameArray() {
        return this.liquidSatelliteNameArray;
    }

    public CraftingPipeUpdatePacket setLiquidSatelliteNameArray(String[] liquidSatelliteNameArray) {
        this.liquidSatelliteNameArray = liquidSatelliteNameArray;
        return this;
    }

    public String getLiquidSatelliteName() {
        return this.liquidSatelliteName;
    }

    public CraftingPipeUpdatePacket setLiquidSatelliteName(String liquidSatelliteName) {
        this.liquidSatelliteName = liquidSatelliteName;
        return this;
    }

    public String getSatelliteName() {
        return this.satelliteName;
    }

    public CraftingPipeUpdatePacket setSatelliteName(String satelliteName) {
        this.satelliteName = satelliteName;
        return this;
    }

    public String[] getAdvancedSatelliteNameArray() {
        return this.advancedSatelliteNameArray;
    }

    public CraftingPipeUpdatePacket setAdvancedSatelliteNameArray(String[] advancedSatelliteNameArray) {
        this.advancedSatelliteNameArray = advancedSatelliteNameArray;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public CraftingPipeUpdatePacket setPriority(int priority) {
        this.priority = priority;
        return this;
    }
}

