/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import logisticspipes.LPItems;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.crafting.AutoCraftingInventory;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IRequestWatcher;
import logisticspipes.interfaces.IRotationProvider;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.block.CraftingSetType;
import logisticspipes.network.packets.block.RequestRotationPacket;
import logisticspipes.network.packets.orderer.OrderWatchRemovePacket;
import logisticspipes.network.packets.orderer.OrdererWatchPacket;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeItemsRequestLogistics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.CraftingUtil;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.item.SimpleStackInventory;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PipeBlockRequestTable
extends PipeItemsRequestLogistics
implements ISimpleInventoryEventHandler,
IRequestWatcher,
IGuiOpenControler,
IRotationProvider {
    public SimpleStackInventory diskInv = new SimpleStackInventory(1, "Disk Slot", 1);
    public SimpleStackInventory inv = new SimpleStackInventory(27, "Crafting Resources", 64);
    public ItemIdentifierInventory matrix = new ItemIdentifierInventory(9, "Crafting Matrix", 1);
    public ItemIdentifierInventory resultInv = new ItemIdentifierInventory(1, "Crafting Result", 1);
    public SimpleStackInventory toSortInv = new SimpleStackInventory(1, "Sorting Slot", 64);
    private InventoryCraftResult vanillaResult = new InventoryCraftResult();
    private IRecipe cache;
    private EntityPlayerMP fake;
    private int delay = 0;
    private int tick = 0;
    private int rotation;
    private boolean init = false;
    private PlayerCollectionList localGuiWatcher = new PlayerCollectionList();
    public Map<Integer, Pair<IResource, LinkedLogisticsOrderList>> watchedRequests = new HashMap<Integer, Pair<IResource, LinkedLogisticsOrderList>>();
    private int localLastUsedWatcherId = 0;
    public ItemIdentifier targetType = null;

    public PipeBlockRequestTable(Item item) {
        super(item);
        this.matrix.addListener(this);
    }

    @Override
    public boolean handleClick(EntityPlayer entityplayer, SecuritySettings settings) {
        if (MainProxy.isPipeControllerEquipped(entityplayer) && !entityplayer.func_70093_af()) {
            return false;
        }
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (settings == null || settings.openGui) {
                this.openGui(entityplayer);
            } else {
                entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
            }
        }
        return true;
    }

    @Override
    public void ignoreDisableUpdateEntity() {
        super.ignoreDisableUpdateEntity();
        if (this.tick++ == 5) {
            this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
        }
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            if (!this.init) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestRotationPacket.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
                this.init = true;
            }
            return;
        }
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return;
        }
        if (this.tick % 2 == 0 && !this.localGuiWatcher.isEmpty()) {
            this.checkForExpired();
            if (this.getUpgradeManager().hasCraftingMonitoringUpgrade()) {
                for (Map.Entry<Integer, Pair<IResource, LinkedLogisticsOrderList>> entry : this.watchedRequests.entrySet()) {
                    MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(OrdererWatchPacket.class).setOrders(entry.getValue().getValue2()).setStack(entry.getValue().getValue1()).setInteger(entry.getKey()).setTilePos(this.container), this.localGuiWatcher);
                }
            }
        } else if (this.tick % 20 == 0) {
            this.checkForExpired();
        }
    }

    private void checkForExpired() {
        Iterator<Map.Entry<Integer, Pair<IResource, LinkedLogisticsOrderList>>> iter = this.watchedRequests.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Pair<IResource, LinkedLogisticsOrderList>> entry = iter.next();
            if (!this.isDone(entry.getValue().getValue2())) continue;
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(OrderWatchRemovePacket.class).setInteger(entry.getKey()).setTilePos(this.container), this.localGuiWatcher);
            iter.remove();
        }
    }

    private boolean isDone(LinkedLogisticsOrderList orders) {
        boolean isDone = true;
        for (IOrderInfoProvider order : orders) {
            if (!order.isFinished()) {
                isDone = false;
            }
            if (order.getProgresses().isEmpty()) continue;
            isDone = false;
        }
        for (LinkedLogisticsOrderList orderList : orders.getSubOrders()) {
            if (this.isDone(orderList)) continue;
            isDone = false;
        }
        return isDone;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        ItemStack stack = this.toSortInv.func_70301_a(0);
        if (!stack.func_190926_b()) {
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            LPTravelingItem.LPTravelingItemServer itemToSend = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
            SimpleServiceLocator.logisticsManager.assignDestinationFor(itemToSend, this.getRouter().getSimpleID(), false);
            if (itemToSend.getDestinationUUID() != null) {
                EnumFacing dir = this.getRouteLayer().getOrientationForItem(itemToSend, null);
                super.queueRoutedItem(itemToSend, dir.func_176734_d());
                this.spawnParticle(Particles.OrangeParticle, 4);
                this.toSortInv.clearInventorySlotContents(0);
            } else {
                this.delay = 100;
            }
        } else {
            this.delay = 0;
        }
    }

    @Override
    public void openGui(EntityPlayer entityplayer) {
        boolean flag = true;
        if (!this.diskInv.func_70301_a(0).func_190926_b() && !entityplayer.func_184614_ca().func_190926_b() && entityplayer.func_184614_ca().func_77973_b().equals(LPItems.disk)) {
            this.diskInv.func_70299_a(0, entityplayer.func_184614_ca());
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            flag = false;
        }
        if (flag) {
            entityplayer.openGui((Object)LogisticsPipes.instance, 38, this.getWorld(), this.getX(), this.getY(), this.getZ());
        }
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.empty;
    }

    @Override
    public Textures.TextureType getRoutedTexture(EnumFacing connection) {
        return Textures.empty_1;
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(EnumFacing connection) {
        return Textures.empty_2;
    }

    @Override
    public void onAllowedRemoval() {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            this.inv.dropContents(this.getWorld(), this.getPos());
            this.toSortInv.dropContents(this.getWorld(), this.getPos());
            this.diskInv.dropContents(this.getWorld(), this.getPos());
        }
    }

    public void cacheRecipe() {
        ItemIdentifier oldTargetType = this.targetType;
        this.cache = null;
        this.resultInv.clearInventorySlotContents(0);
        AutoCraftingInventory craftInv = new AutoCraftingInventory(null);
        for (int i = 0; i < 9; ++i) {
            craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
        }
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        for (IRecipe r : CraftingUtil.getRecipeList()) {
            if (!r.func_77569_a((InventoryCrafting)craftInv, this.getWorld())) continue;
            list.add(r);
        }
        if (list.size() == 1) {
            this.cache = (IRecipe)list.get(0);
            this.resultInv.func_70299_a(0, this.cache.func_77572_b((InventoryCrafting)craftInv));
            this.targetType = null;
        } else if (list.size() > 1) {
            if (this.targetType != null) {
                for (IRecipe recipe : list) {
                    craftInv = new AutoCraftingInventory(null);
                    for (int i = 0; i < 9; ++i) {
                        craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
                    }
                    ItemStack result2 = recipe.func_77572_b((InventoryCrafting)craftInv);
                    if (this.targetType != ItemIdentifier.get(result2)) continue;
                    this.resultInv.func_70299_a(0, result2);
                    this.cache = recipe;
                    break;
                }
            }
            if (this.cache == null) {
                this.cache = (IRecipe)list.get(0);
                ItemStack result3 = this.cache.func_77572_b((InventoryCrafting)craftInv);
                this.resultInv.func_70299_a(0, result3);
                this.targetType = ItemIdentifier.get(result3);
            }
        } else {
            this.targetType = null;
        }
        if (this.targetType != oldTargetType && !this.localGuiWatcher.isEmpty() && this.getWorld() != null && MainProxy.isServer((IBlockAccess)this.getWorld())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(CraftingSetType.class).setTargetType(this.targetType).setTilePos(this.container), this.localGuiWatcher);
        }
    }

    public void cycleRecipe(boolean down) {
        this.cacheRecipe();
        if (this.targetType == null) {
            return;
        }
        this.cache = null;
        AutoCraftingInventory craftInv = new AutoCraftingInventory(null);
        for (int i = 0; i < 9; ++i) {
            craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
        }
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        for (IRecipe r : CraftingUtil.getRecipeList()) {
            if (!r.func_77569_a((InventoryCrafting)craftInv, this.getWorld())) continue;
            list.add(r);
        }
        if (list.size() > 1) {
            boolean found = false;
            IRecipe prev = null;
            for (IRecipe recipe : list) {
                if (found) {
                    this.cache = recipe;
                    break;
                }
                craftInv = new AutoCraftingInventory(null);
                for (int i = 0; i < 9; ++i) {
                    craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
                }
                if (this.targetType == ItemIdentifier.get(recipe.func_77572_b((InventoryCrafting)craftInv))) {
                    if (down) {
                        found = true;
                    } else {
                        if (prev == null) {
                            this.cache = (IRecipe)list.get(list.size() - 1);
                            break;
                        }
                        this.cache = prev;
                        break;
                    }
                }
                prev = recipe;
            }
            if (this.cache == null) {
                this.cache = (IRecipe)list.get(0);
            }
            craftInv = new AutoCraftingInventory(null);
            for (int i = 0; i < 9; ++i) {
                craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
            }
            this.targetType = ItemIdentifier.get(this.cache.func_77572_b((InventoryCrafting)craftInv));
        }
        if (!this.localGuiWatcher.isEmpty() && this.getWorld() != null && MainProxy.isServer((IBlockAccess)this.getWorld())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(CraftingSetType.class).setTargetType(this.targetType).setTilePos(this.container), this.localGuiWatcher);
        }
        this.cacheRecipe();
    }

    @Nonnull
    public ItemStack getOutput(boolean oreDict) {
        ItemStack left;
        int i;
        int j;
        if (this.cache == null) {
            this.cacheRecipe();
            if (this.cache == null) {
                return ItemStack.field_190927_a;
            }
        }
        if (this.resultInv.getIDStackInSlot(0) == null) {
            return ItemStack.field_190927_a;
        }
        int[] toUse = new int[9];
        int[] used = new int[this.inv.func_70302_i_()];
        block0: for (int i2 = 0; i2 < 9; ++i2) {
            ItemStack item = this.matrix.func_70301_a(i2);
            if (item.func_190926_b()) {
                toUse[i2] = -1;
                continue;
            }
            ItemIdentifier ident = ItemIdentifier.get(item);
            for (j = 0; j < this.inv.func_70302_i_(); ++j) {
                item = this.inv.func_70301_a(j);
                if (item.func_190926_b()) continue;
                ItemIdentifier withIdent = ItemIdentifier.get(item);
                if (ident.equalsForCrafting(withIdent) && item.func_190916_E() > used[j]) {
                    int n = j;
                    used[n] = used[n] + 1;
                    toUse[i2] = j;
                    continue block0;
                }
                if (!oreDict || ident.getDictIdentifiers() == null || withIdent.getDictIdentifiers() == null || !ident.getDictIdentifiers().canMatch(withIdent.getDictIdentifiers(), true, false) || item.func_190916_E() <= used[j]) continue;
                int n = j;
                used[n] = used[n] + 1;
                toUse[i2] = j;
                continue block0;
            }
            return ItemStack.field_190927_a;
        }
        AutoCraftingInventory crafter = new AutoCraftingInventory(null);
        for (int i3 = 0; i3 < 9; ++i3) {
            int j2 = toUse[i3];
            if (j2 == -1) continue;
            crafter.func_70299_a(i3, this.inv.func_70301_a(j2));
        }
        if (!this.cache.func_77569_a((InventoryCrafting)crafter, this.getWorld())) {
            return ItemStack.field_190927_a;
        }
        ItemStack result2 = this.cache.func_77572_b((InventoryCrafting)crafter);
        if (result2.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.resultInv.getIDStackInSlot(0).getItem().equalsWithoutNBT(ItemIdentifier.get(result2))) {
            return ItemStack.field_190927_a;
        }
        crafter = new AutoCraftingInventory(null);
        for (int i4 = 0; i4 < 9; ++i4) {
            j = toUse[i4];
            if (j == -1) continue;
            crafter.func_70299_a(i4, this.inv.func_70298_a(j, 1));
        }
        result2 = this.cache.func_77572_b((InventoryCrafting)crafter);
        if (this.fake == null) {
            this.fake = MainProxy.getFakePlayer(this.getWorld());
        }
        result2 = result2.func_77946_l();
        SlotCrafting craftingSlot = new SlotCrafting((EntityPlayer)this.fake, crafter, this.resultInv, 0, 0, 0){

            protected void func_75208_c(@Nonnull ItemStack stack) {
                IInventory tmp = this.field_75224_c;
                PipeBlockRequestTable.this.vanillaResult.func_193056_a(PipeBlockRequestTable.this.cache);
                this.field_75224_c = PipeBlockRequestTable.this.vanillaResult;
                super.func_75208_c(stack);
                this.field_75224_c = tmp;
            }
        };
        result2 = craftingSlot.func_190901_a((EntityPlayer)this.fake, result2);
        for (i = 0; i < 9; ++i) {
            left = crafter.func_70301_a(i);
            crafter.func_70299_a(i, ItemStack.field_190927_a);
            if (left.func_190926_b()) continue;
            left.func_190920_e(this.inv.addCompressed(left, false));
            if (left.func_190916_E() <= 0) continue;
            ItemIdentifierInventory.dropItems(this.getWorld(), left, this.getX(), this.getY(), this.getZ());
        }
        for (i = 0; i < this.fake.field_71071_by.func_70302_i_(); ++i) {
            left = this.fake.field_71071_by.func_70301_a(i);
            this.fake.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            if (left.func_190926_b()) continue;
            left.func_190920_e(this.inv.addCompressed(left, false));
            if (left.func_190916_E() <= 0) continue;
            ItemIdentifierInventory.dropItems(this.getWorld(), left, this.getX(), this.getY(), this.getZ());
        }
        return result2;
    }

    @Nonnull
    public ItemStack getResultForClick() {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            ItemStack result2 = this.getOutput(true);
            if (result2.func_190926_b()) {
                result2 = this.getOutput(false);
            }
            if (result2.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            result2.func_190920_e(this.inv.addCompressed(result2, false));
            if (result2.func_190916_E() > 0) {
                return result2;
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (inventory == this.matrix) {
            this.cacheRecipe();
        }
    }

    public void handleNEIRecipePacket(NonNullList<ItemStack> content) {
        if (this.matrix.func_70302_i_() != content.size()) {
            throw new IllegalStateException("Different sizes of matrix and inventory from packet");
        }
        for (int i = 0; i < content.size(); ++i) {
            this.matrix.func_70299_a(i, (ItemStack)content.get(i));
        }
        this.cacheRecipe();
    }

    @Override
    public void readFromNBT(NBTTagCompound par1nbtTagCompound) {
        super.readFromNBT(par1nbtTagCompound);
        this.inv.readFromNBT(par1nbtTagCompound, "inv");
        this.matrix.readFromNBT(par1nbtTagCompound, "matrix");
        this.toSortInv.readFromNBT(par1nbtTagCompound, "toSortInv");
        this.diskInv.readFromNBT(par1nbtTagCompound, "diskInv");
        this.rotation = par1nbtTagCompound.func_74762_e("blockRotation");
    }

    @Override
    public void writeToNBT(NBTTagCompound par1nbtTagCompound) {
        super.writeToNBT(par1nbtTagCompound);
        this.inv.writeToNBT(par1nbtTagCompound, "inv");
        this.matrix.writeToNBT(par1nbtTagCompound, "matrix");
        this.toSortInv.writeToNBT(par1nbtTagCompound, "toSortInv");
        this.diskInv.writeToNBT(par1nbtTagCompound, "diskInv");
        par1nbtTagCompound.func_74768_a("blockRotation", this.rotation);
    }

    @Override
    public boolean isOnSameContainer(CoreRoutedPipe other) {
        return false;
    }

    @Override
    @Nonnull
    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new TransportLayer(){

                @Override
                public void handleItem(IRoutedItem item) {
                    PipeBlockRequestTable.this.notifyOfItemArival(item.getInfo());
                    if (item.getItemIdentifierStack() != null) {
                        ItemIdentifierStack stack = item.getItemIdentifierStack();
                        stack.setStackSize(PipeBlockRequestTable.this.inv.addCompressed(stack.makeNormalStack(), false));
                    }
                }

                @Override
                public EnumFacing itemArrived(IRoutedItem item, EnumFacing denyed) {
                    return null;
                }

                @Override
                public boolean stillWantItem(IRoutedItem item) {
                    return false;
                }
            };
        }
        return this._transportLayer;
    }

    @Override
    public void handleOrderList(IResource stack, LinkedLogisticsOrderList orders) {
        if (!this.getUpgradeManager().hasCraftingMonitoringUpgrade()) {
            return;
        }
        orders.setWatched();
        this.watchedRequests.put(++this.localLastUsedWatcherId, new Pair<IResource, LinkedLogisticsOrderList>(stack, orders));
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(OrdererWatchPacket.class).setOrders(orders).setStack(stack).setInteger(this.localLastUsedWatcherId).setTilePos(this.container), this.localGuiWatcher);
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OrderWatchRemovePacket.class).setInteger(-1).setTilePos(this.container), player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(CraftingSetType.class).setTargetType(this.targetType).setTilePos(this.container), player);
        this.localGuiWatcher.add(player);
        for (Map.Entry<Integer, Pair<IResource, LinkedLogisticsOrderList>> entry : this.watchedRequests.entrySet()) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OrdererWatchPacket.class).setOrders(entry.getValue().getValue2()).setStack(entry.getValue().getValue1()).setInteger(entry.getKey()).setTilePos(this.container), player);
        }
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.localGuiWatcher.remove(player);
    }

    @Override
    public void handleClientSideListInfo(int id, IResource stack, LinkedLogisticsOrderList orders) {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            this.watchedRequests.put(id, new Pair<IResource, LinkedLogisticsOrderList>(stack, orders));
        }
    }

    @Override
    public void handleClientSideRemove(int id) {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            if (id == -1) {
                this.watchedRequests.clear();
            } else {
                this.watchedRequests.remove(id);
            }
        }
    }

    @Nonnull
    public ItemStack getDisk() {
        return this.diskInv.func_70301_a(0);
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    @Override
    public boolean isMultipartAllowedInPipe() {
        return false;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload worldEvent) {
        if (this.fake.field_70170_p == worldEvent.getWorld()) {
            this.fake = null;
        }
    }
}

