/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import logisticspipes.gui.hud.HUDProvider;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.IOrderManagerContentReceiver;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleProvider;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.LogisticsItemOrderManager;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.textures.Textures;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;

public class PipeItemsProviderLogistics
extends CoreRoutedPipe
implements IProvideItems,
IHeadUpDisplayRendererProvider,
IChestContentReceiver,
IOrderManagerContentReceiver {
    public final LinkedList<ItemIdentifierStack> itemListOrderer = new LinkedList();
    private final HUDProvider HUD = new HUDProvider(this);
    @Nonnull
    protected LogisticsItemOrderManager orderManager;
    @Nonnull
    protected final ModuleProvider providerModule = new ModuleProvider();

    public ArrayList<ItemIdentifierStack> getDisplayList() {
        return this.providerModule.displayList;
    }

    public PipeItemsProviderLogistics(Item item) {
        super(item);
        this.orderManager = new LogisticsItemOrderManager(this);
        this.providerModule.registerHandler(this, this);
        this.providerModule.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
    }

    @Override
    public void onAllowedRemoval() {
        this.providerModule.onBlockRemoval();
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_PROVIDER_TEXTURE;
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        if (!this.isEnabled()) {
            return;
        }
        this.providerModule.canProvide(tree, root, filters);
    }

    @Override
    public LogisticsOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        return this.providerModule.fullFill(promise, destination, info);
    }

    @Override
    public void getAllItems(Map<ItemIdentifier, Integer> items, List<IFilter> filters) {
        if (!this.isEnabled()) {
            return;
        }
        this.providerModule.getAllItems(items, filters);
    }

    @Override
    public ModuleProvider getLogisticsModule() {
        return this.providerModule;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return this.providerModule.itemSendMode();
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.providerModule.startWatching(player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.providerModule.stopWatching(player);
        } else {
            super.playerStopWatching(player, mode);
        }
    }

    @Override
    public void setReceivedChestContent(Collection<ItemIdentifierStack> list) {
        this.providerModule.displayList.clear();
        this.providerModule.displayList.ensureCapacity(list.size());
        this.providerModule.displayList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void setOrderManagerContent(Collection<ItemIdentifierStack> list) {
        this.itemListOrderer.clear();
        this.itemListOrderer.addAll(list);
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemidCollection) {
        if (((Boolean)this.providerModule.isExclusionFilter.getValue()).booleanValue() || this.providerModule.filterInventory.func_191420_l()) {
            itemidCollection.addAll(this.providerModule.inventoriesWithMode().flatMap(invUtil -> invUtil.getItems().stream()).filter(item -> !this.providerModule.filterBlocksItem((ItemIdentifier)item)).collect(Collectors.toList()));
        } else {
            this.providerModule.collectSpecificInterests(itemidCollection);
        }
    }

    @Override
    public double getLoadFactor() {
        return (double)(this.orderManager.totalAmountCountInAllOrders() + 63) / 64.0;
    }
}

