/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.bs.ICrateStorageProxy;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.inventory.ProviderMode;

public class CrateInventoryHandler
extends SpecialInventoryHandler
implements SpecialInventoryHandler.Factory {
    private final ICrateStorageProxy tile;
    private final boolean hideOne;
    LinkedList<Map.Entry<ItemIdentifier, Integer>> cached;

    private CrateInventoryHandler(TileEntity tile, ProviderMode mode) {
        this.tile = SimpleServiceLocator.betterStorageProxy.getCrateStorageProxy(tile);
        this.hideOne = mode.getHideOnePerStack() || mode.getHideOnePerType();
    }

    public CrateInventoryHandler() {
        this.tile = null;
        this.hideOne = false;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(@Nonnull TileEntity tile, @Nullable EnumFacing dir) {
        return SimpleServiceLocator.betterStorageProxy.isBetterStorageCrate(tile);
    }

    @Override
    @Nullable
    public SpecialInventoryHandler getUtilForTile(@Nonnull TileEntity tile, @Nullable EnumFacing direction, @Nonnull ProviderMode mode) {
        return new CrateInventoryHandler(tile, mode);
    }

    @Override
    @Nonnull
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> result2 = new TreeSet<ItemIdentifier>();
        for (ItemStack stack : this.tile.getContents()) {
            result2.add(ItemIdentifier.get(stack));
        }
        return result2;
    }

    @Override
    @Nonnull
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        return this.getItemsAndCount(false);
    }

    private Map<ItemIdentifier, Integer> getItemsAndCount(boolean linked) {
        HashMap<ItemIdentifier, Integer> map2 = new HashMap<ItemIdentifier, Integer>((int)((double)this.tile.getUniqueItems() * 1.5));
        for (ItemStack stack : this.tile.getContents()) {
            ItemIdentifier itemId = ItemIdentifier.get(stack);
            int stackSize = stack.func_190916_E() - (this.hideOne ? 1 : 0);
            map2.merge(itemId, stackSize, Integer::sum);
        }
        return map2;
    }

    @Override
    @Nonnull
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        int count2 = this.tile.getItemCount(itemIdent.unsafeMakeNormalStack(1));
        if (count2 <= (this.hideOne ? 1 : 0)) {
            return ItemStack.field_190927_a;
        }
        return this.tile.extractItems(itemIdent.makeNormalStack(1), 1);
    }

    @Override
    public boolean containsUndamagedItem(@Nonnull ItemIdentifier itemIdent) {
        if (!itemIdent.isDamageable()) {
            int count2 = this.tile.getItemCount(itemIdent.unsafeMakeNormalStack(1));
            return count2 > 0;
        }
        for (ItemStack stack : this.tile.getContents()) {
            ItemIdentifier itemId = ItemIdentifier.get(stack).getUndamaged();
            if (!itemId.equals(itemIdent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(@Nonnull ItemStack stack) {
        return this.tile.getSpaceForItem(stack);
    }

    @Override
    @Nonnull
    public ItemStack add(@Nonnull ItemStack stack, EnumFacing from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        st.func_190920_e(0);
        if (doAdd) {
            ItemStack tst = stack.func_77946_l();
            ItemStack overflow = this.tile.insertItems(tst);
            st.func_190920_e(stack.func_190916_E());
            if (!overflow.func_190926_b()) {
                st.func_190918_g(overflow.func_190916_E());
            }
        } else {
            st.func_190920_e(Math.max(Math.min(this.roomForItem(stack), stack.func_190916_E()), 0));
        }
        return st;
    }

    @Override
    public int getSizeInventory() {
        if (this.cached == null) {
            this.initCache();
        }
        return this.cached.size();
    }

    public void initCache() {
        Map<ItemIdentifier, Integer> map2 = this.getItemsAndCount(true);
        this.cached = new LinkedList();
        this.cached.addAll(map2.entrySet());
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int i) {
        Map.Entry<ItemIdentifier, Integer> entry;
        if (this.cached == null) {
            this.initCache();
        }
        if ((entry = this.cached.get(i)).getValue() == 0) {
            return ItemStack.field_190927_a;
        }
        return entry.getKey().makeNormalStack(entry.getValue());
    }

    @Override
    @Nonnull
    public ItemStack decrStackSize(int i, int j) {
        Map.Entry<ItemIdentifier, Integer> entry;
        ItemStack stack;
        int count2;
        if (this.cached == null) {
            this.initCache();
        }
        if ((count2 = this.tile.getItemCount(stack = (entry = this.cached.get(i)).getKey().makeNormalStack(j))) <= (this.hideOne ? 1 : 0)) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = this.tile.extractItems(stack, 1);
        entry.setValue(entry.getValue() - j);
        return extracted;
    }
}

