/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import java.util.Arrays;
import logisticspipes.proxy.object3d.interfaces.I3DOperation;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import net.minecraft.util.ResourceLocation;

public class RenderEntry {
    private static final ResourceLocation BLOCKS = new ResourceLocation("textures/atlas/blocks.png");
    private final IModel3D model;
    private final I3DOperation[] operations;
    private final ResourceLocation texture;

    public RenderEntry(IModel3D model, I3DOperation[] operations, ResourceLocation texture) {
        this.model = model;
        this.operations = operations;
        this.texture = texture;
    }

    public RenderEntry(IModel3D model, I3DOperation ... operations) {
        this(model, operations, BLOCKS);
    }

    public RenderEntry(IModel3D model) {
        this(model, new I3DOperation[0]);
    }

    public RenderEntry(IModel3D model, ResourceLocation texture) {
        this(model, new I3DOperation[0], texture);
    }

    public RenderEntry clone() {
        return new RenderEntry(this.model.copy(), (I3DOperation[])this.operations.clone(), this.texture);
    }

    public RenderEntry clone(I3DOperation[] ops) {
        return new RenderEntry(this.model.copy(), ops, BLOCKS);
    }

    public IModel3D getModel() {
        return this.model;
    }

    public I3DOperation[] getOperations() {
        return this.operations;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderEntry)) {
            return false;
        }
        RenderEntry other = (RenderEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IModel3D this$model = this.getModel();
        IModel3D other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOperations(), other.getOperations())) {
            return false;
        }
        ResourceLocation this$texture = this.getTexture();
        ResourceLocation other$texture = other.getTexture();
        return !(this$texture == null ? other$texture != null : !this$texture.equals(other$texture));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RenderEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        IModel3D $model = this.getModel();
        result2 = result2 * 59 + ($model == null ? 43 : $model.hashCode());
        result2 = result2 * 59 + Arrays.deepHashCode(this.getOperations());
        ResourceLocation $texture = this.getTexture();
        result2 = result2 * 59 + ($texture == null ? 43 : $texture.hashCode());
        return result2;
    }

    public String toString() {
        return "RenderEntry(model=" + this.getModel() + ", operations=" + Arrays.deepToString(this.getOperations()) + ", texture=" + this.getTexture() + ")";
    }
}

