/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.transport;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.routing.order.IDistanceTracker;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.EnumFacingUtil;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.SlidingWindowBitSet;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public abstract class LPTravelingItem {
    public static final Map<Integer, WeakReference<LPTravelingItemServer>> serverList = new HashMap<Integer, WeakReference<LPTravelingItemServer>>();
    public static final Map<Integer, WeakReference<LPTravelingItemClient>> clientList = new HashMap<Integer, WeakReference<LPTravelingItemClient>>();
    public static final List<Pair<Integer, Object>> forceKeep = new ArrayList<Pair<Integer, Object>>();
    public static final SlidingWindowBitSet clientSideKnownIDs = new SlidingWindowBitSet(20);
    private static int nextFreeId = 0;
    protected int id;
    protected float speed = 0.01f;
    public int lastTicked = 0;
    protected TileEntity container;
    protected float position = 0.0f;
    protected float yaw = 0.0f;
    public EnumFacing input = null;
    public EnumFacing output = null;
    public final EnumSet<EnumFacing> blacklist = EnumSet.noneOf(EnumFacing.class);

    public LPTravelingItem() {
        this.id = this.getNextId();
    }

    public LPTravelingItem(int id, float position, EnumFacing input, EnumFacing output, float yaw) {
        this.id = id;
        this.position = position;
        this.input = input;
        this.output = output;
        this.yaw = yaw;
    }

    public LPTravelingItem(int id) {
        this.id = id;
    }

    protected int getNextId() {
        return ++nextFreeId;
    }

    public void setPosition(float position) {
        this.position = position;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw % 360.0f;
    }

    public float getPosition() {
        return this.position;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setContainer(TileEntity container) {
        this.container = container;
    }

    public TileEntity getContainer() {
        return this.container;
    }

    public int getId() {
        return this.id;
    }

    public abstract ItemIdentifierStack getItemIdentifierStack();

    public boolean isCorrupted() {
        return this.getItemIdentifierStack() == null || this.getItemIdentifierStack().getStackSize() <= 0;
    }

    public int getAge() {
        return 0;
    }

    public void addAge() {
    }

    public float getHoverStart() {
        return 0.0f;
    }

    public abstract LPTravelingItem renderCopy();

    public static final class LPTravelingItemServer
    extends LPTravelingItem
    implements IRoutedItem {
        private ItemRoutingInformation info;

        public LPTravelingItemServer(ItemIdentifierStack stack) {
            this.info = new ItemRoutingInformation();
            this.info.setItem(stack);
        }

        public LPTravelingItemServer(ItemRoutingInformation info) {
            this.info = info;
        }

        public LPTravelingItemServer(NBTTagCompound data) {
            this.info = new ItemRoutingInformation();
            this.readFromNBT(data);
        }

        @Override
        public ItemIdentifierStack getItemIdentifierStack() {
            return this.info.getItem();
        }

        public void setInformation(ItemRoutingInformation info) {
            this.info = info;
        }

        @Override
        public void readFromNBT(NBTTagCompound data) {
            this.setPosition(data.func_74760_g("position"));
            this.setSpeed(data.func_74760_g("speed"));
            this.input = data.func_74764_b("input") ? EnumFacingUtil.getOrientation(data.func_74762_e("input")) : null;
            this.output = data.func_74764_b("output") ? EnumFacingUtil.getOrientation(data.func_74762_e("output")) : null;
            this.info.readFromNBT(data);
        }

        @Override
        public void writeToNBT(NBTTagCompound data) {
            data.func_74776_a("position", this.getPosition());
            data.func_74776_a("speed", this.getSpeed());
            if (this.input != null) {
                data.func_74768_a("input", this.input.ordinal());
            }
            if (this.output != null) {
                data.func_74768_a("output", this.output.ordinal());
            }
            this.info.writeToNBT(data);
        }

        public EntityItem toEntityItem() {
            World world = this.container.func_145831_w();
            if (MainProxy.isServer((IBlockAccess)world)) {
                if (this.getItemIdentifierStack().getStackSize() <= 0) {
                    return null;
                }
                if (this.getItemIdentifierStack().makeNormalStack().func_77973_b() instanceof LogisticsFluidContainer) {
                    this.itemWasLost();
                    return null;
                }
                EnumFacing exitdirection = this.output;
                if (exitdirection == null) {
                    exitdirection = this.input;
                }
                DoubleCoordinates position = new DoubleCoordinates(this.container).add(new DoubleCoordinates(0.5, 0.375, 0.5));
                switch (exitdirection) {
                    case DOWN: {
                        CoordinateUtils.add(position, exitdirection, 0.5);
                        break;
                    }
                    case UP: {
                        CoordinateUtils.add(position, exitdirection, 0.75);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: 
                    case WEST: 
                    case EAST: {
                        CoordinateUtils.add(position, exitdirection, 0.625);
                        break;
                    }
                }
                DoubleCoordinates motion = new DoubleCoordinates(0.0, 0.0, 0.0);
                CoordinateUtils.add(motion, exitdirection, (double)this.getSpeed() * 2.0);
                EntityItem entityitem = this.getItemIdentifierStack().makeEntityItem(world, position.getXCoord(), position.getYCoord(), position.getZCoord());
                float f3 = world.field_73012_v.nextFloat() * 0.015f - 0.005f;
                entityitem.field_70159_w = (double)((float)world.field_73012_v.nextGaussian() * f3) + motion.getXCoord();
                entityitem.field_70181_x = (double)((float)world.field_73012_v.nextGaussian() * f3) + motion.getYCoord();
                entityitem.field_70179_y = (double)((float)world.field_73012_v.nextGaussian() * f3) + motion.getZCoord();
                this.itemWasLost();
                return entityitem;
            }
            return null;
        }

        @Override
        public void clearDestination() {
            if (this.info.destinationint >= 0) {
                this.itemWasLost();
                this.info.jamlist.add(this.info.destinationint);
            }
            this.info.destinationint = -1;
            this.info.destinationUUID = null;
            this.info._doNotBuffer = false;
            this.info.arrived = false;
            this.info._transportMode = IRoutedItem.TransportMode.Unknown;
            this.info.targetInfo = null;
        }

        public void itemWasLost() {
            if (this.container != null && MainProxy.isClient((IBlockAccess)this.container.func_145831_w())) {
                return;
            }
            IRouter destinationRouter = SimpleServiceLocator.routerManager.getRouter(this.info.destinationint);
            if (destinationRouter != null && destinationRouter.getPipe() != null) {
                destinationRouter.getPipe().notifyOfReroute(this.info);
                if (destinationRouter.getPipe() instanceof IRequireReliableTransport) {
                    ((IRequireReliableTransport)((Object)destinationRouter.getPipe())).itemLost(new ItemIdentifierStack(this.info.getItem()), this.info.targetInfo);
                }
                if (destinationRouter.getPipe() instanceof IRequireReliableFluidTransport && this.info.getItem().getItem().isFluidContainer()) {
                    FluidIdentifierStack liquid = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(this.info.getItem());
                    ((IRequireReliableFluidTransport)((Object)destinationRouter.getPipe())).liquidLost(liquid.getFluid(), liquid.getAmount());
                }
            }
        }

        @Override
        public int getDestination() {
            return this.info.destinationint;
        }

        @Override
        public void setDestination(int destination) {
            this.info.destinationint = destination;
            IRouter router = SimpleServiceLocator.routerManager.getRouter(destination);
            this.info.destinationUUID = router != null ? router.getId() : null;
        }

        @Override
        public void setDoNotBuffer(boolean isBuffered) {
            this.info._doNotBuffer = isBuffered;
        }

        @Override
        public boolean getDoNotBuffer() {
            return this.info._doNotBuffer;
        }

        @Override
        public void setArrived(boolean flag) {
            this.info.arrived = flag;
        }

        @Override
        public boolean getArrived() {
            return this.info.arrived;
        }

        @Override
        public void split(int itemsToTake, EnumFacing orientation) {
            if (this.getItemIdentifierStack().getItem().isFluidContainer()) {
                throw new UnsupportedOperationException("Can't split up a FluidContainer");
            }
            ItemIdentifierStack stackToKeep = this.getItemIdentifierStack();
            ItemIdentifierStack stackToSend = new ItemIdentifierStack(stackToKeep);
            stackToKeep.setStackSize(itemsToTake);
            stackToSend.setStackSize(stackToSend.getStackSize() - itemsToTake);
            this.newId();
            LPTravelingItemServer newItem = new LPTravelingItemServer(stackToSend);
            newItem.setSpeed(this.getSpeed());
            newItem.setTransportMode(this.getTransportMode());
            newItem.setDestination(this.getDestination());
            newItem.clearDestination();
            if (this.container instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)this.container).pipe.transport instanceof PipeTransportLogistics) {
                ((LogisticsTileGenericPipe)this.container).pipe.transport.injectItem((LPTravelingItem)newItem, orientation);
            }
        }

        @Override
        public void setTransportMode(IRoutedItem.TransportMode transportMode) {
            this.info._transportMode = transportMode;
        }

        @Override
        public IRoutedItem.TransportMode getTransportMode() {
            return this.info._transportMode;
        }

        @Override
        public void addToJamList(IRouter router) {
            this.info.jamlist.add(router.getSimpleID());
        }

        @Override
        public List<Integer> getJamList() {
            return this.info.jamlist;
        }

        @Override
        public int getBufferCounter() {
            return this.info.bufferCounter;
        }

        @Override
        public void setBufferCounter(int counter) {
            this.info.bufferCounter = counter;
        }

        @Override
        public UUID getDestinationUUID() {
            return this.info.destinationUUID;
        }

        @Override
        public void checkIDFromUUID() {
            IRouter router = SimpleServiceLocator.routerManager.getRouter(this.info.destinationint);
            if (router == null || this.info.destinationUUID != router.getId()) {
                this.info.destinationint = SimpleServiceLocator.routerManager.getIDforUUID(this.info.destinationUUID);
            }
        }

        public void refreshDestinationInformation() {
            IRouter destinationRouter = SimpleServiceLocator.routerManager.getRouter(this.info.destinationint);
            if (destinationRouter != null && destinationRouter.getPipe() instanceof CoreRoutedPipe) {
                destinationRouter.getPipe().refreshItem(this.getInfo());
            }
        }

        @Override
        public void setDistanceTracker(IDistanceTracker tracker) {
            this.info.tracker = tracker;
        }

        @Override
        public IDistanceTracker getDistanceTracker() {
            return this.info.tracker;
        }

        public void resetDelay() {
            this.info.resetDelay();
        }

        @Override
        public void setAdditionalTargetInformation(IAdditionalTargetInformation targetInfo) {
            this.info.targetInfo = targetInfo;
        }

        @Override
        public IAdditionalTargetInformation getAdditionalTargetInformation() {
            return this.info.targetInfo;
        }

        public void newId() {
            this.id = this.getNextId();
        }

        @Override
        public LPTravelingItem renderCopy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ItemRoutingInformation getInfo() {
            return this.info;
        }
    }

    public static final class LPTravelingItemClient
    extends LPTravelingItem {
        private ItemIdentifierStack item;
        private int age;
        private float hoverStart = (float)(Math.random() * Math.PI * 2.0);

        public LPTravelingItemClient(int id, float position, EnumFacing input, EnumFacing output, float yaw) {
            super(id, position, input, output, yaw);
        }

        public LPTravelingItemClient(int id, ItemIdentifierStack stack) {
            super(id);
            this.item = stack;
        }

        @Override
        public ItemIdentifierStack getItemIdentifierStack() {
            return this.item;
        }

        public void updateInformation(EnumFacing input, EnumFacing output, float speed, float position, float yaw) {
            this.input = input;
            this.output = output;
            this.speed = speed;
            this.position = position;
            this.yaw = yaw;
        }

        @Override
        public int getAge() {
            return 0;
        }

        @Override
        public void addAge() {
            ++this.age;
        }

        @Override
        public float getHoverStart() {
            return 0.0f;
        }

        @Override
        public LPTravelingItem renderCopy() {
            LPTravelingItemClient copy = new LPTravelingItemClient(this.id, this.position, this.input, this.output, this.yaw);
            copy.speed = this.speed;
            copy.hoverStart = this.hoverStart;
            copy.item = new ItemIdentifierStack(this.item);
            copy.age = this.age;
            copy.container = this.container;
            return copy;
        }

        public LPTravelingItemClient setItem(ItemIdentifierStack item) {
            this.item = item;
            return this;
        }
    }
}

