/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ISpecialInsertion;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import network.rs485.logisticspipes.inventory.ProviderMode;

public class InventoryUtil
implements IInventoryUtil,
ISpecialInsertion {
    protected final IItemHandler inventory;
    private final ProviderMode mode;

    public InventoryUtil(IItemHandler inventory, ProviderMode mode) {
        this.inventory = inventory;
        this.mode = mode;
    }

    @Override
    public int itemCount(@Nonnull ItemIdentifier item) {
        int count2 = 0;
        boolean first2 = true;
        for (int i = this.mode.getCropStart(); i < this.inventory.getSlots() - this.mode.getCropEnd(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !ItemIdentifier.get(stack).equals(item)) continue;
            if (first2) {
                count2 = stack.func_190916_E() - (this.mode.getHideOnePerType() || this.mode.getHideOnePerStack() ? 1 : 0);
                first2 = false;
                continue;
            }
            count2 += stack.func_190916_E() - (this.mode.getHideOnePerStack() ? 1 : 0);
        }
        return count2;
    }

    @Override
    @Nonnull
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        LinkedHashMap<ItemIdentifier, Integer> items = new LinkedHashMap<ItemIdentifier, Integer>();
        for (int i = this.mode.getCropStart(); i < this.inventory.getSlots() - this.mode.getCropEnd(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemIdentifier itemId = ItemIdentifier.get(stack);
            int stackSize = stack.func_190916_E() - (this.mode.getHideOnePerStack() ? 1 : 0);
            Integer currentSize = (Integer)items.get(itemId);
            if (currentSize == null) {
                items.put(itemId, stackSize - (this.mode.getHideOnePerType() ? 1 : 0));
                continue;
            }
            items.put(itemId, currentSize + stackSize);
        }
        return items;
    }

    @Override
    @Nonnull
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> items = new TreeSet<ItemIdentifier>();
        for (int i = this.mode.getCropStart(); i < this.inventory.getSlots() - this.mode.getCropEnd(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            items.add(ItemIdentifier.get(stack));
        }
        return items;
    }

    @Override
    @Nonnull
    public ItemStack getSingleItem(ItemIdentifier item) {
        return this.getMultipleItems(item, 1);
    }

    @Override
    @Nonnull
    public ItemStack getMultipleItems(@Nonnull ItemIdentifier item, int count2) {
        if (this.itemCount(item) < count2) {
            return ItemStack.field_190927_a;
        }
        ItemStack outputStack = ItemStack.field_190927_a;
        boolean first2 = true;
        for (int i = this.mode.getCropStart(); i < this.inventory.getSlots() - this.mode.getCropEnd() && count2 > 0; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_190916_E() == 1 && this.mode.getHideOnePerStack() || !ItemIdentifier.get(stack).equals(item)) continue;
            int itemsToSplit = Math.min(count2, stack.func_190916_E() - (first2 && this.mode.getHideOnePerType() || this.mode.getHideOnePerStack() ? 1 : 0));
            first2 = false;
            if (itemsToSplit == 0) continue;
            ItemStack removed = this.inventory.extractItem(i, itemsToSplit, false);
            if (outputStack.func_190926_b()) {
                outputStack = removed;
            } else {
                outputStack.func_190920_e(outputStack.func_190916_E() + removed.func_190916_E());
            }
            count2 -= removed.func_190916_E();
        }
        return outputStack;
    }

    @Override
    public boolean containsUndamagedItem(@Nonnull ItemIdentifier item) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !ItemIdentifier.get(stack).getUndamaged().equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(@Nonnull ItemStack stack) {
        ItemStack leftover;
        if (this.inventory.getSlots() == 1 && this.inventory.getSlotLimit(0) == Integer.MAX_VALUE) {
            ItemStack content = this.inventory.extractItem(0, Integer.MAX_VALUE, true);
            if (content.func_190926_b()) {
                return Integer.MAX_VALUE;
            }
            return Integer.MAX_VALUE - content.func_190916_E();
        }
        int totalRoom = 0;
        for (int i = 0; i < this.inventory.getSlots() && stack.func_190916_E() > totalRoom; totalRoom += stack.func_190916_E() - leftover.func_190916_E(), ++i) {
            leftover = this.inventory.insertItem(i, stack, true);
        }
        return totalRoom;
    }

    @Override
    public int getSizeInventory() {
        return this.inventory.getSlots();
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int i) {
        return this.inventory.getStackInSlot(i);
    }

    @Override
    @Nonnull
    public ItemStack decrStackSize(int i, int j) {
        return this.inventory.extractItem(i, j, false);
    }

    @Override
    public int addToSlot(@Nonnull ItemStack stack, int slot) {
        int wanted = stack.func_190916_E();
        ItemStack rest = this.inventory.insertItem(slot, stack, false);
        return wanted - rest.func_190916_E();
    }
}

