/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.SafeTimeTracker;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class TileBuffer {
    private Block block = null;
    private TileEntity tile;
    private final SafeTimeTracker tracker = new SafeTimeTracker(20L, 5L);
    private final World world;
    private final int x;
    private final int y;
    private final int z;
    private final boolean loadUnloaded;

    public TileBuffer(World world, int x, int y, int z, boolean loadUnloaded) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.loadUnloaded = loadUnloaded;
        this.refresh();
    }

    public void refresh() {
        if (this.tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)this.tile).pipe != null && ((LogisticsTileGenericPipe)this.tile).pipe.preventRemove() && this.world.func_180495_p(new BlockPos(this.x, this.y, this.z)) == null) {
            return;
        }
        this.tile = null;
        this.block = null;
        if (!this.loadUnloaded) {
            return;
        }
        IBlockState blockState = this.world.func_180495_p(new BlockPos(this.x, this.y, this.z));
        Block block = this.block = blockState != null ? blockState.func_177230_c() : null;
        if (this.block != null && this.block.hasTileEntity(this.world.func_180495_p(new BlockPos(this.x, this.y, this.z)))) {
            this.tile = this.world.func_175625_s(new BlockPos(this.x, this.y, this.z));
        }
    }

    public void set(Block block, TileEntity tile) {
        this.block = block;
        this.tile = tile;
        this.tracker.markTime(this.world);
    }

    public Block getBlock() {
        if (this.tile != null && !this.tile.func_145837_r()) {
            return this.block;
        }
        if (this.tracker.markTimeIfDelay(this.world)) {
            this.refresh();
            if (this.tile != null && !this.tile.func_145837_r()) {
                return this.block;
            }
        }
        return null;
    }

    public TileEntity getTile() {
        if (this.tile != null && !this.tile.func_145837_r()) {
            return this.tile;
        }
        if (this.tracker.markTimeIfDelay(this.world)) {
            this.refresh();
            if (this.tile != null && !this.tile.func_145837_r()) {
                return this.tile;
            }
        }
        return null;
    }

    public boolean exists() {
        if (this.tile != null && !this.tile.func_145837_r()) {
            return true;
        }
        IBlockState blockState = this.world.func_180495_p(new BlockPos(this.x, this.y, this.z));
        return blockState != null && blockState.func_177230_c() != null;
    }

    public static TileBuffer[] makeBuffer(World world, BlockPos pos, boolean loadUnloaded) {
        TileBuffer[] buffer = new TileBuffer[6];
        for (int i = 0; i < 6; ++i) {
            EnumFacing d = EnumFacing.func_82600_a((int)i);
            buffer[i] = new TileBuffer(world, pos.func_177958_n() + d.func_82601_c(), pos.func_177956_o() + d.func_96559_d(), pos.func_177952_p() + d.func_82599_e(), loadUnloaded);
        }
        return buffer;
    }
}

