/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.ISaveState;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.inventory.IItemIdentifierInventory;
import network.rs485.logisticspipes.inventory.SlotAccess;
import network.rs485.logisticspipes.util.items.ItemStackLoader;

public class ItemIdentifierInventory
implements ISaveState,
Iterable<Pair<ItemIdentifierStack, Integer>>,
IItemIdentifierInventory {
    private final Object[] ccTypeHolder = new Object[1];
    private final ItemIdentifierStack[] _contents;
    private final String _name;
    private final int _stackLimit;
    @Nonnull
    private final HashMap<ItemIdentifier, Integer> _contentsMap;
    private final HashSet<ItemIdentifier> _contentsUndamagedSet;
    private final HashSet<ItemIdentifier> _contentsNoNBTSet;
    private final HashSet<ItemIdentifier> _contentsUndamagedNoNBTSet;
    private final boolean isLiquidInventory;
    private final LinkedList<ISimpleInventoryEventHandler> _listener = new LinkedList();
    public final SlotAccess slotAccess = new SlotAccess(){

        @Override
        public void mergeSlots(int intoSlot, int fromSlot) {
            if (ItemIdentifierInventory.this._contents[intoSlot] == null) {
                ((ItemIdentifierInventory)ItemIdentifierInventory.this)._contents[intoSlot] = ItemIdentifierInventory.this._contents[fromSlot];
            } else {
                ItemIdentifierInventory.this._contents[intoSlot].setStackSize(ItemIdentifierInventory.this._contents[intoSlot].getStackSize() + ItemIdentifierInventory.this._contents[fromSlot].getStackSize());
            }
            ((ItemIdentifierInventory)ItemIdentifierInventory.this)._contents[fromSlot] = null;
            ItemIdentifierInventory.this.updateContents();
        }

        @Override
        public boolean canMerge(int intoSlot, int fromSlot) {
            return ItemIdentifierInventory.this._contents[intoSlot].getItem().equals(ItemIdentifierInventory.this._contents[fromSlot].getItem());
        }

        @Override
        public boolean isSlotEmpty(int idx) {
            return ItemIdentifierInventory.this._contents[idx] == null;
        }
    };

    public ItemIdentifierInventory(int size, String name, int stackLimit, boolean liquidInv) {
        this._contents = new ItemIdentifierStack[size];
        this._name = name;
        this._stackLimit = stackLimit;
        this._contentsMap = new HashMap((int)((double)size * 1.5));
        this._contentsUndamagedSet = new HashSet((int)((double)size * 1.5));
        this._contentsNoNBTSet = new HashSet((int)((double)size * 1.5));
        this._contentsUndamagedNoNBTSet = new HashSet((int)((double)size * 1.5));
        this.isLiquidInventory = liquidInv;
    }

    public ItemIdentifierInventory(int size, String name, int stackLimit) {
        this(size, name, stackLimit, false);
    }

    public ItemIdentifierInventory(@Nonnull ItemIdentifierInventory copy) {
        this._contents = Arrays.copyOf(copy._contents, copy._contents.length);
        for (int i = 0; i < this._contents.length; ++i) {
            if (copy._contents[i] == null) continue;
            this._contents[i] = new ItemIdentifierStack(copy._contents[i]);
        }
        this._name = copy._name;
        this._stackLimit = copy._stackLimit;
        this._contentsMap = new HashMap<ItemIdentifier, Integer>(copy._contentsMap);
        this._contentsUndamagedSet = new HashSet<ItemIdentifier>(copy._contentsUndamagedSet);
        this._contentsNoNBTSet = new HashSet<ItemIdentifier>(copy._contentsNoNBTSet);
        this._contentsUndamagedNoNBTSet = new HashSet<ItemIdentifier>(copy._contentsUndamagedNoNBTSet);
        this.isLiquidInventory = copy.isLiquidInventory;
    }

    public static void dropItems(World world, @Nonnull ItemStack stack, BlockPos pos) {
        ItemIdentifierInventory.dropItems(world, stack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void dropItems(World world, @Nonnull ItemStack stack, int i, int j, int k) {
        if (stack.func_190926_b()) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, stack);
        entityitem.func_174867_a(10);
        world.func_72838_d((Entity)entityitem);
    }

    public int func_70302_i_() {
        return this._contents.length;
    }

    @Deprecated
    @Nonnull
    public ItemStack func_70301_a(int i) {
        if (this._contents[i] == null) {
            return ItemStack.field_190927_a;
        }
        return this._contents[i].makeNormalStack();
    }

    @Override
    public ItemIdentifierStack getIDStackInSlot(int i) {
        return this._contents[i];
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int count2) {
        if (this._contents[slot] == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = this._contents[slot].makeNormalStack();
        if (this._contents[slot].getStackSize() > count2) {
            ret.func_190920_e(count2);
            this._contents[slot].setStackSize(this._contents[slot].getStackSize() - count2);
        } else {
            this._contents[slot] = null;
        }
        this.updateContents();
        return ret;
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            this._contents[i] = null;
        } else {
            if (this.isInvalidStack(itemstack)) {
                if (LogisticsPipes.isDEBUG()) {
                    new UnsupportedOperationException("Not valid for this Inventory: (" + itemstack + ")").printStackTrace();
                }
                return;
            }
            this._contents[i] = ItemIdentifierStack.getFromStack(itemstack);
        }
        this.updateContents();
    }

    @Override
    public void setInventorySlotContents(int i, ItemIdentifierStack itemstack) {
        if (itemstack == null) {
            this._contents[i] = null;
        } else {
            if (!this.isValidStack(itemstack)) {
                if (LogisticsPipes.isDEBUG()) {
                    new UnsupportedOperationException("Not valid for this Inventory: (" + itemstack + ")").printStackTrace();
                }
                return;
            }
            this._contents[i] = itemstack;
        }
        this.updateContents();
    }

    public int func_70297_j_() {
        return this._stackLimit;
    }

    public void func_70296_d() {
        this.updateContents();
        for (ISimpleInventoryEventHandler handler : this._listener) {
            handler.InventoryChanged(this);
        }
    }

    public boolean func_70300_a(@Nonnull EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound, "");
    }

    public void readFromNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(prefix + "items", (int)nbttagcompound.func_74732_a());
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(j);
            int index = nbttagcompound2.func_74762_e("index");
            if (index < this._contents.length) {
                ItemStack stack = ItemStackLoader.loadAndFixItemStackFromNBT(nbttagcompound2);
                ItemIdentifierStack itemstack = ItemIdentifierStack.getFromStack(stack);
                if (!this.isValidStack(itemstack)) continue;
                this._contents[index] = itemstack;
                continue;
            }
            LogisticsPipes.log.fatal("SimpleInventory: java.lang.ArrayIndexOutOfBoundsException: " + index + " of " + this._contents.length);
        }
        this.updateContents();
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbttagcompound) {
        this.writeToNBT(nbttagcompound, "");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int j = 0; j < this._contents.length; ++j) {
            if (this._contents[j] == null || this._contents[j].getStackSize() <= 0) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            nbttagcompound2.func_74768_a("index", j);
            this._contents[j].unsafeMakeNormalStack().func_77955_b(nbttagcompound2);
        }
        nbttagcompound.func_74782_a(prefix + "items", (NBTBase)nbttaglist);
        nbttagcompound.func_74768_a(prefix + "itemsCount", this._contents.length);
    }

    public void dropContents(World world, BlockPos pos) {
        this.dropContents(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void dropContents(World world, int posX, int posY, int posZ) {
        if (MainProxy.isServer((IBlockAccess)world)) {
            for (int i = 0; i < this._contents.length; ++i) {
                while (this._contents[i] != null) {
                    ItemStack todrop = this.func_70298_a(i, this._contents[i].getItem().getMaxStackSize());
                    ItemIdentifierInventory.dropItems(world, todrop, posX, posY, posZ);
                }
            }
            this.updateContents();
        }
    }

    @Override
    public void addListener(@Nonnull ISimpleInventoryEventHandler listener) {
        if (!this._listener.contains(listener)) {
            this._listener.add(listener);
        }
    }

    @Override
    public void removeListener(@Nonnull ISimpleInventoryEventHandler listener) {
        this._listener.remove(listener);
    }

    @Nonnull
    public ItemStack func_70304_b(int i) {
        if (this._contents[i] == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackToTake = this._contents[i].makeNormalStack();
        this._contents[i] = null;
        this.updateContents();
        return stackToTake;
    }

    @Override
    public void handleItemIdentifierList(Collection<ItemIdentifierStack> _allItems) {
        int i = 0;
        for (ItemIdentifierStack stack : _allItems) {
            if (this._contents.length <= i) break;
            this._contents[i] = stack;
            ++i;
        }
        this.func_70296_d();
    }

    private int tryAddToSlot(int i, @Nonnull ItemStack stack, int realstacklimit) {
        if (this.isInvalidStack(stack)) {
            if (LogisticsPipes.isDEBUG()) {
                new UnsupportedOperationException("Not valid for this Inventory: (" + stack + ")").printStackTrace();
            }
            return 0;
        }
        ItemIdentifierStack slot = this._contents[i];
        if (slot == null) {
            this._contents[i] = ItemIdentifierStack.getFromStack(stack);
            this._contents[i].setStackSize(Math.min(this._contents[i].getStackSize(), realstacklimit));
            return this._contents[i].getStackSize();
        }
        ItemIdentifier stackIdent = ItemIdentifier.get(stack);
        ItemIdentifier slotIdent = slot.getItem();
        if (slotIdent.equals(stackIdent)) {
            slot.setStackSize(slot.getStackSize() + stack.func_190916_E());
            if (slot.getStackSize() > realstacklimit) {
                int ans = stack.func_190916_E() - (slot.getStackSize() - realstacklimit);
                slot.setStackSize(realstacklimit);
                return ans;
            }
            return stack.func_190916_E();
        }
        return 0;
    }

    public int addCompressed(@Nonnull ItemStack stack, boolean ignoreMaxStackSize) {
        int added;
        int i;
        if (stack.func_190926_b()) {
            return 0;
        }
        if (this.isInvalidStack(stack)) {
            if (LogisticsPipes.isDEBUG()) {
                new UnsupportedOperationException("Not valid for this Inventory: (" + stack + ")").printStackTrace();
            }
            return stack.func_190916_E();
        }
        stack = stack.func_77946_l();
        ItemIdentifier stackIdent = ItemIdentifier.get(stack);
        int stacklimit = this._stackLimit;
        if (!ignoreMaxStackSize) {
            stacklimit = Math.min(stacklimit, stackIdent.getMaxStackSize());
        }
        for (i = 0; i < this._contents.length && stack.func_190916_E() > 0; ++i) {
            if (this._contents[i] == null) continue;
            added = this.tryAddToSlot(i, stack, stacklimit);
            stack.func_190920_e(stack.func_190916_E() - added);
        }
        for (i = 0; i < this._contents.length && stack.func_190916_E() > 0; ++i) {
            added = this.tryAddToSlot(i, stack, stacklimit);
            stack.func_190920_e(stack.func_190916_E() - added);
        }
        this.func_70296_d();
        return stack.func_190916_E();
    }

    private void updateContents() {
        this._contentsMap.clear();
        this._contentsUndamagedSet.clear();
        this._contentsNoNBTSet.clear();
        this._contentsUndamagedNoNBTSet.clear();
        for (ItemIdentifierStack _content : this._contents) {
            if (_content == null) continue;
            ItemIdentifier itemId = _content.getItem();
            this._contentsMap.merge(itemId, _content.getStackSize(), Integer::sum);
            this._contentsUndamagedSet.add(itemId.getUndamaged());
            this._contentsNoNBTSet.add(itemId.getIgnoringNBT());
            this._contentsUndamagedNoNBTSet.add(itemId.getIgnoringNBT().getUndamaged());
        }
    }

    @Override
    public int itemCount(@Nonnull ItemIdentifier item) {
        return this._contentsMap.getOrDefault(item, 0);
    }

    @Override
    @Nonnull
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        return this._contentsMap;
    }

    @Override
    public boolean containsItem(ItemIdentifier item) {
        return this._contentsMap.containsKey(item);
    }

    @Override
    public boolean containsUndamagedItem(@Nonnull ItemIdentifier item) {
        return this._contentsUndamagedSet.contains(item);
    }

    @Override
    public boolean containsExcludeNBTItem(@Nonnull ItemIdentifier item) {
        return this._contentsNoNBTSet.contains(item);
    }

    @Override
    public boolean containsUndamagedExcludeNBTItem(@Nonnull ItemIdentifier item) {
        return this._contentsUndamagedNoNBTSet.contains(item);
    }

    public boolean func_191420_l() {
        return this._contentsMap.isEmpty();
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Override
    public void clearInventorySlotContents(int i) {
        this._contents[i] = null;
        this.updateContents();
    }

    @Override
    public void recheckStackLimit() {
        for (ItemIdentifierStack _content : this._contents) {
            if (_content == null) continue;
            _content.setStackSize(Math.min(_content.getStackSize(), this._stackLimit));
        }
    }

    private boolean isInvalidStack(@Nonnull ItemStack stack) {
        if (this.isLiquidInventory && !stack.func_190926_b()) {
            return FluidIdentifier.get(stack) == null;
        }
        return false;
    }

    private boolean isValidStack(ItemIdentifierStack stack) {
        if (stack == null) {
            return true;
        }
        if (this.isLiquidInventory) {
            return FluidIdentifier.get(stack.getItem()) != null;
        }
        return true;
    }

    @Override
    @Nonnull
    public Iterator<Pair<ItemIdentifierStack, Integer>> iterator() {
        final Iterator<ItemIdentifierStack> iter = Arrays.asList(this._contents).iterator();
        return new Iterator<Pair<ItemIdentifierStack, Integer>>(){
            int pos = -1;

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Pair<ItemIdentifierStack, Integer> next() {
                ++this.pos;
                return new Pair<ItemIdentifierStack, Integer>((ItemIdentifierStack)iter.next(), this.pos);
            }
        };
    }

    public void clearGrid() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this._contents[i] = null;
        }
        this.updateContents();
    }

    @Nonnull
    public String func_70005_c_() {
        return this._name;
    }

    public boolean func_145818_k_() {
        return true;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public NonNullList<ItemStack> toNonNullList() {
        NonNullList list = NonNullList.func_191196_a();
        list.addAll(0, (Collection)Arrays.stream(this._contents).filter(Objects::nonNull).map(ItemIdentifierStack::makeNormalStack).collect(Collectors.toList()));
        return list;
    }

    @Override
    @Nonnull
    public List<String> getClientInformation() {
        return Arrays.stream(this._contents).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList());
    }

    @Override
    public Object[] getTypeHolder() {
        return this.ccTypeHolder;
    }

    @Override
    @Nonnull
    public Iterable<Pair<ItemIdentifierStack, Integer>> contents() {
        return this;
    }

    @Override
    @Nonnull
    public SlotAccess getSlotAccess() {
        return this.slotAccess;
    }
}

