/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.Set;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.jvm.functions.Function3;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawableParagraph;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.gui.guidebook.LinkInteractable;
import network.rs485.logisticspipes.util.math.Rectangle;
import network.rs485.markdown.ElementKt;
import network.rs485.markdown.InlineDrawableState;
import network.rs485.markdown.TextFormat;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0016J,\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\n\u0010$\u001a\u00060%R\u00020&H\u0016J\u0018\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0016J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\u0003H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R(\u0010\u0017\u001a\u0004\u0018\u00010\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u00018V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableWord;", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "str", "", "scale", "", "state", "Lnetwork/rs485/markdown/InlineDrawableState;", "linkInteractable", "Lnetwork/rs485/logisticspipes/gui/guidebook/LinkInteractable;", "(Ljava/lang/String;FLnetwork/rs485/markdown/InlineDrawableState;Lnetwork/rs485/logisticspipes/gui/guidebook/LinkInteractable;)V", "color", "", "getColor", "()I", "format", "", "Lnetwork/rs485/markdown/TextFormat;", "getFormat", "()Ljava/util/Set;", "getLinkInteractable", "()Lnetwork/rs485/logisticspipes/gui/guidebook/LinkInteractable;", "value", "parent", "getParent", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "setParent", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;)V", "draw", "", "mouseX", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/math/Rectangle;", "mouseClicked", "guideActionListener", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook$ActionListener;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook;", "setPos", "x", "y", "setupParent", "drawableParagraph", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableParagraph;", "toString", "logisticspipes"})
public class DrawableWord
extends Drawable {
    @NotNull
    private final Set<TextFormat> format;
    private final int color;
    private final String str;
    private final float scale;
    @Nullable
    private final LinkInteractable linkInteractable;

    @NotNull
    public final Set<TextFormat> getFormat() {
        return this.format;
    }

    public final int getColor() {
        return this.color;
    }

    @Override
    @Nullable
    public Drawable getParent() {
        return super.getParent();
    }

    @Override
    public void setParent(@Nullable Drawable value) {
        block1: {
            super.setParent(value);
            Drawable drawable = value;
            if (!(drawable instanceof DrawableParagraph)) {
                drawable = null;
            }
            DrawableParagraph drawableParagraph = (DrawableParagraph)drawable;
            if (drawableParagraph == null) break block1;
            DrawableParagraph drawableParagraph2 = drawableParagraph;
            DrawableWord drawableWord = this;
            boolean bl = false;
            boolean bl2 = false;
            DrawableParagraph p1 = drawableParagraph2;
            boolean bl3 = false;
            drawableWord.setupParent(p1);
        }
    }

    private final void setupParent(DrawableParagraph drawableParagraph) {
        if (this.linkInteractable != null) {
            drawableParagraph.registerPreRenderCallback((Function3<? super Integer, ? super Integer, ? super Rectangle, Unit>)new Function3<Integer, Integer, Rectangle, Unit>(this.linkInteractable){

                public final void invoke(int p1, int p2, @NotNull Rectangle p3) {
                    Intrinsics.checkNotNullParameter(p3, "p3");
                    ((LinkInteractable)this.receiver).updateState(p1, p2, p3);
                }
            });
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, @NotNull Rectangle visibleArea, @NotNull GuiGuideBook.ActionListener guideActionListener) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        Intrinsics.checkNotNullParameter(guideActionListener, "guideActionListener");
        LinkInteractable linkInteractable = this.linkInteractable;
        if (linkInteractable != null) {
            linkInteractable.mouseClicked(mouseX, mouseY, visibleArea, guideActionListener);
        } else {
            super.mouseClicked(mouseX, mouseY, visibleArea, guideActionListener);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float delta, @NotNull Rectangle visibleArea) {
        Set<TextFormat> updatedFormat;
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        LinkInteractable linkInteractable = this.linkInteractable;
        boolean hovering = linkInteractable != null ? linkInteractable.isHovering(mouseX, mouseY, visibleArea) : false;
        LinkInteractable linkInteractable2 = this.linkInteractable;
        int updatedColor = linkInteractable2 != null ? linkInteractable2.updateColor(this.color) : this.color;
        Object object = this.linkInteractable;
        if (object == null || (object = object.updateFormat(this.format)) == null) {
            object = updatedFormat = this.format;
        }
        if (hovering) {
            GuiGuideBook.Companion.drawLinkIndicator(mouseX, mouseY);
        }
        GuiGuideBook.Companion.getLpFontRenderer().drawString(this.str, this.getLeft(), this.getTop(), updatedColor, updatedFormat, this.scale);
    }

    @Override
    public int setPos(int x, int y) {
        this.getRelativeBody$logisticspipes().setPos(x, y);
        return super.setPos(x, y);
    }

    @NotNull
    public String toString() {
        return '\"' + this.str + '\"';
    }

    @Nullable
    protected final LinkInteractable getLinkInteractable() {
        return this.linkInteractable;
    }

    public DrawableWord(@NotNull String str, float scale, @NotNull InlineDrawableState state, @Nullable LinkInteractable linkInteractable) {
        Intrinsics.checkNotNullParameter(str, "str");
        Intrinsics.checkNotNullParameter(state, "state");
        this.str = str;
        this.scale = scale;
        this.linkInteractable = linkInteractable;
        this.format = state.getFormat();
        this.color = state.getColor();
        this.getRelativeBody$logisticspipes().setSize(GuiGuideBook.Companion.getLpFontRenderer().getStringWidth(this.str, ElementKt.italic(this.format), ElementKt.bold(this.format), this.scale), GuiGuideBook.Companion.getLpFontRenderer().getFontHeight(this.scale));
    }
}

