/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf;

import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchThick;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyWater;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import maxhyper.dynamictreesttf.blocks.BlockBranchMagicCore;
import maxhyper.dynamictreesttf.blocks.BlockBranchMagicCoreThick;
import maxhyper.dynamictreesttf.blocks.BlockDynamicTFCicada;
import maxhyper.dynamictreesttf.blocks.BlockDynamicTFFirefly;
import maxhyper.dynamictreesttf.blocks.BlockDynamicTwilightRoots;
import maxhyper.dynamictreesttf.blocks.BlockDynamicTwilightRootsExposed;
import maxhyper.dynamictreesttf.items.ItemMangroveSeed;
import maxhyper.dynamictreesttf.trees.TreeCanopy;
import maxhyper.dynamictreesttf.trees.TreeDarkwood;
import maxhyper.dynamictreesttf.trees.TreeMagicMiners;
import maxhyper.dynamictreesttf.trees.TreeMagicSorting;
import maxhyper.dynamictreesttf.trees.TreeMagicTime;
import maxhyper.dynamictreesttf.trees.TreeMagicTransformation;
import maxhyper.dynamictreesttf.trees.TreeMangrove;
import maxhyper.dynamictreesttf.trees.TreeRainbowOak;
import maxhyper.dynamictreesttf.trees.TreeRobustTwilightOak;
import maxhyper.dynamictreesttf.trees.TreeSicklyTwilightOak;
import maxhyper.dynamictreesttf.trees.TreeTwilightOak;
import maxhyper.dynamictreesttf.trees.species.SpeciesBirchShadow;
import maxhyper.dynamictreesttf.trees.species.SpeciesOakShadow;
import maxhyper.dynamictreesttf.trees.species.SpeciesOakSpooky;
import maxhyper.dynamictreesttf.trees.species.SpeciesSpruceHuge;
import maxhyper.dynamictreesttf.worldgen.BiomeDataBasePopulator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import twilightforest.block.BlockTFCritter;

@Mod.EventBusSubscriber(modid="dynamictreesttf")
@GameRegistry.ObjectHolder(value="dynamictreesttf")
public class ModContent {
    public static ILeavesProperties sicklyTwilightOakLeavesProperties;
    public static ILeavesProperties canopyLeavesProperties;
    public static ILeavesProperties spookyCanopyLeavesProperties;
    public static ILeavesProperties mangroveLeavesProperties;
    public static ILeavesProperties darkwoodLeavesProperties;
    public static ILeavesProperties rainbowOakLeavesProperties;
    public static ILeavesProperties robustTwilightOakLeavesProperties;
    public static ILeavesProperties timeLeavesProperties;
    public static ILeavesProperties transformationLeavesProperties;
    public static ILeavesProperties minersLeavesProperties;
    public static ILeavesProperties sortingLeavesProperties;
    public static ILeavesProperties shadowOakLeavesProperties;
    public static ILeavesProperties shadowBirchLeavesProperties;
    public static BlockTFCritter dynamicCicada;
    public static BlockTFCritter dynamicFirefly;
    public static BlockDynamicTwilightRoots undergroundRoot;
    public static BlockDynamicTwilightRoots undergroundRootExposed;
    @Deprecated
    public static BlockDynamicTwilightRoots undergroundMangroveRoot;
    public static BlockBranch minerCoreBranch;
    public static BlockBranch minerCoreBranchOff;
    public static BlockBranch sortingCoreBranch;
    public static BlockBranch sortingCoreBranchOff;
    public static BlockBranch transformCoreBranch;
    public static BlockBranch transformCoreBranchOff;
    public static BlockBranch timeCoreBranch;
    public static BlockBranch timeCoreBranchOff;
    public static BlockRootyWater blockRootyWater;
    public static Species hugeSpruce;
    public static Species spookyOak;
    public static Species shadowOak;
    public static Species shadowBirch;
    public static Seed mangroveSeed;
    public static ArrayList<TreeFamily> trees;

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        minerCoreBranch = new BlockBranchMagicCore("minersTreeCoreBranch", BlockBranchMagicCore.Types.MINE){

            public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
                return TreeMagicMiners.branch.getPickBlock(state, target, world, pos, player);
            }
        };
        minerCoreBranchOff = new BlockBranchMagicCore("minersTreeCoreBranchOff", BlockBranchMagicCore.Types.MINE){

            public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
                return TreeMagicMiners.branch.getPickBlock(state, target, world, pos, player);
            }
        };
        sortingCoreBranch = new BlockBranchMagicCore("sortingTreeCoreBranch", BlockBranchMagicCore.Types.SORT){

            public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
                return TreeMagicSorting.branch.getPickBlock(state, target, world, pos, player);
            }
        };
        sortingCoreBranchOff = new BlockBranchMagicCore("sortingTreeCoreBranchOff", BlockBranchMagicCore.Types.SORT){

            public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
                return TreeMagicSorting.branch.getPickBlock(state, target, world, pos, player);
            }
        };
        timeCoreBranch = new BlockBranchMagicCoreThick("treeOfTimeCoreBranch", BlockBranchMagicCore.Types.TIME){

            public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
                return TreeMagicTime.branch.getPickBlock(state, target, world, pos, player);
            }
        };
        timeCoreBranchOff = new BlockBranchMagicCoreThick("treeOfTimeCoreBranchOff", BlockBranchMagicCore.Types.TIME){

            public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
                return TreeMagicTime.branch.getPickBlock(state, target, world, pos, player);
            }
        };
        transformCoreBranch = new BlockBranchMagicCore("treeOfTransformationCoreBranch", BlockBranchMagicCore.Types.TRANS){

            public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
                return TreeMagicTransformation.branch.getPickBlock(state, target, world, pos, player);
            }
        };
        transformCoreBranchOff = new BlockBranchMagicCore("treeOfTransformationCoreBranchOff", BlockBranchMagicCore.Types.TRANS){

            public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
                return TreeMagicTransformation.branch.getPickBlock(state, target, world, pos, player);
            }
        };
        ((BlockBranchMagicCore)minerCoreBranch).setOffBlock((BlockBranchMagicCore)minerCoreBranchOff);
        ((BlockBranchMagicCore)sortingCoreBranch).setOffBlock((BlockBranchMagicCore)sortingCoreBranchOff);
        ((BlockBranchMagicCoreThick)timeCoreBranch).setOffBlock((BlockBranchMagicCoreThick)timeCoreBranchOff);
        ((BlockBranchMagicCore)transformCoreBranch).setOffBlock((BlockBranchMagicCore)transformCoreBranchOff);
        blockRootyWater = new BlockRootyWater(false);
        registry.register((IForgeRegistryEntry)blockRootyWater);
        undergroundRoot = new BlockDynamicTwilightRoots();
        registry.register(undergroundRoot.setRegistryName("dynamictreesttf", "underground_roots"));
        undergroundMangroveRoot = new BlockDynamicTwilightRoots(){

            @Override
            public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
                if (((Boolean)state.func_177229_b((IProperty)GRASSY)).booleanValue()) {
                    worldIn.func_175656_a(pos, Blocks.field_150349_c.func_176223_P());
                    if (worldIn.func_175623_d(pos.func_177984_a()) && (double)worldIn.field_73012_v.nextFloat() < 0.5) {
                        TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesttf", "mangrove")).plantSapling(worldIn, pos.func_177984_a());
                    }
                } else {
                    worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
                }
            }

            @Override
            public void func_176206_d(World world, BlockPos pos, IBlockState state) {
                super.func_176206_d(world, pos, state);
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        };
        registry.register(undergroundMangroveRoot.setRegistryName("dynamictreesttf", "underground_roots_mangrove"));
        undergroundRootExposed = new BlockDynamicTwilightRootsExposed();
        registry.register(undergroundRootExposed.setRegistryName("dynamictreesttf", "underground_roots_exposed"));
        dynamicCicada = new BlockDynamicTFCicada();
        registry.register(dynamicCicada.setRegistryName("dynamictreesttf", "dynamic_cicada"));
        dynamicFirefly = new BlockDynamicTFFirefly();
        registry.register(dynamicFirefly.setRegistryName("dynamictreesttf", "dynamic_firefly"));
        sicklyTwilightOakLeavesProperties = ModContent.setUpLeaves(TreeTwilightOak.leavesState, "deciduous");
        canopyLeavesProperties = ModContent.setUpLeaves(TreeCanopy.leavesState, "acacia");
        spookyCanopyLeavesProperties = new LeavesProperties(TreeCanopy.leavesBlock.func_176223_P(), ItemStack.field_190927_a, TreeRegistry.findCellKit((String)"bare")){};
        mangroveLeavesProperties = ModContent.setUpLeaves(TreeMangrove.leavesState, "acacia");
        darkwoodLeavesProperties = ModContent.setUpLeaves(TreeDarkwood.leavesState, "acacia", 0, 0);
        robustTwilightOakLeavesProperties = ModContent.setUpLeaves(TreeTwilightOak.leavesState, "deciduous", 0, 13);
        rainbowOakLeavesProperties = ModContent.setUpLeaves(TreeRainbowOak.leavesState, "deciduous");
        timeLeavesProperties = ModContent.setUpLeaves(TreeMagicTime.leavesBlock, 0, "deciduous");
        transformationLeavesProperties = ModContent.setUpLeaves(TreeMagicTransformation.leavesBlock, 1, "acacia");
        minersLeavesProperties = ModContent.setUpLeaves(TreeMagicMiners.leavesBlock, 2, "deciduous", 4, 5);
        sortingLeavesProperties = ModContent.setUpLeaves(TreeMagicSorting.leavesBlock, 3, "deciduous", 8, 13);
        shadowOakLeavesProperties = ModContent.setUpLeaves(Blocks.field_150362_t.func_176203_a(0), "deciduous", 4, 0);
        shadowBirchLeavesProperties = ModContent.setUpLeaves(Blocks.field_150362_t.func_176203_a(1), "deciduous", 4, 0);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesttf", (int)0, (ILeavesProperties)sicklyTwilightOakLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesttf", (int)1, (ILeavesProperties)robustTwilightOakLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesttf", (int)2, (ILeavesProperties)rainbowOakLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesttf", (int)3, (ILeavesProperties)shadowOakLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesttf", (int)4, (ILeavesProperties)canopyLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesttf", (int)5, (ILeavesProperties)mangroveLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesttf", (int)6, (ILeavesProperties)shadowBirchLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesttf", (int)7, (ILeavesProperties)spookyCanopyLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesttf", (int)8, (ILeavesProperties)timeLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesttf", (int)10, (ILeavesProperties)minersLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesttf", (int)11, (ILeavesProperties)sortingLeavesProperties);
        TreeFamily oakTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oak")).getFamily();
        TreeFamily birchTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "birch")).getFamily();
        TreeFamily spruceTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "spruce")).getFamily();
        mangroveSeed = new ItemMangroveSeed("mangroveseed");
        SpeciesSpruceHuge hugeSpruce = new SpeciesSpruceHuge(spruceTree);
        SpeciesOakSpooky spookyOak = new SpeciesOakSpooky(oakTree);
        SpeciesOakShadow shadowOak = new SpeciesOakShadow(oakTree);
        SpeciesBirchShadow shadowBirch = new SpeciesBirchShadow(birchTree);
        Species.REGISTRY.registerAll((IForgeRegistryEntry[])new Species[]{hugeSpruce, spookyOak, shadowOak, shadowBirch});
        TreeTwilightOak twilightOakTree = new TreeTwilightOak();
        TreeCanopy canopyTree = new TreeCanopy();
        TreeMangrove mangroveTree = new TreeMangrove();
        TreeDarkwood darkwoodTree = new TreeDarkwood();
        TreeMagicTime timeTree = new TreeMagicTime();
        TreeMagicTransformation transformationTree = new TreeMagicTransformation();
        TreeMagicMiners minersTree = new TreeMagicMiners();
        TreeMagicSorting sortingTree = new TreeMagicSorting();
        TreeRainbowOak rainbowOakTree = new TreeRainbowOak();
        Collections.addAll(trees, new TreeFamily[]{twilightOakTree, canopyTree, mangroveTree, darkwoodTree, timeTree, transformationTree, minersTree, sortingTree, rainbowOakTree});
        TreeRobustTwilightOak robustTwilightOakTree = new TreeRobustTwilightOak();
        TreeSicklyTwilightOak sicklytwilightOakTree = new TreeSicklyTwilightOak();
        Collections.addAll(trees, new TreeFamily[]{sicklytwilightOakTree, robustTwilightOakTree});
        trees.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        ArrayList treeBlocks = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableBlocks((List)treeBlocks));
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"dynamictreesttf").values());
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[treeBlocks.size()]));
        DirtHelper.registerSoil((Block)undergroundRoot, (String)"dirtlike");
        DirtHelper.registerSoil((Block)blockRootyWater, (String)"waterlike");
    }

    private static ILeavesProperties setUpLeaves(final Block leavesBlock, final int leavesMeta, String cellKit, final int smother, final int light) {
        LeavesProperties leavesProperties = new LeavesProperties(leavesBlock.func_176203_a(leavesMeta), TreeRegistry.findCellKit((String)cellKit)){

            public int getSmotherLeavesMax() {
                return smother;
            }

            public int getLightRequirement() {
                return light;
            }

            public ItemStack getPrimitiveLeavesItemStack() {
                return new ItemStack(leavesBlock, 1, leavesMeta);
            }
        };
        return leavesProperties;
    }

    private static ILeavesProperties setUpLeaves(IBlockState leavesState, String cellKit, int smother, int light) {
        return ModContent.setUpLeaves(leavesState.func_177230_c(), leavesState.func_177230_c().func_176201_c(leavesState), cellKit, smother, light);
    }

    private static ILeavesProperties setUpLeaves(IBlockState leavesState, String cellKit) {
        return ModContent.setUpLeaves(leavesState, cellKit, 4, 13);
    }

    private static ILeavesProperties setUpLeaves(Block leavesBlock, int leavesMeta, String cellKit) {
        return ModContent.setUpLeaves(leavesBlock.func_176203_a(leavesMeta), cellKit);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(new ItemBlock((Block)minerCoreBranch).setRegistryName(Objects.requireNonNull(minerCoreBranch.getRegistryName())));
        registry.register(new ItemBlock((Block)sortingCoreBranch).setRegistryName(Objects.requireNonNull(sortingCoreBranch.getRegistryName())));
        registry.register(new ItemBlock((Block)timeCoreBranch).setRegistryName(Objects.requireNonNull(timeCoreBranch.getRegistryName())));
        registry.register(new ItemBlock((Block)transformCoreBranch).setRegistryName(Objects.requireNonNull(transformCoreBranch.getRegistryName())));
        ArrayList treeItems = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableItems((List)treeItems));
        registry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[treeItems.size()]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModContent.setUpSeedRecipes("twilightOakSickly", new ItemStack(TreeTwilightOak.saplingBlock, 1, TreeTwilightOak.saplingMeta));
        ModContent.setUpSeedRecipes("twilightOakRobust", new ItemStack(TreeTwilightOak.saplingBlock, 1, TreeTwilightOak.saplingMetaRobust));
        ModContent.setUpSeedRecipes("canopy", new ItemStack(TreeCanopy.saplingBlock, 1, TreeCanopy.saplingMeta));
        ModContent.setUpSeedRecipes("mangrove", new ItemStack(TreeMangrove.saplingBlock, 1, TreeMangrove.saplingMeta));
        ModContent.setUpSeedRecipes("darkwood", new ItemStack(TreeDarkwood.saplingBlock, 1, TreeDarkwood.saplingMeta));
        ModContent.setUpSeedRecipes("treeOfTime", new ItemStack(TreeMagicTime.saplingBlock, 1, TreeMagicTime.saplingMeta));
        ModContent.setUpSeedRecipes("treeOfTransformation", new ItemStack(TreeMagicTransformation.saplingBlock, 1, TreeMagicTransformation.saplingMeta));
        ModContent.setUpSeedRecipes("minersTree", new ItemStack(TreeMagicMiners.saplingBlock, 1, TreeMagicMiners.saplingMeta));
        ModContent.setUpSeedRecipes("sortingTree", new ItemStack(TreeMagicSorting.saplingBlock, 1, TreeMagicSorting.saplingMeta));
        ModContent.setUpSeedRecipes("rainbowOak", new ItemStack(TreeRainbowOak.saplingBlock, 1, TreeRainbowOak.saplingMeta));
    }

    private static void setUpSeedRecipes(String name, ItemStack treeSapling) {
        Species treeSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesttf", name));
        ItemStack treeSeed = treeSpecies.getSeedStack(1);
        ItemStack treeTransformationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), treeSpecies.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)treeSeed, (ItemStack)treeTransformationPotion);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)treeSapling, (ItemStack)treeSeed, (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (TreeFamily tree : trees) {
            ModelHelper.regModel((Block)tree.getDynamicBranch());
            ModelHelper.regModel((Item)tree.getCommonSpecies().getSeed());
            ModelHelper.regModel((TreeFamily)tree);
        }
        ModelHelper.regModel((Item)TreeTwilightOak.sicklySpecies.getSeed());
        LeavesPaging.getLeavesMapForModId((String)"dynamictreesttf").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
        ModelLoader.setCustomStateMapper((Block)TreeDarkwood.darkwoodLeaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178442_a(new IProperty[]{BlockDynamicLeaves.HYDRO}).func_178442_a(new IProperty[]{BlockDynamicLeaves.TREE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)TreeMagicTransformation.transformationLeaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178442_a(new IProperty[]{BlockDynamicLeaves.HYDRO}).func_178442_a(new IProperty[]{BlockDynamicLeaves.TREE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)dynamicCicada, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDirectional.field_176387_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)dynamicFirefly, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDirectional.field_176387_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)undergroundMangroveRoot, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)undergroundRootExposed, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)undergroundRoot, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)minerCoreBranch, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)minerCoreBranchOff, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)sortingCoreBranch, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)sortingCoreBranchOff, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)timeCoreBranch, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUSNYBBLE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)((BlockBranchThick)ModContent.timeCoreBranch).otherBlock, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUSNYBBLE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)timeCoreBranchOff, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUSNYBBLE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)((BlockBranchThick)ModContent.timeCoreBranchOff).otherBlock, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUSNYBBLE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)transformCoreBranch, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)transformCoreBranchOff, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicTwilightRoots.RADIUS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)blockRootyWater, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRootyWater.LIFE, BlockLiquid.field_176367_b}).func_178441_a());
    }

    static {
        trees = new ArrayList();
    }
}

