/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import maxhyper.dynamictreesttf.blocks.BlockBranchTwilight;
import maxhyper.dynamictreesttf.blocks.BlockDynamicTwilightRoots;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import twilightforest.biomes.TFBiomes;
import twilightforest.item.ItemTFOreMagnet;
import twilightforest.network.PacketChangeBiome;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.WorldUtil;

public class BlockBranchMagicCore
extends BlockBranchTwilight {
    private Types coreType;
    protected boolean isOn;
    public BlockBranchMagicCore switchedBlock;

    public BlockBranchMagicCore(String name, Types type) {
        super(name);
        this.coreType = type;
    }

    public BlockBranchMagicCore setOffBlock(BlockBranchMagicCore switchBlock) {
        this.switchedBlock = switchBlock;
        switchBlock.switchedBlock = this;
        this.isOn = true;
        switchBlock.isOn = false;
        this.func_149675_a(true);
        return this;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 15;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return false;
    }

    public int func_149738_a(World par1World) {
        return 20;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K || !this.isOn) {
            return;
        }
        switch (this.coreType) {
            case TRANS: {
                world.func_184133_a(null, pos, SoundEvents.field_187682_dG, SoundCategory.BLOCKS, 0.1f, rand.nextFloat() * 2.0f);
                this.doTreeOfTransformationEffect(world, pos, rand);
                break;
            }
            case MINE: {
                this.doMinersTreeEffect(world, pos, rand);
                break;
            }
            case SORT: {
                this.doSortingTreeEffect(world, pos, rand);
                break;
            }
        }
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (this.isOn) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean placedCritter = super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        if (!placedCritter) {
            worldIn.func_175656_a(pos, this.switchedBlock.func_176223_P().func_177226_a((IProperty)BlockDynamicTwilightRoots.RADIUS, worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockDynamicTwilightRoots.RADIUS)));
        }
        return true;
    }

    private void doTreeOfTransformationEffect(World world, BlockPos pos, Random rand) {
        Biome targetBiome = TFBiomes.enchantedForest;
        for (int i = 0; i < 16; ++i) {
            Biome biomeAt;
            BlockPos dPos = WorldUtil.randomOffset((Random)rand, (BlockPos)pos, (int)16, (int)0, (int)16);
            if (dPos.func_177951_i((Vec3i)pos) > 256.0 || (biomeAt = world.func_180494_b(dPos)) == targetBiome) continue;
            Chunk chunkAt = world.func_175726_f(dPos);
            chunkAt.func_76605_m()[(dPos.func_177952_p() & 0xF) << 4 | dPos.func_177958_n() & 0xF] = (byte)Biome.func_185362_a((Biome)targetBiome);
            if (!(world instanceof WorldServer)) break;
            this.sendChangedBiome(world, dPos, targetBiome);
            break;
        }
    }

    private void sendChangedBiome(World world, BlockPos pos, Biome biome) {
        PacketChangeBiome message = new PacketChangeBiome(pos, biome);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 128.0);
        TFPacketHandler.CHANNEL.sendToAllTracking((IMessage)message, targetPoint);
    }

    private void doMinersTreeEffect(World world, BlockPos pos, Random rand) {
        BlockPos dPos = WorldUtil.randomOffset((Random)rand, (BlockPos)pos, (int)32);
        int moved = ItemTFOreMagnet.doMagnet((World)world, (BlockPos)pos, (BlockPos)dPos);
        if (moved > 0) {
            world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.1f, 1.0f);
        }
    }

    private void doSortingTreeEffect(World world, BlockPos pos, Random rand) {
        ArrayList<IInventory> chests = new ArrayList<IInventory>();
        int itemCount = 0;
        for (BlockPos iterPos : WorldUtil.getAllAround((BlockPos)pos, (int)16)) {
            TileEntity te;
            ILockableContainer chestInventory = null;
            IInventory teInventory = null;
            Block block = world.func_180495_p(iterPos).func_177230_c();
            if (block instanceof BlockChest) {
                chestInventory = ((BlockChest)block).func_189418_a(world, iterPos, true);
            }
            if ((te = world.func_175625_s(iterPos)) instanceof IInventory && !te.func_145837_r()) {
                teInventory = (IInventory)te;
            }
            if (chestInventory == null || teInventory == null || this.checkIfChestsContains(chests, teInventory)) continue;
            boolean empty = true;
            for (int i = 0; i < chestInventory.func_70302_i_(); ++i) {
                if (chestInventory.func_70301_a(i).func_190926_b()) continue;
                empty = false;
                ++itemCount;
            }
            if (empty) continue;
            chests.add((IInventory)chestInventory);
        }
        ItemStack beingSorted = ItemStack.field_190927_a;
        int sortedChestNum = -1;
        int sortedSlotNum = -1;
        if (itemCount == 0) {
            return;
        }
        int itemNumber = rand.nextInt(itemCount);
        int currentNumber = 0;
        for (int i = 0; i < chests.size(); ++i) {
            IInventory chest = (IInventory)chests.get(i);
            for (int slotNum = 0; slotNum < chest.func_70302_i_(); ++slotNum) {
                ItemStack currentItem = chest.func_70301_a(slotNum);
                if (currentItem.func_190926_b() || currentNumber++ != itemNumber) continue;
                beingSorted = currentItem;
                sortedChestNum = i;
                sortedSlotNum = slotNum;
            }
        }
        if (beingSorted.func_190926_b()) {
            return;
        }
        int matchChestNum = -1;
        int matchCount = 0;
        for (int chestNum = 0; chestNum < chests.size(); ++chestNum) {
            IInventory chest = (IInventory)chests.get(chestNum);
            int currentChestMatches = 0;
            for (int slotNum = 0; slotNum < chest.func_70302_i_(); ++slotNum) {
                ItemStack currentItem = chest.func_70301_a(slotNum);
                if (currentItem.func_190926_b() || !this.isSortingMatch(beingSorted, currentItem)) continue;
                currentChestMatches += currentItem.func_190916_E();
            }
            if (currentChestMatches <= matchCount) continue;
            matchCount = currentChestMatches;
            matchChestNum = chestNum;
        }
        if (matchChestNum >= 0 && matchChestNum != sortedChestNum) {
            IInventory moveChest = (IInventory)chests.get(matchChestNum);
            IInventory oldChest = (IInventory)chests.get(sortedChestNum);
            int moveSlot = this.getEmptySlotIn(moveChest);
            if (moveSlot >= 0) {
                oldChest.func_70299_a(sortedSlotNum, ItemStack.field_190927_a);
                moveChest.func_70299_a(moveSlot, beingSorted);
            }
        }
        if (beingSorted.func_190916_E() < beingSorted.func_77976_d()) {
            for (IInventory chest : chests) {
                for (int slotNum = 0; slotNum < chest.func_70302_i_(); ++slotNum) {
                    ItemStack currentItem = chest.func_70301_a(slotNum);
                    if (currentItem.func_190926_b() || currentItem == beingSorted || !beingSorted.func_77969_a(currentItem) || currentItem.func_190916_E() > beingSorted.func_77976_d() - beingSorted.func_190916_E()) continue;
                    chest.func_70299_a(slotNum, ItemStack.field_190927_a);
                    beingSorted.func_190917_f(currentItem.func_190916_E());
                    currentItem.func_190920_e(0);
                }
            }
        }
    }

    private boolean isSortingMatch(ItemStack beingSorted, ItemStack currentItem) {
        return beingSorted.func_77973_b().func_77640_w() == currentItem.func_77973_b().func_77640_w();
    }

    private boolean checkIfChestsContains(List<IInventory> chests, IInventory testChest) {
        for (IInventory chest : chests) {
            if (chest == testChest) {
                return true;
            }
            if (!(chest instanceof InventoryLargeChest) || !((InventoryLargeChest)chest).func_90010_a(testChest)) continue;
            return true;
        }
        return false;
    }

    private int getEmptySlotIn(IInventory chest) {
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (!chest.func_70301_a(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static enum Types {
        TIME,
        MINE,
        SORT,
        TRANS;

    }
}

