/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.genfeatures;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGrowFeature;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import java.util.Random;
import maxhyper.dynamictreesttf.blocks.BlockDynamicTwilightRoots;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenUndergroundRoots
implements IPostGenFeature,
IPostGrowFeature {
    public BlockDynamicTwilightRoots rootsDirt;
    public BlockDynamicTwilightRoots rootsExposed;
    public int rootBranchChance;
    public int maxRadius;
    public int rootGrowChance;
    public int worldgenAttempts = 20;
    public int maxDepth = 20;
    EnumFacing[] dirsExceptUp = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
    EnumFacing[] dirsAll = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP};

    public FeatureGenUndergroundRoots(BlockDynamicTwilightRoots rootDirt, BlockDynamicTwilightRoots root, int maxRootRadius, int branchChance, int growChance) {
        this.rootsDirt = rootDirt;
        this.rootsExposed = root;
        this.rootBranchChance = branchChance;
        this.maxRadius = Math.min(maxRootRadius, 8);
        this.rootGrowChance = growChance;
    }

    private boolean isGroundBlock(Block block) {
        return DirtHelper.isSoilAcceptable((Block)block, (int)DirtHelper.getSoilFlags((String[])new String[]{"dirtlike"}));
    }

    private boolean isGrassBlock(Block block) {
        return block == Blocks.field_150349_c;
    }

    private boolean isRootBlock(Block block) {
        return block == this.rootsDirt || block == this.rootsExposed;
    }

    private boolean checkAvailableAround(World world, BlockPos blockPos, EnumFacing cameFrom) {
        for (int i = 0; i < 6; ++i) {
            if (this.dirsAll[i] == cameFrom) continue;
            if (world.func_175667_e(blockPos.func_177972_a(this.dirsAll[i]))) {
                IBlockState offsetState = world.func_180495_p(blockPos.func_177972_a(this.dirsAll[i]));
                if (!offsetState.func_177228_b().containsKey((Object)BlockDynamicTwilightRoots.RADIUS)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private EnumFacing findRandomFreeDir(World world, BlockPos blockPos, Random rand, EnumFacing cameFrom, BlockPos rootPos) {
        if (rand.nextInt(3) == 0) {
            return null;
        }
        EnumFacing[] possibleDirections = new EnumFacing[5];
        int dirCount = 0;
        for (int i = 0; i < 5; ++i) {
            if (this.dirsExceptUp[i] == cameFrom) continue;
            IBlockState offsetState = world.func_180495_p(blockPos.func_177972_a(this.dirsExceptUp[i]));
            Block offsetBlock = world.func_180495_p(blockPos.func_177972_a(this.dirsExceptUp[i])).func_177230_c();
            if (!world.func_175623_d(blockPos.func_177972_a(this.dirsExceptUp[i])) && offsetBlock != Blocks.field_150355_j && offsetBlock != Blocks.field_150358_i && !this.isGroundBlock(offsetState.func_177230_c()) || !this.checkAvailableAround(world, blockPos.func_177972_a(this.dirsExceptUp[i]), this.dirsExceptUp[i].func_176734_d())) continue;
            if (this.dirsExceptUp[i] == EnumFacing.DOWN && rand.nextInt(8) != 0) {
                return EnumFacing.DOWN;
            }
            possibleDirections[dirCount] = this.dirsExceptUp[i];
            ++dirCount;
        }
        if (dirCount == 0) {
            return null;
        }
        return possibleDirections[rand.nextInt(dirCount)];
    }

    private EnumFacing findRandomRootDir(World world, BlockPos blockPos, Random rand, EnumFacing cameFrom, BlockPos rootPos) {
        EnumFacing[] possibleDirections = new EnumFacing[5];
        int dirCount = 0;
        for (int i = 0; i < 5; ++i) {
            IBlockState offsetState;
            if (this.dirsExceptUp[i] == cameFrom || !this.isRootBlock((offsetState = world.func_180495_p(blockPos.func_177972_a(this.dirsExceptUp[i]))).func_177230_c())) continue;
            if (this.dirsExceptUp[i] == EnumFacing.DOWN && rand.nextInt(4) != 0) {
                return EnumFacing.DOWN;
            }
            possibleDirections[dirCount] = this.dirsExceptUp[i];
            ++dirCount;
        }
        if (dirCount == 0) {
            return this.findRandomFreeDir(world, blockPos, rand, cameFrom, rootPos);
        }
        return possibleDirections[rand.nextInt(dirCount)];
    }

    private boolean isOverRootBlock(BlockPos pos, BlockPos rootPos) {
        return this.offsetSpawn(pos, true) != rootPos;
    }

    public BlockPos offsetSpawn(BlockPos root) {
        return this.offsetSpawn(root, false);
    }

    public BlockPos offsetSpawn(BlockPos root, boolean invert) {
        if (invert) {
            return root.func_177984_a();
        }
        return root.func_177977_b();
    }

    private boolean cancelGrowChance(Random rand) {
        return rand.nextInt(2) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean iterateRootGrow(World world, BlockPos blockPos, Random rand, int radius, EnumFacing cameFrom, BlockPos rootPos, int currentStep) {
        if (world.func_180495_p(rootPos).func_177230_c() != ModBlocks.blockRootyDirt) {
            return false;
        }
        if (currentStep > this.maxDepth) {
            return false;
        }
        IBlockState state = world.func_180495_p(blockPos);
        if (this.isRootBlock(state.func_177230_c())) {
            int currentRadius = (Integer)state.func_177229_b((IProperty)BlockDynamicTwilightRoots.RADIUS);
            boolean grow = this.isOverRootBlock(blockPos, rootPos) && currentRadius < radius && currentRadius < 8;
            radius = currentRadius;
            world.func_175656_a(blockPos, state.func_177226_a((IProperty)BlockDynamicTwilightRoots.RADIUS, (Comparable)Integer.valueOf(currentRadius + (grow ? 1 : 0))));
        } else if (world.func_175623_d(blockPos)) {
            if (this.cancelGrowChance(rand)) return false;
            world.func_175656_a(blockPos, this.rootsExposed.func_176223_P().func_177226_a((IProperty)BlockDynamicTwilightRoots.RADIUS, (Comparable)Integer.valueOf(radius > 4 ? radius / 2 : 2)));
        } else {
            if (!this.isGroundBlock(state.func_177230_c())) return false;
            world.func_175656_a(blockPos, this.rootsDirt.func_176223_P().func_177226_a((IProperty)BlockDynamicTwilightRoots.RADIUS, (Comparable)Integer.valueOf(radius > 4 ? radius / 2 : 2)).func_177226_a((IProperty)BlockDynamicTwilightRoots.GRASSY, (Comparable)Boolean.valueOf(this.isGrassBlock(state.func_177230_c()))));
        }
        if ((double)rand.nextFloat() <= 0.2) {
            --radius;
        }
        if (radius <= 0) return true;
        EnumFacing chosenDir = this.findRandomRootDir(world, blockPos, rand, cameFrom, rootPos);
        if (chosenDir == null) {
            return true;
        }
        this.iterateRootGrow(world, blockPos.func_177972_a(chosenDir), rand, radius, chosenDir.func_176734_d(), rootPos, currentStep + 1);
        if (rootPos.func_177956_o() != blockPos.func_177956_o() && rand.nextInt(this.rootBranchChance) != 0) return true;
        chosenDir = this.findRandomFreeDir(world, blockPos, rand, cameFrom, rootPos);
        if (chosenDir == null) {
            return true;
        }
        this.iterateRootGrow(world, blockPos.func_177972_a(chosenDir), rand, radius, chosenDir.func_176734_d(), rootPos, currentStep + 1);
        return true;
    }

    public boolean postGeneration(World world, BlockPos blockPos, Species species, Biome biome, int i, List<BlockPos> list, SafeChunkBounds safeChunkBounds, IBlockState iBlockState) {
        boolean placed;
        Random rand = new Random();
        if (!world.func_180495_p(this.offsetSpawn(blockPos)).func_177228_b().containsKey((Object)BlockDynamicTwilightRoots.RADIUS) && !(placed = this.iterateRootGrow(world, this.offsetSpawn(blockPos), rand, 2, EnumFacing.UP, blockPos, 0))) {
            return false;
        }
        for (int a = this.worldgenAttempts; a > 0; --a) {
            int radius = (Integer)world.func_180495_p(this.offsetSpawn(blockPos)).func_177229_b((IProperty)BlockDynamicTwilightRoots.RADIUS);
            int bound = radius / 2 * this.rootGrowChance;
            boolean grow = bound > 0 && rand.nextInt(bound) == 0;
            this.iterateRootGrow(world, this.offsetSpawn(blockPos), rand, (Integer)world.func_180495_p(this.offsetSpawn(blockPos)).func_177229_b((IProperty)BlockDynamicTwilightRoots.RADIUS) + (grow ? 1 : 0), EnumFacing.UP, blockPos, 0);
        }
        return true;
    }

    public boolean postGrow(World world, BlockPos blockPos, BlockPos blockPos1, Species species, int i, boolean b) {
        Random rand = new Random();
        if (!world.func_180495_p(this.offsetSpawn(blockPos)).func_177228_b().containsKey((Object)BlockDynamicTwilightRoots.RADIUS)) {
            return this.iterateRootGrow(world, this.offsetSpawn(blockPos), rand, 2, EnumFacing.UP, blockPos, 0);
        }
        if ((Integer)world.func_180495_p(this.offsetSpawn(blockPos)).func_177229_b((IProperty)BlockDynamicTwilightRoots.RADIUS) < this.maxRadius) {
            int radius = (Integer)world.func_180495_p(this.offsetSpawn(blockPos)).func_177229_b((IProperty)BlockDynamicTwilightRoots.RADIUS);
            int bound = radius / 2 * this.rootGrowChance;
            boolean grow = bound > 0 && rand.nextInt(bound) == 0;
            this.iterateRootGrow(world, this.offsetSpawn(blockPos), rand, (Integer)world.func_180495_p(this.offsetSpawn(blockPos)).func_177229_b((IProperty)BlockDynamicTwilightRoots.RADIUS) + (grow ? 1 : 0), EnumFacing.UP, blockPos, 0);
        }
        return true;
    }
}

