/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import maxhyper.dynamictreesttf.ModContent;
import maxhyper.dynamictreesttf.blocks.BlockBranchTwilight;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenLogCritter;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenUndergroundRoots;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenWeb;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import twilightforest.biomes.TFBiomes;

public class TreeCanopy
extends TreeFamily {
    public static Block leavesBlock = Block.func_149684_b((String)"twilightforest:twilight_leaves");
    public static Block logBlock = Block.func_149684_b((String)"twilightforest:twilight_log");
    public static Block saplingBlock = Block.func_149684_b((String)"twilightforest:twilight_sapling");
    public static IBlockState leavesState = leavesBlock.func_176203_a(1);
    public static int logsMeta = 1;
    public static int saplingMeta = 1;
    public static int heightLimitOverLowestBranch = 10;
    Species spookySpecies;

    public TreeCanopy() {
        super(new ResourceLocation("dynamictreesttf", "canopy"));
        this.setPrimitiveLog(logBlock.func_176223_P(), new ItemStack(logBlock, 1, logsMeta));
        ModContent.canopyLeavesProperties.setTree((TreeFamily)this);
        ModContent.spookyCanopyLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
        this.addSpeciesLocationOverride((access, trunkPos) -> {
            if (Species.isOneOfBiomes((Biome)access.func_180494_b(trunkPos), (Biome[])new Biome[]{TFBiomes.spookyForest})) {
                return this.spookySpecies;
            }
            return Species.NULLSPECIES;
        });
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, logsMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.spookySpecies = new SpeciesSpookyCanopy(this);
        this.setCommonSpecies(new SpeciesCanopy(this.getName(), this, ModContent.canopyLeavesProperties));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        speciesRegistry.register((IForgeRegistryEntry)this.spookySpecies);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public BlockBranch createBranch() {
        String branchName = "canopybranch";
        return new BlockBranchTwilight(branchName);
    }

    public class SpeciesSpookyCanopy
    extends SpeciesCanopy {
        SpeciesSpookyCanopy(TreeFamily treeFamily) {
            super(new ResourceLocation("dynamictreesttf", "canopyspooky"), treeFamily, ModContent.spookyCanopyLeavesProperties);
            this.addGenFeature((IGenFeature)new FeatureGenWeb(this, 4.0f));
        }

        public ResourceLocation getSaplingName() {
            return new ResourceLocation("dynamictreesttf", "canopy");
        }

        public boolean canGrowWithBoneMeal(World world, BlockPos pos) {
            return false;
        }

        public boolean grow(World world, BlockRooty rootyDirt, BlockPos rootPos, int soilLife, ITreePart treeBase, BlockPos treePos, Random random, boolean natural) {
            return false;
        }

        public boolean transitionToTree(World world, BlockPos pos) {
            TreeFamily tree = this.getFamily();
            if (world.func_175623_d(pos.func_177984_a()) && this.isAcceptableSoil(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()))) {
                world.func_175656_a(pos, tree.getDynamicBranch().func_176223_P());
                this.placeRootyDirtBlock(world, pos.func_177977_b(), 15);
                return true;
            }
            return false;
        }
    }

    public class SpeciesCanopy
    extends Species {
        SpeciesCanopy(ResourceLocation name, TreeFamily treeFamily, ILeavesProperties leavesProperties) {
            super(name, treeFamily, leavesProperties);
            this.setBasicGrowingParameters(0.9f, 80.0f, 10, 12, this.growthRate);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenLogCritter(this.getLowestBranchHeight() + heightLimitOverLowestBranch, ModContent.dynamicFirefly, 100, 5));
            this.addGenFeature((IGenFeature)new FeatureGenUndergroundRoots(ModContent.undergroundRoot, ModContent.undergroundRootExposed, 8, 5, 1));
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            if (pos.func_177956_o() > signal.rootPos.func_177956_o() + this.getLowestBranchHeight() + heightLimitOverLowestBranch) {
                probMap[EnumFacing.UP.ordinal()] = 0;
            }
            return probMap;
        }
    }
}

