/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import maxhyper.dynamictreesttf.ModContent;
import maxhyper.dynamictreesttf.blocks.BlockBranchTwilight;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenTrunkCore;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.enums.MagicWoodVariant;

public class TreeMagicSorting
extends TreeFamily {
    public static Block leavesBlock = Block.func_149684_b((String)"twilightforest:magic_leaves");
    public static Block logBlock = Block.func_149684_b((String)"twilightforest:magic_log");
    public static Block saplingBlock = Block.func_149684_b((String)"twilightforest:twilight_sapling");
    public static IBlockState leavesState = leavesBlock.func_176223_P().func_177226_a(BlockTFMagicLog.VARIANT, (Comparable)MagicWoodVariant.SORT);
    public static int logsMeta = 3;
    public static int saplingMeta = 8;
    public static BlockBranchTwilight branch;

    public TreeMagicSorting() {
        super(new ResourceLocation("dynamictreesttf", "sortingTree"));
        this.setPrimitiveLog(logBlock.func_176223_P(), new ItemStack(logBlock, 1, logsMeta));
        ModContent.sortingCoreBranch.setFamily((TreeFamily)this);
        ModContent.sortingCoreBranchOff.setFamily((TreeFamily)this);
        ModContent.sortingLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, logsMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesMagicSorting(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)ModContent.sortingCoreBranch);
        blockList.add((Block)ModContent.sortingCoreBranchOff);
        return super.getRegisterableBlocks(blockList);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public BlockBranch createBranch() {
        String branchName = "sortingTreebranch";
        branch = new BlockBranchTwilight(branchName){

            public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
                return false;
            }
        };
        return branch;
    }

    public class SpeciesMagicSorting
    extends Species {
        SpeciesMagicSorting(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.sortingLeavesProperties);
            this.setBasicGrowingParameters(2.0f, 5.0f, this.upProbability, 4, this.growthRate);
            this.generateSeed();
            this.addGenFeature((IGenFeature)new FeatureGenTrunkCore(ModContent.sortingCoreBranchOff, 7, 2));
        }

        public Species generateSeed() {
            Seed seed = new Seed(this.getRegistryName().func_110623_a() + "seed"){

                public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                    tooltip.set(0, TextFormatting.AQUA + tooltip.get(0));
                    super.func_77624_a(stack, worldIn, tooltip, flagIn);
                }
            };
            this.setSeedStack(new ItemStack((Item)seed));
            return this;
        }
    }
}

