/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import maxhyper.dynamictreesttf.ModContent;
import maxhyper.dynamictreesttf.blocks.BlockBranchTwilight;
import maxhyper.dynamictreesttf.blocks.BlockDynamicTwilightRoots;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenLogCritter;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenTrunkCore;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenUndergroundRoots;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;
import twilightforest.TwilightForestMod;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.client.particle.TFParticleType;
import twilightforest.enums.MagicWoodVariant;

public class TreeMagicTransformation
extends TreeFamily {
    public static Block leavesBlock = Block.func_149684_b((String)"twilightforest:magic_leaves");
    public static Block logBlock = Block.func_149684_b((String)"twilightforest:magic_log");
    public static Block saplingBlock = Block.func_149684_b((String)"twilightforest:twilight_sapling");
    public static IBlockState leavesState = leavesBlock.func_176223_P().func_177226_a(BlockTFMagicLog.VARIANT, (Comparable)MagicWoodVariant.TRANS);
    public static int logsMeta = 1;
    public static int saplingMeta = 6;
    public static BlockBranchTwilight branch;
    public static BlockDynamicLeaves transformationLeaves;

    public TreeMagicTransformation() {
        super(new ResourceLocation("dynamictreesttf", "treeOfTransformation"));
        this.setPrimitiveLog(logBlock.func_176223_P(), new ItemStack(logBlock, 1, logsMeta));
        transformationLeaves = new BlockDynamicLeaves(){

            public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
                for (int i = 0; i < 1; ++i) {
                    this.sparkleRunes(world, pos, random);
                }
            }

            private void sparkleRunes(World world, BlockPos pos, Random rand) {
                double offset = 0.0625;
                EnumFacing side = EnumFacing.func_176741_a((Random)rand);
                double rx = (float)pos.func_177958_n() + rand.nextFloat();
                double ry = (float)pos.func_177956_o() + rand.nextFloat();
                double rz = (float)pos.func_177952_p() + rand.nextFloat();
                if (side == EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
                    ry = (double)(pos.func_177956_o() + 1) + offset;
                }
                if (side == EnumFacing.UP && world.func_175623_d(pos.func_177977_b())) {
                    ry = (double)pos.func_177956_o() - offset;
                }
                if (side == EnumFacing.NORTH && world.func_175623_d(pos.func_177968_d())) {
                    rz = (double)(pos.func_177952_p() + 1) + offset;
                }
                if (side == EnumFacing.SOUTH && world.func_175623_d(pos.func_177978_c())) {
                    rz = (double)pos.func_177952_p() - offset;
                }
                if (side == EnumFacing.WEST && world.func_175623_d(pos.func_177974_f())) {
                    rx = (double)(pos.func_177958_n() + 1) + offset;
                }
                if (side == EnumFacing.EAST && world.func_175623_d(pos.func_177976_e())) {
                    rx = (double)pos.func_177958_n() - offset;
                }
                if (rx < (double)pos.func_177958_n() || rx > (double)(pos.func_177958_n() + 1) || ry < (double)pos.func_177956_o() || ry > (double)(pos.func_177956_o() + 1) || rz < (double)pos.func_177952_p() || rz > (double)(pos.func_177952_p() + 1)) {
                    TwilightForestMod.proxy.spawnParticle(TFParticleType.LEAF_RUNE, rx, ry, rz, 0.0, 0.0, 0.0);
                }
            }
        };
        transformationLeaves.setRegistryName("leaves_of_transformation");
        ModContent.transformCoreBranch.setFamily((TreeFamily)this);
        ModContent.transformCoreBranchOff.setFamily((TreeFamily)this);
        ModContent.transformationLeavesProperties.setTree((TreeFamily)this);
        ModContent.transformationLeavesProperties.setDynamicLeavesState(transformationLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
        transformationLeaves.setProperties(0, ModContent.transformationLeavesProperties);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, logsMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesMagicTransformation(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)transformationLeaves);
        blockList.add((Block)ModContent.transformCoreBranch);
        blockList.add((Block)ModContent.transformCoreBranchOff);
        return super.getRegisterableBlocks(blockList);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public BlockBranch createBranch() {
        String branchName = "treeOfTransformationbranch";
        branch = new BlockBranchTwilight(branchName){

            public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
                return false;
            }
        };
        return branch;
    }

    public class SpeciesMagicTransformation
    extends Species {
        SpeciesMagicTransformation(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.transformationLeavesProperties);
            this.setBasicGrowingParameters(0.5f, 16.0f, this.upProbability, this.lowestBranchHeight, this.growthRate);
            this.generateSeed();
            this.addGenFeature((IGenFeature)new FeatureGenLogCritter(this.getLowestBranchHeight(), ModContent.dynamicFirefly, 60, 2));
            this.addGenFeature((IGenFeature)new FeatureGenUndergroundRoots(ModContent.undergroundRoot, ModContent.undergroundRootExposed, 8, 5, 3));
            this.addGenFeature((IGenFeature)new FeatureGenTrunkCore(ModContent.transformCoreBranchOff, 7, 4));
        }

        public Species generateSeed() {
            Seed seed = new Seed(this.getRegistryName().func_110623_a() + "seed"){

                public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                    tooltip.set(0, TextFormatting.AQUA + tooltip.get(0));
                    super.func_77624_a(stack, worldIn, tooltip, flagIn);
                }
            };
            this.setSeedStack(new ItemStack((Item)seed));
            return this;
        }

        private EnumFacing getRelativeFace(BlockPos signalPos, BlockPos rootPos) {
            if (signalPos.func_177952_p() < rootPos.func_177952_p()) {
                return EnumFacing.NORTH;
            }
            if (signalPos.func_177952_p() > rootPos.func_177952_p()) {
                return EnumFacing.SOUTH;
            }
            if (signalPos.func_177958_n() > rootPos.func_177958_n()) {
                return EnumFacing.EAST;
            }
            if (signalPos.func_177958_n() < rootPos.func_177958_n()) {
                return EnumFacing.WEST;
            }
            return EnumFacing.UP;
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            if (signal.isInTrunk() && pos.func_177956_o() > signal.rootPos.func_177956_o() + this.getLowestBranchHeight() + 1) {
                probMap[EnumFacing.UP.func_176745_a()] = 0;
            }
            if (!signal.isInTrunk()) {
                EnumFacing relativePosToRoot = this.getRelativeFace(pos, signal.rootPos);
                if (signal.energy > 2.0f) {
                    probMap[EnumFacing.DOWN.func_176745_a()] = 0;
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        probMap[dir.func_176745_a()] = 0;
                    }
                }
                boolean isBranchUp = world.func_180495_p(pos.func_177972_a(relativePosToRoot)).func_177228_b().containsKey((Object)BlockDynamicTwilightRoots.RADIUS);
                boolean isBranchSide = world.func_180495_p(pos.func_177984_a()).func_177228_b().containsKey((Object)BlockDynamicTwilightRoots.RADIUS);
                probMap[EnumFacing.UP.func_176745_a()] = isBranchUp && !isBranchSide ? 0 : 3;
                probMap[relativePosToRoot.func_176745_a()] = isBranchSide && !isBranchUp ? 0 : 1;
            }
            return probMap;
        }
    }
}

