/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees.species;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenWeb;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import twilightforest.biomes.TFBiomes;

public class SpeciesOakSpooky
extends Species {
    public SpeciesOakSpooky(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesttf", treeFamily.getName().func_110623_a() + "spooky"), treeFamily);
        this.setBasicGrowingParameters(this.tapering, this.signalEnergy, this.upProbability, this.lowestBranchHeight, this.growthRate);
        this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        this.setupStandardSeedDropping();
        this.addGenFeature((IGenFeature)new FeatureGenWeb(this, 0.75f));
        this.getFamily().addSpeciesLocationOverride((access, trunkPos) -> {
            if (Species.isOneOfBiomes((Biome)access.func_180494_b(trunkPos), (Biome[])new Biome[]{TFBiomes.spookyForest})) {
                return this;
            }
            return Species.NULLSPECIES;
        });
    }

    public ResourceLocation getSaplingName() {
        return new ResourceLocation("dynamictrees", "oak");
    }

    public boolean isBiomePerfect(Biome biome) {
        return biome == TFBiomes.spookyForest;
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }
}

