/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees.species;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import twilightforest.biomes.TFBiomes;

public class SpeciesSpruceHuge
extends Species {
    public SpeciesSpruceHuge(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesttf", "hugemegaspruce"), treeFamily);
        this.setBasicGrowingParameters(0.4f, 30.0f, 6, 9, 2.0f);
        this.setGrowthLogicKit((IGrowthLogicKit)new ConiferLogic(7.0f));
        this.setSoilLongevity(32);
        this.addGenFeature((IGenFeature)new FeatureGenClearVolume(25));
        this.addGenFeature((IGenFeature)new FeatureGenMound(999));
        Species megaspruce = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "megaspruce"));
        megaspruce.setMegaSpecies((Species)this);
        this.getFamily().addSpeciesLocationOverride((access, trunkPos) -> {
            if (this.isTwilightHugeMegaBiome(access, trunkPos)) {
                return this;
            }
            if (Species.isOneOfBiomes((Biome)access.func_180494_b(trunkPos), (Biome[])new Biome[]{TFBiomes.highlands, TFBiomes.highlandsCenter})) {
                return TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "megaspruce"));
            }
            return Species.NULLSPECIES;
        });
        this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(this.getLeavesProperties()));
    }

    private boolean isTwilightHugeMegaBiome(World access, BlockPos trunkPos) {
        return Species.isOneOfBiomes((Biome)access.func_180494_b(trunkPos), (Biome[])new Biome[]{TFBiomes.snowy_forest});
    }

    public boolean getRequiresTileEntity(World world, BlockPos pos) {
        return !this.isTwilightHugeMegaBiome(world, pos);
    }

    public boolean isMega() {
        return true;
    }

    public ResourceLocation getSaplingName() {
        return new ResourceLocation("dynamictrees", "spruce");
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }

    public int maxBranchRadius() {
        return 24;
    }

    public boolean isThick() {
        return true;
    }
}

