/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.block.BlockBOPMushroom;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import dynamictreesbop.ModConfigs;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorFruit;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeWillow
extends TreeFamily {
    public TreeWillow() {
        super(new ResourceLocation("dynamictreesbop", "willow"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.WILLOW);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.WILLOW));
        ModContent.leaves.get("willow").setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.WILLOW);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesWillow(this));
    }

    public class SpeciesWillow
    extends Species {
        SpeciesWillow(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("willow"));
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.generateSeed();
            if (!ModConfigs.enablePearTrees) {
                this.addDropCreator((IDropCreator)new DropCreatorFruit(BOPItems.pear));
            }
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenVine().setQuantity(32).setMaxLength(8).setRayDistance(7.0f).setVineBlock(BOPBlocks.willow_vine));
        }

        protected void setStandardSoils() {
            this.addAcceptableSoils(new String[]{"dirtlike", "mudlike"});
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP);
        }

        private boolean isGeneratingInWater(World world, BlockPos pos, IBlockState soilBlockState) {
            Biome biome;
            if (soilBlockState.func_177230_c() == Blocks.field_150355_j && BiomeDictionary.hasType((Biome)(biome = world.func_180494_b(pos)), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                BlockPos down = pos.func_177977_b();
                return this.isAcceptableSoil(world, down, world.func_180495_p(down));
            }
            return false;
        }

        public boolean isAcceptableSoilForWorldgen(World world, BlockPos pos, IBlockState soilBlockState) {
            if (this.isGeneratingInWater(world, pos, soilBlockState)) {
                return true;
            }
            return super.isAcceptableSoilForWorldgen(world, pos, soilBlockState);
        }

        public boolean generate(World world, BlockPos rootPos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
            if (this.isGeneratingInWater(world, rootPos, world.func_180495_p(rootPos))) {
                if (radius >= 5) {
                    return super.generate(world, rootPos.func_177977_b(), biome, random, radius, safeBounds);
                }
                return false;
            }
            return super.generate(world, rootPos, biome, random, radius, safeBounds);
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                    world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)BlockBOPMushroom.MushroomType.BLUE_MILK_CAP));
                }
                return true;
            }
            return false;
        }
    }
}

