/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorFruit;
import dynamictreesbop.trees.species.SpeciesFloweringOak;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesFloweringApple
extends SpeciesFloweringOak {
    public static final int PEACH_FLOWER_COLOR = 16759020;
    public static float fruitingOffset = 0.0f;

    public SpeciesFloweringApple(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "floweringapple"), treeFamily, ModContent.floweringOakLeavesProperties[0]);
        this.addValidLeavesBlocks(ModContent.floweringOakLeavesProperties);
        this.setFlowerSeasonHold(fruitingOffset - 0.5f, fruitingOffset + 0.5f);
        this.addDropCreator((IDropCreator)new DropCreatorFruit(Items.field_151034_e));
        this.addGenFeature((IGenFeature)new FeatureGenFruit(ModBlocks.blockApple).setRayDistance(4.0f));
    }

    @Override
    protected void setDefaultGrowingParameters() {
        this.setBasicGrowingParameters(0.4f, 10.0f, 1, 4, 0.7f);
        this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
    }

    public float seasonalFruitProductionFactor(World world, BlockPos pos) {
        float offset = fruitingOffset;
        return SeasonHelper.globalSeasonalFruitProductionFactor((World)world, (BlockPos)pos, (float)offset);
    }

    public boolean testFlowerSeasonHold(World world, BlockPos pos, float seasonValue) {
        return SeasonHelper.isSeasonBetween((float)seasonValue, (float)this.flowerSeasonHoldMin, (float)this.flowerSeasonHoldMax);
    }

    private static Species getApple() {
        return TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "apple"));
    }

    public Seed getSeed() {
        return SpeciesFloweringApple.getApple().getSeed();
    }

    public ItemStack getSeedStack(int qty) {
        return SpeciesFloweringApple.getApple().getSeedStack(qty);
    }
}

