/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.common.block.BlockBOPLeaves;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenBush;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import dynamictreesbop.ModConfigs;
import dynamictreesbop.ModContent;
import dynamictreesbop.cells.DTBOPLeafClusters;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesPoplar
extends Species {
    public SpeciesPoplar(TreeFamily treeFamily, String name) {
        super(new ResourceLocation("dynamictreesbop", name), treeFamily, ModContent.leaves.get(name));
        this.setBasicGrowingParameters(0.25f, 11.0f, 5, 4, 0.85f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.75f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        this.setupStandardSeedDropping();
        this.setRequiresTileEntity(true);
        this.generateSeed();
        this.addGenFeature((IGenFeature)new FeatureGenBush().setBiomePredicate(b -> b == BOPBiomes.grove.orNull()).setSecondaryLeavesState(BlockBOPLeaves.paging.getVariantState((Enum)BOPTrees.FLOWERING)), 4);
        this.leavesProperties.setTree(treeFamily);
    }

    protected void setStandardSoils() {
        this.addAcceptableSoils(new String[]{"dirtlike", "mudlike"});
    }

    public boolean isBiomePerfect(Biome biome) {
        return biome == BOPBiomes.grove.orNull() || biome == BOPBiomes.bog.orNull();
    }

    protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
        EnumFacing originDir = signal.dir.func_176734_d();
        probMap[0] = signal.isInTrunk() ? 0 : 1;
        probMap[1] = signal.isInTrunk() ? 4 : 1;
        probMap[5] = (signal.isInTrunk() && signal.numSteps % 2 == 0 || !signal.isInTrunk()) && signal.energy < 8.0f ? 2 : 0;
        probMap[4] = probMap[5];
        probMap[3] = probMap[5];
        probMap[2] = probMap[5];
        probMap[originDir.ordinal()] = 0;
        int n = signal.dir.ordinal();
        probMap[n] = probMap[n] + (signal.isInTrunk() ? 0 : (signal.numTurns == 1 ? 2 : 1));
        return probMap;
    }

    public INodeInspector getNodeInflator(SimpleVoxmap leafMap) {
        return new NodeInflatorPoplar(this, leafMap);
    }

    protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
        if (signal.isInTrunk() && newDir != EnumFacing.UP) {
            signal.energy = signal.energy >= 4.0f ? 1.8f : (signal.energy < 5.0f ? 0.8f : 0.0f);
        }
        return newDir;
    }

    public float getEnergy(World world, BlockPos pos) {
        return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(this.coordHashCode(pos) % 3);
    }

    public int getLowestBranchHeight(World world, BlockPos pos) {
        return this.getLowestBranchHeight() + this.coordHashCode(pos) % 3;
    }

    public int coordHashCode(BlockPos pos) {
        int hash = (pos.func_177958_n() * 9973 ^ pos.func_177956_o() * 8287 ^ pos.func_177952_p() * 9721) >> 1;
        return hash & 0xFFFF;
    }

    public ItemStack getSeedStack(int qty) {
        if (ModConfigs.enablePoplarSeeds) {
            return super.getSeedStack(qty);
        }
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public int maxBranchRadius() {
        return 8;
    }

    public class NodeInflatorPoplar
    implements INodeInspector {
        private float radius;
        private BlockPos last;
        Species species;
        SimpleVoxmap leafMap;

        public NodeInflatorPoplar(Species species, SimpleVoxmap leafMap) {
            this.species = species;
            this.leafMap = leafMap;
            this.last = BlockPos.field_177992_a;
        }

        public boolean run(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
            BlockBranch branch = TreeHelper.getBranch((IBlockState)blockState);
            if (branch != null) {
                this.radius = this.species.getFamily().getPrimaryThickness();
            }
            return false;
        }

        public boolean returnRun(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
            BlockBranch branch = TreeHelper.getBranch((IBlockState)blockState);
            if (branch != null) {
                SimpleVoxmap leafCluster;
                float areaAccum = this.radius * this.radius;
                boolean isTwig = true;
                boolean isTop = world.func_180495_p(pos.func_177977_b()).func_177230_c() == branch;
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    if (dir.equals((Object)fromDir)) continue;
                    BlockPos dPos = pos.func_177972_a(dir);
                    if (dPos.equals((Object)this.last)) {
                        isTwig = false;
                        isTop = false;
                        continue;
                    }
                    IBlockState deltaBlockState = world.func_180495_p(dPos);
                    ITreePart treepart = TreeHelper.getTreePart((IBlockState)deltaBlockState);
                    if (!branch.isSameTree(treepart)) continue;
                    int branchRadius = treepart.getRadius(deltaBlockState);
                    areaAccum += (float)(branchRadius * branchRadius);
                }
                if (isTop) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    leafCluster = DTBOPLeafClusters.poplarTop;
                    this.leafMap.blitMax(pos, leafCluster);
                } else if (isTwig) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    leafCluster = this.species.getLeavesProperties().getCellKit().getLeafCluster();
                    this.leafMap.blitMax(pos, leafCluster);
                } else {
                    float secondaryThickness;
                    this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                    int maxRadius = this.species.maxBranchRadius();
                    if (this.radius > (float)maxRadius) {
                        this.radius = maxRadius;
                    }
                    if (this.radius < (secondaryThickness = this.species.getFamily().getSecondaryThickness())) {
                        this.radius = secondaryThickness;
                    }
                    branch.setRadius(world, pos, (int)Math.floor(this.radius), null);
                    this.leafMap.setVoxel(pos, (byte)32);
                    if (Math.floor(this.radius) < 3.0) {
                        SimpleVoxmap leafCluster2 = this.species.getLeavesProperties().getCellKit().getLeafCluster();
                        this.leafMap.blitMax(pos, leafCluster2);
                    }
                }
                this.last = pos;
            }
            return false;
        }
    }
}

