/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sereneseasons.api.ISSBlock;
import sereneseasons.api.SSBlocks;
import sereneseasons.block.BlockGreenhouseGlass;
import sereneseasons.block.BlockSeasonSensor;
import sereneseasons.core.SereneSeasons;
import sereneseasons.tileentity.TileEntitySeasonSensor;
import sereneseasons.util.BlockStateUtils;
import sereneseasons.util.inventory.CreativeTabSS;

public class ModBlocks {
    public static void init() {
        SSBlocks.greenhouse_glass = ModBlocks.registerBlock((Block)new BlockGreenhouseGlass(), "greenhouse_glass");
        SSBlocks.season_sensors[0] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.SPRING), "season_sensor_spring");
        SSBlocks.season_sensors[1] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.SUMMER), "season_sensor_summer").func_149647_a(null);
        SSBlocks.season_sensors[2] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.AUTUMN), "season_sensor_autumn").func_149647_a(null);
        SSBlocks.season_sensors[3] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.WINTER), "season_sensor_winter").func_149647_a(null);
        GameRegistry.registerTileEntity(TileEntitySeasonSensor.class, (String)"season_sensor");
    }

    public static void registerBlockItemModel(Block block, String stateName, int stateMeta) {
        Item item = Item.func_150898_a((Block)block);
        SereneSeasons.proxy.registerItemVariantModel(item, stateName, stateMeta);
    }

    public static Block registerBlock(Block block, String blockName) {
        return ModBlocks.registerBlock(block, blockName, CreativeTabSS.instance);
    }

    public static Block registerBlock(Block block, String blockName, CreativeTabs tab) {
        return ModBlocks.registerBlock(block, blockName, tab, true);
    }

    public static Block registerBlock(Block block, String blockName, CreativeTabs tab, boolean registerItemModels) {
        Preconditions.checkNotNull((Object)block, (Object)"Cannot register a null block");
        block.func_149663_c(blockName);
        block.func_149647_a(tab);
        if (block instanceof ISSBlock) {
            ISSBlock bopBlock = (ISSBlock)block;
            ModBlocks.registerBlockWithItem(block, blockName, bopBlock.getItemClass());
            SereneSeasons.proxy.registerBlockSided(block);
            IBlockState defaultState = block.func_176223_P();
            if (defaultState == null) {
                defaultState = block.func_176194_O().func_177621_b();
                SereneSeasons.logger.error("Missing default state for " + block.func_149739_a());
            }
            if (registerItemModels) {
                ImmutableSet<IBlockState> presets = BlockStateUtils.getBlockPresets(block);
                if (presets.isEmpty()) {
                    ModBlocks.registerBlockItemModel(block, blockName, 0);
                } else {
                    for (IBlockState state : presets) {
                        String stateName = bopBlock.getStateName(state);
                        int stateMeta = block.func_176201_c(state);
                        ModBlocks.registerBlockItemModel(block, stateName, stateMeta);
                    }
                }
            }
        } else {
            ModBlocks.registerBlockWithItem(block, blockName, ItemBlock.class);
            ModBlocks.registerBlockItemModel(block, blockName, 0);
        }
        return block;
    }

    private static void registerBlockWithItem(Block block, String blockName, Class<? extends ItemBlock> clazz) {
        try {
            Item itemBlock = clazz != null ? (Item)clazz.getConstructor(Block.class).newInstance(block) : null;
            ResourceLocation location = new ResourceLocation("sereneseasons", blockName);
            block.setRegistryName(new ResourceLocation("sereneseasons", blockName));
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
            if (itemBlock != null) {
                itemBlock.setRegistryName(new ResourceLocation("sereneseasons", blockName));
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred associating an item block during registration of " + blockName, e);
        }
    }
}

