/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render;

import cofh.core.proxy.ProxyClient;
import cofh.core.render.font.ICustomCharRenderer;
import cofh.core.render.font.RenderPlayerFace;
import cofh.core.render.font.RenderSprite;
import cofh.core.util.helpers.SecurityHelper;
import gnu.trove.map.hash.TCharObjectHashMap;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FontRendererCore
extends FontRenderer {
    private float r;
    private float g;
    private float b;
    private float a;
    public final TCharObjectHashMap<ICustomCharRenderer> renderOverrides = new TCharObjectHashMap();
    private char n = (char)888;

    public FontRendererCore(GameSettings gameSettings, ResourceLocation location, TextureManager textureManager, boolean unicode) {
        super(gameSettings, location, textureManager, unicode);
    }

    public int func_78256_a(String text) {
        if (text == null) {
            return 0;
        }
        int i = 0;
        boolean flag = false;
        for (int j = 0; j < text.length(); ++j) {
            char c0 = text.charAt(j);
            int k = this.func_78263_a(c0);
            if (k < 0 && j < text.length() - 1) {
                if ((c0 = text.charAt(++j)) != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                k = 0;
            }
            i += k;
            if (!flag) continue;
            ++i;
        }
        return i;
    }

    public String func_78269_a(String text, int width) {
        return this.func_78262_a(text, width, false);
    }

    public List<String> func_78271_c(String str, int wrapWidth) {
        return Arrays.asList(this.func_78280_d(str, wrapWidth).split("\n"));
    }

    public String func_78280_d(String str, int wrapWidth) {
        int j = this.func_78259_e(str, wrapWidth);
        if (str.length() <= j) {
            return str;
        }
        String s1 = str.substring(0, j);
        char c0 = str.charAt(j);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s2 = FontRendererCore.getFormatFromString(s1) + str.substring(j + (flag ? 1 : 0));
        return s1 + "\n" + this.func_78280_d(s2, wrapWidth);
    }

    public int func_78259_e(String str, int width) {
        int l;
        int j = str.length();
        int k = 0;
        int i1 = -1;
        boolean flag = false;
        for (l = 0; l < j; ++l) {
            char c0 = str.charAt(l);
            switch (c0) {
                case '\n': {
                    --l;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (l >= j - 1) break;
                    if ((c1 = str.charAt(++l)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !FontRendererCore.isFormatColor(c1)) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                    break;
                }
                case ' ': {
                    i1 = l;
                }
                default: {
                    k += this.func_78263_a(c0);
                    if (!flag) break;
                    ++k;
                }
            }
            if (c0 == '\n') {
                i1 = ++l;
                break;
            }
            if (k > width) break;
        }
        return l != j && i1 != -1 && i1 < l ? i1 : l;
    }

    public static String getFormatFromString(String str) {
        String s1 = "";
        int i = -1;
        int j = str.length();
        while ((i = str.indexOf(167, i + 1)) != -1) {
            if (i >= j - 1) continue;
            char c0 = str.charAt(i + 1);
            if (FontRendererCore.isFormatColor(c0)) {
                s1 = "\u00a7" + c0;
                continue;
            }
            if (!FontRendererCore.isFormatSpecial(c0)) continue;
            s1 = s1 + "\u00a7" + c0;
        }
        return s1;
    }

    public static boolean isFormatColor(char par0) {
        return par0 >= '0' && par0 <= '9' || par0 >= 'a' && par0 <= 'f' || par0 >= 'A' && par0 <= 'F';
    }

    public static boolean isFormatSpecial(char par0) {
        return par0 >= 'k' && par0 <= 'o' || par0 >= 'K' && par0 <= 'O' || par0 == 'r' || par0 == 'R';
    }

    public void resetColor() {
        super.setColor(this.r, this.g, this.b, this.a);
    }

    public void setColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        super.setColor(r, g, b, a);
    }

    public float func_78277_a(char ch, boolean italic) {
        float v;
        ICustomCharRenderer iCustomCharRenderer = (ICustomCharRenderer)this.renderOverrides.get(ch);
        if (iCustomCharRenderer != null && (v = iCustomCharRenderer.renderChar(ch, italic, this.field_78295_j, this.field_78296_k, this)) != -2.0f) {
            return v;
        }
        return super.func_78277_a(ch, italic);
    }

    public int func_78263_a(char c) {
        int width;
        ICustomCharRenderer iCustomCharRenderer = (ICustomCharRenderer)this.renderOverrides.get(c);
        if (iCustomCharRenderer != null && (width = iCustomCharRenderer.getCharWidth(c, this)) != -2) {
            return width;
        }
        return super.func_78263_a(c);
    }

    public void initSpecialCharacters() {
        RenderSprite.addRenderer('\u2661', Gui.field_110324_m, 52, 0, 9, 9, this);
        RenderSprite.addRenderer('\u2665', Gui.field_110324_m, 124, 0, 9, 9, this);
        RenderSprite.addRenderer('\u2314', Gui.field_110324_m, 34, 9, 9, 9, this);
        RenderSprite.addRenderer('\u25cb', Gui.field_110324_m, 16, 18, 9, 9, this);
        RenderSprite.addRenderer('\u25cc', Gui.field_110324_m, 25, 18, 9, 9, this);
        RenderSprite.addRenderer('\u29f0', Gui.field_110324_m, 52, 27, 9, 9, this);
        RenderSprite.addRenderer('\u2763', Gui.field_110324_m, 52, 45, 9, 9, this);
        ResourceLocation beacon = new ResourceLocation("textures/gui/container/beacon.png");
        RenderSprite.addRenderer('\u2715', beacon, 113, 222, 15, 15, this);
        RenderSprite.addRenderer('\u2714', beacon, 90, 223, 16, 14, this);
        RenderPlayerFace.init(this);
    }

    public void bindTexture(ResourceLocation location) {
        super.bindTexture(location);
    }

    public static FontRenderer loadFontRendererStack(ItemStack stack) {
        if (SecurityHelper.isSecure(stack)) {
            return RenderPlayerFace.loadProfile(stack);
        }
        return ProxyClient.fontRenderer;
    }

    public char getNextBlankChar() {
        this.n = (char)(this.n + '\u0001');
        while (this.field_78287_e[this.n] != 0 && this.renderOverrides.containsKey(this.n)) {
            this.n = (char)(this.n + '\u0001');
        }
        return this.n;
    }
}

