/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesic2;

import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import maxhyper.dynamictreesic2.DynamicTreesIC2;
import maxhyper.dynamictreesic2.ModConfigs;
import maxhyper.dynamictreesic2.blocks.BlockDynamicBranchRubber;
import maxhyper.dynamictreesic2.compat.IC2Proxy;
import maxhyper.dynamictreesic2.trees.TreeRubber;
import maxhyper.dynamictreesic2.worldgen.BiomeDataBasePopulator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dynamictreesic2")
@GameRegistry.ObjectHolder(value="dynamictreesic2")
public class ModContent {
    public static BlockBranch rubberBranch;
    public static BlockBranch rubberBranchEmpty;
    public static BlockBranch rubberBranchFilled;
    public static ILeavesProperties rubberLeavesProperties;
    public static ArrayList<TreeFamily> trees;

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        rubberBranch = new BlockDynamicBranchRubber(true, "branch");
        rubberBranchEmpty = new BlockDynamicBranchRubber(true, "branchempty");
        rubberBranchFilled = new BlockDynamicBranchRubber(false, "branchfilled");
        registry.register((IForgeRegistryEntry)rubberBranchEmpty);
        registry.register((IForgeRegistryEntry)rubberBranchFilled);
        rubberLeavesProperties = ModConfigs.classicLookingRubberTree ? ModContent.setUpLeaves(DynamicTreesIC2.proxyIC2.IC2GetTreeBlocks(IC2Proxy.TreeBlock.LEAVES), "conifer", 6, 13) : ModContent.setUpLeaves(DynamicTreesIC2.proxyIC2.IC2GetTreeBlocks(IC2Proxy.TreeBlock.LEAVES), "deciduous", 3, 13);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesic2", (int)0, (ILeavesProperties)rubberLeavesProperties);
        TreeRubber rubberTree = new TreeRubber();
        Collections.addAll(trees, new TreeFamily[]{rubberTree});
        trees.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        ArrayList treeBlocks = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableBlocks((List)treeBlocks));
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"dynamictreesic2").values());
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[treeBlocks.size()]));
    }

    public static ILeavesProperties setUpLeaves(final Block leavesBlock, String cellKit, final int smother, final int light) {
        return new LeavesProperties(leavesBlock.func_176223_P(), TreeRegistry.findCellKit((String)cellKit)){

            public int getSmotherLeavesMax() {
                return smother;
            }

            public int getLightRequirement() {
                return light;
            }

            public ItemStack getPrimitiveLeavesItemStack() {
                return new ItemStack(leavesBlock);
            }
        };
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(new ItemBlock((Block)rubberBranchEmpty).setRegistryName(Objects.requireNonNull(rubberBranchEmpty.getRegistryName())));
        registry.register(new ItemBlock((Block)rubberBranchFilled).setRegistryName(Objects.requireNonNull(rubberBranchFilled.getRegistryName())));
        ArrayList treeItems = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableItems((List)treeItems));
        registry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[treeItems.size()]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModContent.setUpSeedRecipes("rubber", new ItemStack(DynamicTreesIC2.proxyIC2.IC2GetTreeBlocks(IC2Proxy.TreeBlock.SAPLING)));
    }

    public static void setUpSeedRecipes(String name, ItemStack treeSapling) {
        Species treeSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesic2", name));
        ItemStack treeSeed = treeSpecies.getSeedStack(1);
        ItemStack treeTransformationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), treeSpecies.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)treeSeed, (ItemStack)treeTransformationPotion);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)treeSapling, (ItemStack)treeSeed, (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (TreeFamily tree : trees) {
            ModelHelper.regModel((Block)tree.getDynamicBranch());
            ModelHelper.regModel((Item)tree.getCommonSpecies().getSeed());
            ModelHelper.regModel((TreeFamily)tree);
        }
        ModelHelper.regModel((Block)rubberBranchEmpty);
        ModelHelper.regModel((Block)rubberBranchFilled);
        LeavesPaging.getLeavesMapForModId((String)"dynamictreesic2").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
    }

    static {
        trees = new ArrayList();
    }
}

