/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesic2.blocks;

import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import maxhyper.dynamictreesic2.DynamicTreesIC2;
import maxhyper.dynamictreesic2.ModContent;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockDynamicBranchRubber
extends BlockBranchBasic {
    public BlockDynamicBranchRubber(boolean tick, String name) {
        super(new ResourceLocation("dynamictreesic2", DynamicTreesIC2.proxyIC2.IC2GetTreeID() + name).toString());
        this.func_149675_a(tick);
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        int radius = this.getRadius(blockState);
        return 2.0f * (float)(radius * radius) / 64.0f * 8.0f;
    }

    public int getMaxRadius() {
        return 7;
    }

    private static IBlockState stateFromAge(int age) {
        switch (age) {
            case 0: {
                return ModContent.rubberBranch.func_176223_P();
            }
            case 1: {
                return ModContent.rubberBranchEmpty.func_176223_P();
            }
            case 2: {
                return ModContent.rubberBranchFilled.func_176223_P();
            }
        }
        throw new IllegalArgumentException();
    }

    private static int ageFromState(IBlockState state) {
        if (state.func_177230_c() == ModContent.rubberBranchFilled) {
            return 2;
        }
        if (state.func_177230_c() == ModContent.rubberBranchEmpty) {
            return 1;
        }
        if (state.func_177230_c() == ModContent.rubberBranch) {
            return 0;
        }
        return -1;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack handStack = playerIn.func_184614_ca();
        ItemStack resin = DynamicTreesIC2.proxyIC2.getIC2ResinStack();
        int operationEnergyCost = 50;
        int age = BlockDynamicBranchRubber.ageFromState(state);
        if (age > 0) {
            boolean doTap = false;
            if (handStack.func_77973_b() == DynamicTreesIC2.proxyIC2.getIC2TreeTap(true) && DynamicTreesIC2.proxyIC2.IC2CanUseElectricItem(handStack, operationEnergyCost)) {
                DynamicTreesIC2.proxyIC2.IC2UseElectricItem(handStack, operationEnergyCost, (EntityLivingBase)playerIn);
                doTap = true;
            } else if (handStack.func_77973_b() == DynamicTreesIC2.proxyIC2.getIC2TreeTap(false)) {
                handStack.func_77972_a(1, (EntityLivingBase)playerIn);
                doTap = true;
            }
            if (doTap) {
                DynamicTreesIC2.proxyIC2.IC2TapPlaySound(playerIn);
                if (!worldIn.field_72995_K && (age == 2 || age == 1 && worldIn.field_73012_v.nextInt(5) == 0)) {
                    worldIn.func_180501_a(pos, BlockDynamicBranchRubber.stateFromAge(age - 1).func_177226_a((IProperty)RADIUS, worldIn.func_180495_p(pos).func_177229_b((IProperty)RADIUS)), 3);
                    resin.func_190920_e(age == 2 ? 1 + RANDOM.nextInt(3) : RANDOM.nextInt(2));
                    worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ), resin));
                }
            }
            if (doTap) {
                return true;
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }
}

