/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesic2.genfeatures;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGrowFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenSapLog
implements IPostGenFeature,
IPostGrowFeature {
    private int height;
    private BlockBranch branchEmpty;
    private BlockBranch branchHole;
    private BlockBranch branchFull;
    private float holeToFilledChance = 0.02f;
    private float emptyToHoleChance = 0.02f;
    protected int fruitingRadius = 8;
    private int worldgenAttempts = 5;

    public FeatureGenSapLog(int height, BlockBranch branch1, BlockBranch branch2, BlockBranch branch3) {
        this.height = height;
        this.branchEmpty = branch1;
        this.branchHole = branch2;
        this.branchFull = branch3;
    }

    public FeatureGenSapLog setFruitingRadius(int fruitingRadius) {
        this.fruitingRadius = fruitingRadius;
        return this;
    }

    public FeatureGenSapLog setEmptyToHoleChance(float emptyToHoleChance) {
        this.emptyToHoleChance = emptyToHoleChance;
        return this;
    }

    public FeatureGenSapLog setHoleToFilledChance(float holeToFilledChance) {
        this.holeToFilledChance = holeToFilledChance;
        return this;
    }

    public FeatureGenSapLog setWorldgenAttempts(int worldgenAttempts) {
        this.worldgenAttempts = worldgenAttempts;
        return this;
    }

    public boolean postGeneration(World world, BlockPos blockPos, Species species, Biome biome, int i, List<BlockPos> list, SafeChunkBounds safeChunkBounds, IBlockState iBlockState) {
        return this.attemptSapGeneration(world, blockPos, true);
    }

    public boolean postGrow(World world, BlockPos blockPos, BlockPos blockPos1, Species species, int i, boolean natural) {
        if (natural) {
            return this.attemptSapGeneration(world, blockPos, false);
        }
        return false;
    }

    private int getTreeHeight(World world, BlockPos rootPos) {
        for (int y = 1; y <= this.height; ++y) {
            if (TreeHelper.isBranch((IBlockState)world.func_180495_p(rootPos.func_177981_b(y)))) continue;
            return y - 1;
        }
        return this.height;
    }

    private List<BlockPos> getHolePositions(World world, BlockPos rootPos, int treeHeight) {
        LinkedList<BlockPos> list = new LinkedList<BlockPos>();
        for (int y = 1; y <= treeHeight; ++y) {
            BlockPos testPos = rootPos.func_177981_b(y);
            if (world.func_180495_p(testPos).func_177230_c() != this.branchHole) continue;
            list.add(testPos);
        }
        return list;
    }

    private boolean attemptSapGeneration(World world, BlockPos rootPos, boolean worldgen) {
        int treeHeight = this.getTreeHeight(world, rootPos);
        if (worldgen) {
            boolean generated = false;
            for (int i = 0; i < this.worldgenAttempts; ++i) {
                if (!this.generateSap(world, rootPos, true, treeHeight)) continue;
                generated = true;
            }
            return generated;
        }
        if (world.field_73012_v.nextFloat() < this.holeToFilledChance) {
            this.fillSapHole(world, this.getHolePositions(world, rootPos, treeHeight));
        }
        if (world.field_73012_v.nextFloat() < this.emptyToHoleChance) {
            return this.generateSap(world, rootPos, false, treeHeight);
        }
        return false;
    }

    private boolean generateSap(World world, BlockPos rootPos, boolean filled, int treeHeight) {
        BlockPos sapPos = rootPos.func_177981_b(1 + world.field_73012_v.nextInt(treeHeight));
        IBlockState downState = world.func_180495_p(sapPos.func_177977_b());
        boolean downIsSap = downState.func_177230_c() == this.branchHole || downState.func_177230_c() == this.branchFull;
        int radius = TreeHelper.getRadius((IBlockAccess)world, (BlockPos)sapPos);
        if (!downIsSap && world.func_180495_p(sapPos).func_177230_c() == this.branchEmpty && radius >= this.fruitingRadius) {
            world.func_175656_a(sapPos, filled ? this.branchFull.getStateForRadius(radius) : this.branchHole.getStateForRadius(radius));
            return true;
        }
        return false;
    }

    private void fillSapHole(World world, List<BlockPos> holePositions) {
        if (holePositions.size() <= 0) {
            return;
        }
        BlockPos chosenPos = holePositions.get(world.field_73012_v.nextInt(holePositions.size()));
        if (world.func_180495_p(chosenPos).func_177230_c() == this.branchHole) {
            int radius = TreeHelper.getRadius((IBlockAccess)world, (BlockPos)chosenPos);
            world.func_175656_a(chosenPos, this.branchFull.getStateForRadius(radius));
        }
    }
}

