/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesic2.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.Objects;
import maxhyper.dynamictreesic2.DynamicTreesIC2;
import maxhyper.dynamictreesic2.ModConfigs;
import maxhyper.dynamictreesic2.ModContent;
import maxhyper.dynamictreesic2.compat.IC2Proxy;
import maxhyper.dynamictreesic2.genfeatures.FeatureGenSapLog;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.BiomeDictionary;

public class TreeRubber
extends TreeFamily {
    public TreeRubber() {
        super(new ResourceLocation("dynamictreesic2", DynamicTreesIC2.proxyIC2.IC2GetTreeID()));
        this.hasConiferVariants = true;
        this.addValidBranches(new BlockBranch[]{ModContent.rubberBranchEmpty, ModContent.rubberBranchFilled});
        this.setDynamicBranch(ModContent.rubberBranch);
        ModContent.rubberBranchEmpty.setFamily((TreeFamily)this);
        ModContent.rubberBranchFilled.setFamily((TreeFamily)this);
        ModContent.rubberLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == DynamicTreesIC2.proxyIC2.IC2GetTreeBlocks(IC2Proxy.TreeBlock.LEAVES));
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(DynamicTreesIC2.proxyIC2.IC2GetTreeBlocks(IC2Proxy.TreeBlock.LOG)), 1, 0);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesRubberIC(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        return super.getRegisterableBlocks(blockList);
    }

    public int getRootColor(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return 9662507;
    }

    public BlockBranch createBranch() {
        return ModContent.rubberBranch;
    }

    public static class SpeciesRubberIC
    extends Species {
        SpeciesRubberIC(TreeFamily treeFamily) {
            super(new ResourceLocation("dynamictreesic2", "rubber"), treeFamily, ModContent.rubberLeavesProperties);
            this.setSoilLongevity(2);
            if (ModConfigs.classicLookingRubberTree) {
                this.setBasicGrowingParameters(0.9f, 10.0f, 6, 4, 0.8f);
                this.setGrowthLogicKit((IGrowthLogicKit)new ConiferLogic(4.0f).setHeightVariation(2));
                this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(ModContent.rubberLeavesProperties));
            } else {
                this.setBasicGrowingParameters(0.2f, 14.0f, 10, 8, 1.25f);
                this.addGenFeature((IGenFeature)new FeatureGenClearVolume(12));
            }
            this.addGenFeature((IGenFeature)new FeatureGenSapLog(10, ModContent.rubberBranch, ModContent.rubberBranchEmpty, ModContent.rubberBranchFilled).setFruitingRadius(5).setEmptyToHoleChance(ModConfigs.holeChance).setHoleToFilledChance(ModConfigs.sapChance));
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.WET, 1.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.1f);
            this.generateSeed();
            this.setupStandardSeedDropping();
        }

        public boolean useDefaultWailaBody() {
            return false;
        }

        public Species generateSeed() {
            Seed seed = new Seed(DynamicTreesIC2.proxyIC2.IC2GetTreeID() + "seed");
            this.setSeedStack(new ItemStack((Item)seed));
            return this;
        }

        public ResourceLocation getSaplingName() {
            return new ResourceLocation("dynamictreesic2", DynamicTreesIC2.proxyIC2.IC2GetTreeID());
        }

        public void addJoCodes() {
            if (ModConfigs.classicLookingRubberTree) {
                this.joCodeStore.addCodesFromFile((Species)this, "assets/dynamictreesic2/trees/rubber_classic.txt");
            } else {
                this.joCodeStore.addCodesFromFile((Species)this, "assets/dynamictreesic2/trees/rubber.txt");
            }
        }
    }
}

