/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.api;

import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.interfaces.Loadable;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.interfaces.TweakContainer;
import java.io.File;
import java.util.Collection;

public interface ContainerRegistry {
    public void registerEnabledContainer(LoadableMod<?> var1);

    public Collection<? extends LoadableMod<?>> getEnabledContainers();

    public LoadableMod<?> getEnabledContainer(String var1);

    public void registerDisabledContainer(LoadableMod<?> var1, DisabledReason var2);

    public Collection<? extends ModInfo<Loadable<?>>> getDisabledContainers();

    public boolean isDisabledContainer(LoadableMod<?> var1);

    public void registerBadContainer(Loadable<?> var1, String var2);

    public Collection<? extends ModInfo<Loadable<?>>> getBadContainers();

    public void registerTweakContainer(TweakContainer<File> var1);

    public Collection<TweakContainer<File>> getTweakContainers();

    public void registerInjectedTweak(TweakContainer<File> var1);

    public Collection<? extends ModInfo<Loadable<?>>> getInjectedTweaks();

    public static enum DisabledReason {
        UNKNOWN("Container %s is could not be loaded for UNKNOWN reason"),
        USER_DISABLED("Container %s is disabled"),
        MISSING_DEPENDENCY("Container %s is missing one or more dependencies"),
        MISSING_API("Container %s is missing one or more required APIs");

        private final String message;

        private DisabledReason(String message) {
            this.message = message;
        }

        public String getMessage(LoadableMod<?> container) {
            return String.format(this.message, container);
        }
    }
}

