/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mojang.authlib.GameProfile;
import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.PlayerInteractionListener;
import com.mumfrey.liteloader.PlayerMoveListener;
import com.mumfrey.liteloader.PluginChannelListener;
import com.mumfrey.liteloader.ServerCommandProvider;
import com.mumfrey.liteloader.ServerPlayerListener;
import com.mumfrey.liteloader.ServerPluginChannelListener;
import com.mumfrey.liteloader.ServerTickable;
import com.mumfrey.liteloader.ShutdownListener;
import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.api.ShutdownObserver;
import com.mumfrey.liteloader.common.GameEngine;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.common.ducks.IPacketClientSettings;
import com.mumfrey.liteloader.common.ducks.ITeleportHandler;
import com.mumfrey.liteloader.core.CommonPluginChannelListener;
import com.mumfrey.liteloader.core.IEventState;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.PlayerEventState;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.interfaces.FastIterable;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.Position;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;

public abstract class LiteLoaderEventBroker<TClient, TServer extends MinecraftServer>
implements InterfaceProvider,
ShutdownObserver {
    protected static LiteLoaderEventBroker<?, ?> broker;
    protected final LiteLoader loader;
    protected final GameEngine<TClient, TServer> engine;
    protected final rl profiler;
    protected LiteLoaderMods mods;
    private Map<UUID, PlayerEventState> playerStates = new HashMap<UUID, PlayerEventState>();
    private FastIterableDeque<IEventState> playerStateList = new HandlerList<IEventState>(IEventState.class);
    private FastIterable<ServerCommandProvider> serverCommandProviders = new HandlerList<ServerCommandProvider>(ServerCommandProvider.class);
    private FastIterable<ServerPlayerListener> serverPlayerListeners = new HandlerList<ServerPlayerListener>(ServerPlayerListener.class);
    private FastIterable<PlayerInteractionListener> playerInteractionListeners = new HandlerList<PlayerInteractionListener>(PlayerInteractionListener.class, HandlerList.ReturnLogicOp.AND);
    private FastIterable<PlayerMoveListener> playerMoveListeners = new HandlerList<PlayerMoveListener>(PlayerMoveListener.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
    private FastIterable<ServerTickable> serverTickListeners = new HandlerList<ServerTickable>(ServerTickable.class);
    private FastIterable<ShutdownListener> shutdownListeners = new HandlerList<ShutdownListener>(ShutdownListener.class);

    public LiteLoaderEventBroker(LiteLoader loader, GameEngine<TClient, TServer> engine, LoaderProperties properties) {
        this.loader = loader;
        this.engine = engine;
        this.profiler = engine.getProfiler();
        broker = this;
    }

    public static <TClient, TServer extends MinecraftServer> LiteLoaderEventBroker<TClient, TServer> getCommonBroker() {
        return broker;
    }

    void setMods(LiteLoaderMods mods) {
        this.mods = mods;
    }

    protected void onStartupComplete() {
        LoadingProgress.setMessage("Checking mods...");
        this.mods.onStartupComplete();
        LoadingProgress.setMessage("Initialising CoreProviders...");
        this.loader.onStartupComplete();
        LoadingProgress.setMessage("Starting Game...");
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return LiteMod.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(ServerCommandProvider.class);
        delegate.registerInterface(ServerPlayerListener.class);
        delegate.registerInterface(PlayerInteractionListener.class);
        delegate.registerInterface(PlayerMoveListener.class);
        delegate.registerInterface(CommonPluginChannelListener.class);
        delegate.registerInterface(ServerTickable.class);
        delegate.registerInterface(ShutdownListener.class);
    }

    public void addCommonPluginChannelListener(CommonPluginChannelListener listener) {
        if (!(listener instanceof PluginChannelListener) && !(listener instanceof ServerPluginChannelListener)) {
            LiteLoaderLogger.warning("Interface error for mod '%1s'. Implementing CommonPluginChannelListener has no effect! Use PluginChannelListener or ServerPluginChannelListener instead", listener.getName());
        }
    }

    public void addServerCommandProvider(ServerCommandProvider serverCommandProvider) {
        this.serverCommandProviders.add(serverCommandProvider);
    }

    public void addServerPlayerListener(ServerPlayerListener serverPlayerListener) {
        this.serverPlayerListeners.add(serverPlayerListener);
    }

    public void addPlayerInteractionListener(PlayerInteractionListener playerInteractionListener) {
        this.playerInteractionListeners.add(playerInteractionListener);
    }

    public void addPlayerMoveListener(PlayerMoveListener playerMoveListener) {
        this.playerMoveListeners.add(playerMoveListener);
    }

    public void addServerTickable(ServerTickable serverTickable) {
        this.serverTickListeners.add(serverTickable);
    }

    public void addShutdownListener(ShutdownListener shutdownListener) {
        this.shutdownListeners.add(shutdownListener);
    }

    public void onStartServer(MinecraftServer instance, String folderName, String worldName, amx worldSettings) {
        bl commandManager = instance.N();
        if (commandManager instanceof dh) {
            dh serverCommandManager = (dh)commandManager;
            this.serverCommandProviders.all().provideCommands(serverCommandManager);
        }
        LiteLoader.getServerPluginChannels().onServerStartup();
        this.playerStates.clear();
    }

    public void onSpawnPlayer(pl scm, oq player, GameProfile profile) {
        this.serverPlayerListeners.all().onPlayerConnect(player, profile);
        PlayerEventState playerState = this.getPlayerState(player);
        playerState.onSpawned();
    }

    public void onPlayerLogin(pl scm, oq player) {
        LiteLoader.getServerPluginChannels().onPlayerJoined(player);
    }

    public void onInitializePlayerConnection(pl scm, gw netManager, oq player) {
        this.serverPlayerListeners.all().onPlayerLoggedIn(player);
    }

    public void onRespawnPlayer(pl scm, oq player, oq oldPlayer, int dimension, boolean won) {
        this.serverPlayerListeners.all().onPlayerRespawn(player, oldPlayer, dimension, won);
    }

    public void onPlayerLogout(pl scm, oq player) {
        this.serverPlayerListeners.all().onPlayerLogout(player);
        this.removePlayer(player);
    }

    protected void onTick(boolean clock, float partialTicks, boolean inGame) {
        this.loader.onTick(clock, partialTicks, inGame);
    }

    protected void onPostRender(int mouseX, int mouseY, float partialTicks) {
        this.loader.onPostRender(mouseX, mouseY, partialTicks);
    }

    protected void onWorldChanged(amu world) {
        this.loader.onWorldChanged(world);
    }

    public void onServerTick(MinecraftServer server) {
        ((IEventState)this.playerStateList.all()).onTick(server);
        this.serverTickListeners.all().onTick(server);
    }

    public boolean onPlaceBlock(pa netHandler, oq player, ub hand, et pos, fa facing) {
        if (!this.onPlayerInteract(InteractType.PLACE_BLOCK_MAYBE, player, hand, player.b(hand), pos, facing)) {
            ij cancellation = new ij(player.l, pos.a(facing));
            netHandler.b.a.a((ht)cancellation);
            player.a(player.bx);
            return false;
        }
        return true;
    }

    public boolean onClickedAir(InteractType action, oq player, ub hand) {
        return this.onPlayerInteract(action, player, hand, player.b(hand), null, fa.d);
    }

    public boolean onPlayerDigging(InteractType action, oq player, pa netHandler, et pos) {
        if (!this.onPlayerInteract(action, player, ub.a, player.co(), pos, fa.d)) {
            ij cancellation = new ij(player.l, pos);
            netHandler.b.a.a((ht)cancellation);
            return false;
        }
        return true;
    }

    public boolean onUseItem(oq player, ub hand, aip stack, et pos, fa side) {
        if (!this.onPlayerInteract(InteractType.PLACE_BLOCK_MAYBE, player, hand, stack, pos, side)) {
            ij cancellation = new ij(player.l, pos);
            player.a.a((ht)cancellation);
            return false;
        }
        return true;
    }

    public boolean onBlockClicked(et pos, fa side, or manager) {
        oq player = manager.b;
        if (!this.onPlayerInteract(InteractType.LEFT_CLICK_BLOCK, player, ub.a, player.co(), pos, side)) {
            ij cancellation = new ij(manager.a, pos);
            player.a.a((ht)cancellation);
            return false;
        }
        return true;
    }

    public boolean onPlayerInteract(InteractType action, oq player, ub hand, aip stack, et position, fa side) {
        return this.getPlayerState(player).onPlayerInteract(action, player, hand, stack, position, side);
    }

    public boolean onPlayerSwapItems(oq player) {
        return this.playerInteractionListeners.all().onPlayerSwapItems(player);
    }

    void onPlayerClickedAir(oq player, PlayerInteractionListener.MouseButton button, ub hand, et tracePos, fa traceSideHit, bhc.a traceHitType) {
        this.playerInteractionListeners.all().onPlayerClickedAir(player, button, tracePos, traceSideHit, traceHitType);
    }

    boolean onPlayerClickedBlock(oq player, PlayerInteractionListener.MouseButton button, ub hand, aip stack, et hitPos, fa sideHit) {
        return this.playerInteractionListeners.all().onPlayerClickedBlock(player, button, hand, stack, hitPos, sideHit);
    }

    public boolean onPlayerMove(pa netHandler, lk packet, oq player, oo world) {
        Position from = new Position((vg)player, true);
        Position to = new Position(packet.a(player.p), packet.b(player.q), packet.c(player.r), packet.a(player.v), packet.b(player.w));
        ReturnValue<Position> pos = new ReturnValue<Position>(to);
        if (!this.playerMoveListeners.all().onPlayerMove(player, from, to, pos)) {
            int teleportId = ((ITeleportHandler)player.a).beginTeleport(from);
            player.a(from.b, from.c, from.d, player.x, player.y);
            player.a.a((ht)new jq(from.b, from.c, from.d, player.x, player.y, Collections.emptySet(), teleportId));
            return false;
        }
        if (pos.isSet()) {
            Position newPos = pos.get();
            netHandler.a(newPos.b, newPos.c, newPos.d, newPos.yaw, newPos.pitch);
            return false;
        }
        return true;
    }

    void onPlayerSettingsReceived(oq player, lc packet) {
        PlayerEventState playerState = this.getPlayerState(player);
        playerState.setTraceDistance(((IPacketClientSettings)packet).getViewDistance());
        playerState.setLocale(packet.a());
    }

    public PlayerEventState getPlayerState(oq player) {
        PlayerEventState playerState = this.playerStates.get(player.bm());
        if (playerState == null) {
            playerState = new PlayerEventState(player, this);
            this.playerStates.put(player.bm(), playerState);
            this.playerStateList.add(playerState);
        }
        return playerState;
    }

    protected void removePlayer(oq player) {
        PlayerEventState playerState = this.playerStates.remove(player.bm());
        if (playerState != null) {
            this.playerStateList.remove(playerState);
        }
    }

    @Override
    public void onShutDown() {
        for (ShutdownListener listener : this.shutdownListeners) {
            try {
                listener.onShutDown();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public static enum InteractType {
        RIGHT_CLICK,
        LEFT_CLICK,
        LEFT_CLICK_BLOCK,
        PLACE_BLOCK_MAYBE,
        DIG_BLOCK_MAYBE,
        DIG_BLOCK_END;

    }

    public static class ReturnValue<T> {
        private T value;
        private boolean isSet;

        public ReturnValue(T value) {
            this.value = value;
        }

        public ReturnValue() {
        }

        public boolean isSet() {
            return this.isSet;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.isSet = true;
            this.value = value;
        }
    }
}

