/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.ModLoadObserver;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.core.EnabledModsList;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.Mod;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.core.NonMod;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.interfaces.Loadable;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.interfaces.LoaderEnumerator;
import com.mumfrey.liteloader.interfaces.MixinContainer;
import com.mumfrey.liteloader.interfaces.TweakContainer;
import com.mumfrey.liteloader.launch.ClassTransformerManager;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.modconfig.ConfigManager;
import com.mumfrey.liteloader.modconfig.ConfigStrategy;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LiteLoaderMods {
    public static final String MOD_SYSTEM = "liteloader";
    protected final LiteLoader loader;
    protected final LoaderEnvironment environment;
    private final LoaderProperties properties;
    protected final LoaderEnumerator enumerator;
    private final ConfigManager configManager;
    private FastIterableDeque<ModLoadObserver> observers = new HandlerList<ModLoadObserver>(ModLoadObserver.class);
    private String loadedModsList = "none";
    protected final List<Mod> allMods = new ArrayList<Mod>();
    protected final Deque<Mod> initMods = new LinkedList<Mod>();
    protected final List<Mod> loadedMods = new ArrayList<Mod>();
    protected final List<Mod> badMods = new ArrayList<Mod>();
    protected final List<ModInfo<?>> disabledMods = new ArrayList();
    protected final List<ModInfo<?>> badContainers = new ArrayList();
    private int startupErrorCount;
    private int criticalErrorCount;

    LiteLoaderMods(LiteLoader loader, LoaderEnvironment environment, LoaderProperties properties, ConfigManager configManager) {
        this.loader = loader;
        this.environment = environment;
        this.enumerator = environment.getEnumerator();
        this.properties = properties;
        this.configManager = configManager;
    }

    void init(List<ModLoadObserver> observers) {
        this.observers.addAll(observers);
        this.disabledMods.addAll(this.enumerator.getDisabledContainers());
        this.badContainers.addAll(this.enumerator.getBadContainers());
    }

    void onPostInit() {
        this.updateSharedModList();
        this.environment.getEnabledModsList().save();
    }

    public EnabledModsList getEnabledModsList() {
        return this.environment.getEnabledModsList();
    }

    public List<Mod> getAllMods() {
        return Collections.unmodifiableList(this.allMods);
    }

    public String getLoadedModsList() {
        return this.loadedModsList;
    }

    public List<? extends ModInfo<LoadableMod<?>>> getLoadedMods() {
        return this.loadedMods;
    }

    public List<? extends ModInfo<?>> getDisabledMods() {
        return this.disabledMods;
    }

    public List<? extends ModInfo<?>> getBadContainers() {
        return this.badContainers;
    }

    public Collection<? extends ModInfo<Loadable<?>>> getInjectedTweaks() {
        return this.enumerator.getInjectedTweaks();
    }

    public int getStartupErrorCount() {
        return this.startupErrorCount;
    }

    public int getCriticalErrorCount() {
        return this.criticalErrorCount;
    }

    public ModInfo<?> getModInfo(LiteMod instance) {
        for (Mod mod : this.allMods) {
            if (instance != mod.getMod()) continue;
            return mod;
        }
        return null;
    }

    public boolean isModInstalled(String modName) {
        try {
            return this.getMod(modName) != null;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public <T extends LiteMod> T getMod(String modName) {
        if (modName == null) {
            throw new IllegalArgumentException("Attempted to get a reference to a mod without specifying a mod name");
        }
        for (Mod mod : this.allMods) {
            if (!mod.matchesName(modName)) continue;
            return (T)mod.getMod();
        }
        return null;
    }

    public <T extends LiteMod> T getMod(Class<T> modClass) {
        for (Mod mod : this.allMods) {
            if (!mod.getModClass().equals(modClass)) continue;
            return (T)mod.getMod();
        }
        return null;
    }

    public Class<? extends LiteMod> getModFromIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        for (Mod mod : this.allMods) {
            if (!mod.matchesIdentifier(identifier)) continue;
            return mod.getModClass();
        }
        return null;
    }

    public String getModMetaData(String modNameOrId, String metaDataKey, String defaultValue) throws IllegalArgumentException {
        String mod = (String)this.getMod(modNameOrId);
        return this.getModMetaData(mod, metaDataKey, defaultValue);
    }

    public String getModMetaData(LiteMod mod, String metaDataKey, String defaultValue) {
        if (mod == null || metaDataKey == null) {
            return defaultValue;
        }
        return this.enumerator.getModMetaData(mod.getClass(), metaDataKey, defaultValue);
    }

    public String getModMetaData(Class<? extends LiteMod> modClass, String metaDataKey, String defaultValue) {
        if (modClass == null || metaDataKey == null) {
            return defaultValue;
        }
        return this.enumerator.getModMetaData(modClass, metaDataKey, defaultValue);
    }

    public String getModIdentifier(Class<? extends LiteMod> modClass) {
        return this.enumerator.getIdentifier(modClass);
    }

    public String getModIdentifier(LiteMod mod) {
        return mod == null ? null : this.enumerator.getIdentifier(mod.getClass());
    }

    public LoadableMod<?> getModContainer(Class<? extends LiteMod> modClass) {
        return this.enumerator.getContainer(modClass);
    }

    public LoadableMod<?> getModContainer(LiteMod mod) {
        return mod == null ? null : this.enumerator.getContainer(mod.getClass());
    }

    public void enableMod(String identifier) {
        this.setModEnabled(identifier, true);
    }

    public void disableMod(String identifier) {
        this.setModEnabled(identifier, false);
    }

    public void setModEnabled(String identifier, boolean enabled) {
        this.environment.getEnabledModsList().setEnabled(this.environment.getProfile(), identifier, enabled);
        this.environment.getEnabledModsList().save();
    }

    public boolean isModEnabled(String identifier) {
        return this.environment.getEnabledModsList().isEnabled(LiteLoader.getProfile(), identifier);
    }

    public boolean isModEnabled(String profile, String identifier) {
        return this.environment.getEnabledModsList().isEnabled(profile, identifier);
    }

    public boolean isModActive(String identifier) {
        if (identifier == null) {
            return false;
        }
        for (Mod mod : this.loadedMods) {
            if (!mod.matchesIdentifier(identifier)) continue;
            return true;
        }
        return false;
    }

    void loadMods() {
        LoadingProgress.incTotalLiteLoaderProgress(this.enumerator.getModsToLoad().size());
        for (ModInfo<LoadableMod<?>> mod : this.enumerator.getModsToLoad()) {
            LoadingProgress.incLiteLoaderProgress("Loading mod from %s...", mod.getModClassSimpleName());
            LoadableMod<?> container = mod.getContainer();
            try {
                String identifier = mod.getIdentifier();
                if (identifier == null || this.environment.getEnabledModsList().isEnabled(this.environment.getProfile(), identifier)) {
                    if (!this.validateMixins(mod, container)) {
                        this.onModLoadFailed(container, identifier, "mixins for the specified mod encountered a startup error", null);
                        continue;
                    }
                    if (!this.enumerator.checkDependencies(container)) {
                        this.onModLoadFailed(container, identifier, "the mod was missing a required dependency", null);
                        continue;
                    }
                    if (mod instanceof Mod) {
                        this.loadMod((Mod)mod);
                    } else {
                        this.loadMod(identifier, mod.getModClass(), container);
                    }
                } else {
                    this.onModLoadFailed(container, identifier, "excluded by filter", null);
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                this.onModLoadFailed(container, mod.getModClassName(), "an error occurred", th);
                this.registerModStartupError(mod, th);
            }
            ((ModLoadObserver)this.observers.all()).onPostModLoaded(mod);
        }
    }

    private boolean validateMixins(ModInfo<?> mod, LoadableMod<?> container) {
        if (container instanceof MixinContainer) {
            Collection<Throwable> errors = ((MixinContainer)((Object)container)).getMixinErrors();
            for (Throwable error : errors) {
                this.registerModStartupError(mod, error, true);
            }
            return errors.size() == 0;
        }
        return true;
    }

    void loadMod(String identifier, Class<? extends LiteMod> modClass, LoadableMod<?> container) throws InstantiationException, IllegalAccessException {
        Mod mod = new Mod(container, modClass, identifier);
        this.loadMod(mod);
    }

    void loadMod(Mod mod) throws InstantiationException, IllegalAccessException {
        LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Loading mod from %s", mod.getModClassName());
        LiteMod newMod = mod.newInstance();
        this.onModLoaded(mod);
        String modName = mod.getDisplayName();
        LiteLoaderLogger.info("Successfully added mod %s version %s", modName, newMod.getVersion());
    }

    void onModLoaded(Mod mod) {
        ((ModLoadObserver)this.observers.all()).onModLoaded(mod.getMod());
        this.allMods.add(mod);
        this.initMods.add(mod);
        LoadingProgress.incTotalLiteLoaderProgress(1);
    }

    void onModLoadFailed(LoadableMod<?> container, String identifier, String reason, Throwable th) {
        LiteLoaderLogger.warning("Not loading mod %s, %s", identifier, reason);
        for (ModInfo<?> mod : this.disabledMods) {
            if (!mod.getContainer().equals(container)) continue;
            return;
        }
        if (container != LoadableMod.NONE) {
            this.disabledMods.add(new NonMod((Loadable<?>)container, false));
        }
        ((ModLoadObserver)this.observers.all()).onModLoadFailed(container, identifier, reason, th);
    }

    void initMods() {
        this.loadedModsList = "";
        int loadedModsCount = 0;
        while (this.initMods.size() > 0) {
            Mod mod = this.initMods.removeFirst();
            try {
                this.initMod(mod);
                ++loadedModsCount;
            }
            catch (Throwable th) {
                this.registerModStartupError(mod, th);
                LiteLoaderLogger.warning(th, "Error initialising mod '%s'", mod.getDisplayName());
            }
        }
        this.loadedModsList = String.format("%s loaded mod(s)%s", loadedModsCount, this.loadedModsList);
    }

    private void initMod(Mod mod) {
        LiteMod instance = mod.getMod();
        LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Initialising mod %s version %s", instance.getName(), instance.getVersion());
        LoadingProgress.incLiteLoaderProgress("Initialising mod %s version %s...", instance.getName(), instance.getVersion());
        this.onPreInitMod(instance);
        instance.init(LiteLoader.getCommonConfigFolder());
        this.onPostInitMod(instance);
        this.loadedMods.add(mod);
        this.loadedModsList = this.loadedModsList + String.format("\n          - %s version %s", mod.getDisplayName(), mod.getVersion());
    }

    private void onPreInitMod(LiteMod instance) {
        ((ModLoadObserver)this.observers.all()).onPreInitMod(instance);
        this.configManager.registerMod(instance);
        try {
            this.handleModVersionUpgrade(instance);
        }
        catch (Throwable th) {
            LiteLoaderLogger.warning("Error performing settings upgrade for %s. Settings may not be properly migrated", instance.getName());
        }
        this.configManager.initConfig(instance);
    }

    private void onPostInitMod(LiteMod instance) {
        ((ModLoadObserver)this.observers.all()).onPostInitMod(instance);
        LiteLoader.getInterfaceManager().offer(instance);
        this.loader.onPostInitMod(instance);
    }

    private void handleModVersionUpgrade(LiteMod instance) {
        int lastKnownRevision;
        LiteLoaderVersion lastModVersion;
        String modKey = this.getModNameForConfig(instance.getClass(), instance.getName());
        int currentRevision = LiteLoaderVersion.CURRENT.getLoaderRevision();
        if (currentRevision > (lastModVersion = LiteLoaderVersion.getVersionFromRevision(lastKnownRevision = this.properties.getLastKnownModRevision(modKey))).getLoaderRevision()) {
            File newConfigPath = LiteLoader.getConfigFolder();
            File oldConfigPath = this.environment.inflectVersionedConfigPath(lastModVersion);
            LiteLoaderLogger.info("Performing config upgrade for mod %s. Upgrading %s to %s...", new Object[]{instance.getName(), lastModVersion, LiteLoaderVersion.CURRENT});
            ((ModLoadObserver)this.observers.all()).onMigrateModConfig(instance, newConfigPath, oldConfigPath);
            this.configManager.migrateModConfig(instance, newConfigPath, oldConfigPath);
            instance.upgradeSettings(LiteLoaderVersion.CURRENT.getMinecraftVersion(), newConfigPath, oldConfigPath);
            this.properties.storeLastKnownModRevision(modKey);
            LiteLoaderLogger.info("Config upgrade succeeded for mod %s", instance.getName());
        } else if (currentRevision < lastKnownRevision && ConfigManager.getConfigStrategy(instance) == ConfigStrategy.Unversioned) {
            LiteLoaderLogger.warning("Mod %s has config from unknown loader revision %d. This may cause unexpected behaviour.", instance.getName(), lastKnownRevision);
        }
    }

    String getModNameForConfig(Class<? extends LiteMod> modClass, String modName) {
        if (modName == null || modName.isEmpty()) {
            modName = modClass.getSimpleName().toLowerCase();
        }
        return String.format("version.%s", modName.toLowerCase().replaceAll("[^a-z0-9_\\-\\.]", ""));
    }

    void onStartupComplete() {
        this.validateModTransformers();
    }

    private void validateModTransformers() {
        ClassTransformerManager transformerManager = this.environment.getTransformerManager();
        Set<String> injectedTransformers = transformerManager.getInjectedTransformers();
        for (Mod mod : this.loadedMods) {
            if (!mod.hasClassTransformers()) continue;
            List<String> modTransformers = ((TweakContainer)mod.getContainer()).getClassTransformerClassNames();
            for (String modTransformer : modTransformers) {
                if (injectedTransformers.contains(modTransformer)) continue;
                List<Throwable> throwables = transformerManager.getTransformerStartupErrors(modTransformer);
                if (throwables != null) {
                    for (Throwable th : throwables) {
                        this.registerModStartupError(mod, th, true);
                    }
                    continue;
                }
                this.registerModStartupError(mod, new RuntimeException("Missing class transformer " + modTransformer), true);
            }
        }
    }

    public void onLateInitFailed(LiteMod instance, Throwable th) {
        ModInfo<?> mod = this.getModInfo(instance);
        if (mod != null) {
            this.registerModStartupError(mod, th);
        }
    }

    private void registerModStartupError(ModInfo<?> mod, Throwable th) {
        boolean critical = this.hasModInjectedTransformers(mod);
        this.registerModStartupError(mod, th, critical);
    }

    private boolean hasModInjectedTransformers(ModInfo<?> mod) {
        if (!mod.hasClassTransformers()) {
            return false;
        }
        Set<String> injectedTransformers = this.environment.getTransformerManager().getInjectedTransformers();
        List<String> modTransformers = ((TweakContainer)mod.getContainer()).getClassTransformerClassNames();
        for (String modTransformer : modTransformers) {
            if (!injectedTransformers.contains(modTransformer)) continue;
            return true;
        }
        return false;
    }

    private void registerModStartupError(ModInfo<?> mod, Throwable th, boolean critical) {
        ++this.startupErrorCount;
        if (critical) {
            ++this.criticalErrorCount;
        }
        mod.registerStartupError(th);
        if (!this.loadedMods.contains(mod) && !this.disabledMods.contains(mod)) {
            this.disabledMods.add(mod);
        }
    }

    void updateSharedModList() {
        Map<String, Map<String, String>> modList = this.enumerator.getSharedModList();
        if (modList == null) {
            return;
        }
        for (Mod mod : this.allMods) {
            String modKey = String.format("%s:%s", MOD_SYSTEM, mod.getIdentifier());
            modList.put(modKey, this.packModInfoToMap(mod));
        }
    }

    private Map<String, String> packModInfoToMap(Mod mod) {
        HashMap<String, String> modInfo = new HashMap<String, String>();
        modInfo.put("modsystem", MOD_SYSTEM);
        modInfo.put("id", mod.getIdentifier());
        modInfo.put("version", mod.getVersion());
        modInfo.put("name", mod.getDisplayName());
        modInfo.put("url", mod.getURL());
        modInfo.put("authors", mod.getAuthor());
        modInfo.put("description", mod.getDescription());
        return modInfo;
    }
}

