/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.PlayerInteractionListener;
import com.mumfrey.liteloader.core.IEventState;
import com.mumfrey.liteloader.core.LiteLoaderEventBroker;
import com.mumfrey.liteloader.util.EntityUtilities;
import java.lang.ref.WeakReference;
import net.minecraft.server.MinecraftServer;

public class PlayerEventState
implements IEventState {
    private static long MISS = new et(-1, -1, -1).g();
    private WeakReference<oq> playerRef;
    private final LiteLoaderEventBroker<?, ?> broker;
    private double traceDistance = 256.0;
    private int suppressLeftTicks;
    private int suppressRightTicks;
    private boolean leftClick;
    private boolean rightClick;
    private boolean digging;
    private ub hand = ub.a;
    private bhc hit;
    private String locale = "en_US";

    public PlayerEventState(oq player, LiteLoaderEventBroker<?, ?> broker) {
        this.playerRef = new WeakReference<oq>(player);
        this.broker = broker;
    }

    public void setTraceDistance(int renderDistance) {
        this.traceDistance = (double)renderDistance * 16.0;
    }

    public double getTraceDistance() {
        return this.traceDistance;
    }

    public void setLocale(String lang) {
        if (lang.matches("^[a-z]{2}_[A-Z]{2}$")) {
            this.locale = lang;
        }
    }

    public String getLocale() {
        return this.locale;
    }

    public oq getPlayer() {
        return (oq)this.playerRef.get();
    }

    public void onSpawned() {
    }

    @Override
    public void onTick(MinecraftServer server) {
        if (this.leftClick && this.suppressLeftTicks == 0 && !this.digging) {
            this.broker.onPlayerClickedAir(this.getPlayer(), PlayerInteractionListener.MouseButton.LEFT, this.hand, this.hit.a(), this.hit.b, this.hit.a);
        }
        if (this.rightClick && this.suppressRightTicks == 0) {
            this.broker.onPlayerClickedAir(this.getPlayer(), PlayerInteractionListener.MouseButton.RIGHT, this.hand, this.hit.a(), this.hit.b, this.hit.a);
        }
        if (this.suppressLeftTicks > 0) {
            --this.suppressLeftTicks;
        }
        if (this.suppressRightTicks > 0) {
            --this.suppressRightTicks;
        }
        this.leftClick = false;
        this.rightClick = false;
    }

    public boolean onPlayerInteract(LiteLoaderEventBroker.InteractType action, oq player, ub hand, aip stack, et position, fa side) {
        if (action == LiteLoaderEventBroker.InteractType.DIG_BLOCK_MAYBE && !player.z()) {
            this.digging = true;
        }
        if (action == LiteLoaderEventBroker.InteractType.DIG_BLOCK_END) {
            this.digging = false;
            ++this.suppressLeftTicks;
            return true;
        }
        this.hit = EntityUtilities.rayTraceFromEntity((vg)player, this.traceDistance, 0.0f);
        if (action == LiteLoaderEventBroker.InteractType.LEFT_CLICK) {
            this.leftClick = true;
            this.hand = hand;
            return true;
        }
        if (action == LiteLoaderEventBroker.InteractType.RIGHT_CLICK) {
            this.digging = false;
            this.hand = hand;
            this.rightClick = true;
            return true;
        }
        if ((action == LiteLoaderEventBroker.InteractType.LEFT_CLICK_BLOCK || action == LiteLoaderEventBroker.InteractType.DIG_BLOCK_MAYBE) && this.suppressLeftTicks == 0) {
            this.suppressLeftTicks += 2;
            return this.broker.onPlayerClickedBlock(player, PlayerInteractionListener.MouseButton.LEFT, hand, stack, position, side);
        }
        if (action == LiteLoaderEventBroker.InteractType.PLACE_BLOCK_MAYBE) {
            this.digging = false;
            if (this.suppressRightTicks > 0 && this.suppressRightTicks != 1 && hand != this.hand) {
                return true;
            }
            if (position.g() == MISS) {
                bhc actualHit = EntityUtilities.rayTraceFromEntity((vg)player, player.bO.d ? 5.0 : 4.5, 0.0f);
                if (actualHit.a == bhc.a.a) {
                    this.digging = false;
                    this.hand = hand;
                    this.rightClick = true;
                    return true;
                }
            }
            this.hand = hand;
            ++this.suppressRightTicks;
            ++this.suppressLeftTicks;
            return this.broker.onPlayerClickedBlock(player, PlayerInteractionListener.MouseButton.RIGHT, hand, stack, position, side);
        }
        return true;
    }
}

