/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api;

import com.google.common.base.Charsets;
import com.mumfrey.liteloader.api.EnumeratorModule;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.api.LiteLoaderCoreAPI;
import com.mumfrey.liteloader.core.api.LoadableModFile;
import com.mumfrey.liteloader.interfaces.LoadableFile;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.interfaces.ModularEnumerator;
import com.mumfrey.liteloader.interfaces.TweakContainer;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.launchwrapper.LaunchClassLoader;

public abstract class EnumeratorModuleFiles
implements FilenameFilter,
EnumeratorModule {
    private final ContainerEnvironment containers;
    private final List<LoadableMod<File>> loadableMods = new ArrayList<LoadableMod<File>>();
    protected final LiteLoaderCoreAPI api;

    public EnumeratorModuleFiles(LiteLoaderCoreAPI api, ContainerEnvironment containers) {
        this.api = api;
        this.containers = containers;
    }

    protected abstract boolean readJarFiles();

    protected abstract boolean loadTweakJars();

    protected abstract boolean loadTweaks();

    protected abstract boolean forceInjection();

    protected abstract File[] getFiles();

    @Override
    public void init(LoaderEnvironment environment, LoaderProperties properties) {
    }

    @Override
    public void writeSettings(LoaderEnvironment environment, LoaderProperties properties) {
    }

    public List<LoadableMod<File>> getLoadableMods() {
        return this.loadableMods;
    }

    @Override
    public boolean accept(File dir, String fileName) {
        if ((fileName = fileName.toLowerCase()).endsWith(".litemod.zip")) {
            LiteLoaderLogger.warning("Found %s with unsupported extension .litemod.zip. Please change file extension to .litemod to allow this file to be loaded!", fileName);
            return true;
        }
        return fileName.endsWith(".litemod") || fileName.endsWith(".jar");
    }

    protected void findValidFiles(ModularEnumerator enumerator) {
        for (File file : this.getFiles()) {
            LoadableFile candidateFile = new LoadableFile(file);
            candidateFile.setForceInjection(this.forceInjection());
            try {
                this.inspectFile(enumerator, candidateFile);
            }
            catch (Exception ex) {
                LiteLoaderLogger.warning(ex, "An error occurred whilst inspecting %s", candidateFile);
            }
        }
    }

    protected void inspectFile(ModularEnumerator enumerator, LoadableFile candidateFile) {
        if (this.isValidFile(enumerator, candidateFile)) {
            String metaData = candidateFile.getFileContents("litemod.json", Charsets.UTF_8);
            if (metaData != null) {
                LoadableMod<File> modFile = this.getModFile(candidateFile, metaData);
                this.addModFile(enumerator, modFile);
                return;
            }
            if (this.isValidTweakContainer(candidateFile)) {
                TweakContainer<File> container = this.getTweakFile(candidateFile);
                this.addTweakFile(enumerator, container);
                return;
            }
            LiteLoaderLogger.info("Ignoring %s", candidateFile);
        }
    }

    protected boolean isValidFile(ModularEnumerator enumerator, LoadableFile candidateFile) {
        String filename = candidateFile.getName().toLowerCase();
        if (filename.endsWith(".litemod.zip")) {
            enumerator.registerBadContainer(candidateFile, "Invalid file extension .litemod.zip");
            return false;
        }
        if (filename.endsWith(".litemod")) {
            return true;
        }
        if (filename.endsWith(".jar")) {
            Set<String> modSystems = candidateFile.getModSystems();
            boolean hasLiteLoader = modSystems.contains("LiteLoader");
            if (modSystems.size() > 0) {
                LiteLoaderLogger.info("%s supports mod systems %s", candidateFile, modSystems);
                if (!hasLiteLoader) {
                    return false;
                }
            }
            return this.loadTweakJars() || this.readJarFiles() || hasLiteLoader;
        }
        return false;
    }

    protected boolean isValidTweakContainer(LoadableFile candidateFile) {
        return this.loadTweakJars() && this.loadTweaks() && candidateFile.getName().toLowerCase().endsWith(".jar");
    }

    protected FilenameFilter getFilenameFilter() {
        return this;
    }

    protected boolean isFileSupported(LoadableMod<File> modFile) {
        return LiteLoaderVersion.CURRENT.isVersionSupported(modFile.getTargetVersion());
    }

    protected LoadableMod<File> getModFile(LoadableFile candidateFile, String metaData) {
        return new LoadableModFile(candidateFile, metaData);
    }

    protected TweakContainer<File> getTweakFile(LoadableFile candidateFile) {
        return candidateFile;
    }

    protected void addModFile(ModularEnumerator enumerator, LoadableMod<File> modFile) {
        if (modFile.hasValidMetaData()) {
            if (this.isFileSupported(modFile)) {
                this.containers.addCandidate(modFile);
            } else {
                LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Not adding invalid or version-mismatched mod file: %s", modFile);
                enumerator.registerBadContainer(modFile, "Version not supported");
            }
        }
    }

    protected void addTweakFile(ModularEnumerator enumerator, TweakContainer<File> container) {
        enumerator.registerTweakContainer(container);
    }

    protected void sortAndRegisterFiles(ModularEnumerator enumerator) {
        for (ContainerEnvironment.Candidate candidate : this.containers) {
            if (candidate.isRegistered()) continue;
            LoadableMod<File> newestVersion = candidate.getNewestVersion();
            this.registerFile(enumerator, newestVersion);
            candidate.register();
        }
    }

    protected void registerFile(ModularEnumerator enumerator, LoadableMod<File> modFile) {
        if (enumerator.registerModContainer(modFile)) {
            LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Adding newest valid mod file '%s' at revision %.4f", modFile, Float.valueOf(modFile.getRevision()));
            this.loadableMods.add(modFile);
        } else {
            LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Not adding valid mod file '%s', the specified mod is disabled or missing a required dependency", modFile);
        }
        if (this.loadTweaks()) {
            try {
                if (modFile instanceof TweakContainer) {
                    this.addTweakFile(enumerator, (TweakContainer)((Object)modFile));
                }
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning("Error adding tweaks from '%s'", modFile);
            }
        }
    }

    @Override
    public void injectIntoClassLoader(ModularEnumerator enumerator, LaunchClassLoader classLoader) {
        LiteLoaderLogger.info("Injecting external mods into class path...", new Object[0]);
        for (LoadableMod<File> loadableMod : this.loadableMods) {
            try {
                if (!loadableMod.injectIntoClassPath(classLoader, false)) continue;
                LiteLoaderLogger.info("Successfully injected mod file '%s' into classpath", loadableMod);
            }
            catch (MalformedURLException ex) {
                LiteLoaderLogger.warning("Error injecting '%s' into classPath. The mod will not be loaded", loadableMod);
            }
        }
    }

    @Override
    public void registerMods(ModularEnumerator enumerator, LaunchClassLoader classLoader) {
        LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Discovering mods in valid mod files...", new Object[0]);
        LoadingProgress.incTotalLiteLoaderProgress(this.loadableMods.size());
        for (LoadableMod<File> modFile : this.loadableMods) {
            LoadingProgress.incLiteLoaderProgress("Searching for mods in " + modFile.getModName() + "...");
            LiteLoaderLogger.info("Searching %s...", modFile);
            try {
                enumerator.registerModsFrom(modFile, true);
            }
            catch (Exception ex) {
                LiteLoaderLogger.warning("Error encountered whilst searching in %s...", modFile);
            }
        }
    }

    public static class ContainerEnvironment
    implements Iterable<Candidate> {
        private final Map<String, Candidate> orderedCandidates = new LinkedHashMap<String, Candidate>();

        public void addCandidate(LoadableMod<File> modFile) {
            if (!this.orderedCandidates.containsKey(modFile.getModName())) {
                this.orderedCandidates.put(modFile.getModName(), new Candidate());
            }
            LiteLoaderLogger.info("Considering valid mod file: %s", modFile);
            this.orderedCandidates.get(modFile.getModName()).add(modFile);
        }

        @Override
        public Iterator<Candidate> iterator() {
            return this.orderedCandidates.values().iterator();
        }

        static class Candidate {
            private final Set<LoadableMod<File>> availableFiles = new TreeSet<LoadableMod<File>>();
            private boolean isRegistered;

            Candidate() {
            }

            public void add(LoadableMod<File> modFile) {
                if (!this.isRegistered) {
                    this.availableFiles.add(modFile);
                }
            }

            public LoadableMod<File> getNewestVersion() {
                return this.availableFiles.iterator().next();
            }

            public boolean isRegistered() {
                return this.isRegistered;
            }

            public void register() {
                this.isRegistered = true;
            }
        }
    }
}

