/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api;

import com.mumfrey.liteloader.api.EnumeratorModule;
import com.mumfrey.liteloader.api.LiteAPI;
import com.mumfrey.liteloader.api.MixinConfigProvider;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.api.EnumeratorModuleClassPath;
import com.mumfrey.liteloader.core.api.EnumeratorModuleFiles;
import com.mumfrey.liteloader.core.api.EnumeratorModuleFolder;
import com.mumfrey.liteloader.core.api.EnumeratorModuleRepository;
import com.mumfrey.liteloader.interfaces.ObjectFactory;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LiteLoaderCoreAPI
implements LiteAPI,
MixinConfigProvider {
    protected static final String PKG_LITELOADER = "com.mumfrey.liteloader";
    protected static final String PKG_LITELOADER_COMMON = "com.mumfrey.liteloader.common";
    protected LoaderEnvironment environment;
    protected LoaderProperties properties;
    protected boolean searchClassPath;
    protected boolean searchModsFolder;

    @Override
    public String getIdentifier() {
        return "liteloader";
    }

    @Override
    public String getName() {
        return "LiteLoader core API";
    }

    @Override
    public String getVersion() {
        return LiteLoaderVersion.CURRENT.getLoaderVersion();
    }

    @Override
    public int getRevision() {
        return LiteLoaderVersion.CURRENT.getLoaderRevision();
    }

    @Override
    public String getModClassPrefix() {
        return "LiteMod";
    }

    @Override
    public void init(LoaderEnvironment environment, LoaderProperties properties) {
        this.environment = environment;
        this.properties = properties;
    }

    void readDiscoverySettings() {
        this.searchModsFolder = this.properties.getAndStoreBooleanProperty("search.mods", true);
        this.searchClassPath = this.properties.getAndStoreBooleanProperty("search.classpath", true);
        if (!this.searchModsFolder && !this.searchClassPath) {
            LiteLoaderLogger.warning("Invalid configuration, no search locations defined. Enabling all search locations.", new Object[0]);
            this.searchModsFolder = true;
            this.searchClassPath = true;
        }
    }

    void writeDiscoverySettings() {
        this.properties.setBooleanProperty("search.mods", this.searchModsFolder);
        this.properties.setBooleanProperty("search.classpath", this.searchClassPath);
    }

    @Override
    public List<EnumeratorModule> getEnumeratorModules() {
        String modsRepoFile;
        this.readDiscoverySettings();
        ArrayList<EnumeratorModule> enumeratorModules = new ArrayList<EnumeratorModule>();
        if (this.searchClassPath) {
            enumeratorModules.add(new EnumeratorModuleClassPath());
        }
        EnumeratorModuleFiles.ContainerEnvironment containers = new EnumeratorModuleFiles.ContainerEnvironment();
        if (this.searchModsFolder) {
            File modsFolder = this.environment.getModsFolder();
            enumeratorModules.add(new EnumeratorModuleFolder(this, containers, modsFolder, false));
            File versionedModsFolder = this.environment.getVersionedModsFolder();
            enumeratorModules.add(new EnumeratorModuleFolder(this, containers, versionedModsFolder, true));
        }
        if ((modsRepoFile = this.environment.getModsRepoFile()) != null) {
            File modList = new File(modsRepoFile);
            enumeratorModules.add(new EnumeratorModuleRepository(this, containers, this.environment.getModRepository(), modList));
        }
        return Collections.unmodifiableList(enumeratorModules);
    }

    public abstract ObjectFactory<?, ?> getObjectFactory();

    @Override
    public MixinConfigProvider getMixins() {
        return this;
    }

    @Override
    public String[] getMixinConfigs() {
        return new String[]{"mixins.liteloader.core.json"};
    }

    @Override
    public String[] getErrorHandlers() {
        return null;
    }
}

