/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api.repository;

import com.google.common.collect.ImmutableList;
import com.mumfrey.liteloader.core.api.repository.Artefact;
import com.mumfrey.liteloader.core.api.repository.JsonResolver;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Repository {
    private final File root;
    private final File defaultRepositoryRoot;
    private final Map<String, JsonResolver> resolvers = new TreeMap<String, JsonResolver>();
    private final List<Artefact> artefacts = new ArrayList<Artefact>();

    public Repository(File root, File defaultRepositoryRoot) {
        this.root = root;
        this.defaultRepositoryRoot = defaultRepositoryRoot;
    }

    public File getRoot() {
        return this.root;
    }

    public File getDefaultRepositoryRoot() {
        return this.defaultRepositoryRoot;
    }

    Map<String, JsonResolver> getResolvers() {
        return this.resolvers;
    }

    JsonResolver getResolver(File path) {
        String location = path.getAbsolutePath();
        JsonResolver resolver = this.resolvers.get(location);
        if (resolver == null) {
            resolver = JsonResolver.createFrom(path);
            this.resolvers.put(location, resolver);
        }
        return resolver;
    }

    public void resolve(File path) {
        JsonResolver resolver = this.getResolver(path);
        resolver.resolve(this);
        this.artefacts.addAll(resolver.getArtefacts().values());
    }

    public Collection<Artefact> getArtefacts() {
        return Collections.unmodifiableList(this.artefacts);
    }

    public Collection<File> getFiles() {
        ImmutableList.Builder files = ImmutableList.builder();
        for (Artefact artefact : this.artefacts) {
            if (artefact.exists()) {
                files.add((Object)artefact.getFile());
                continue;
            }
            LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Rejecting non-existent artefact %s at %s", artefact.getArtefactId(), artefact.getFile());
        }
        return files.build();
    }

    static boolean isAbsolutePath(String path) {
        return path.matches("^([a-zA-Z]:[/\\\\]|/).+$");
    }
}

