/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.modconfig;

import com.mojang.authlib.GameProfile;
import com.mumfrey.liteloader.InitCompleteListener;
import com.mumfrey.liteloader.Tickable;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import com.mumfrey.webprefs.WebPreferencesManager;
import com.mumfrey.webprefs.exceptions.InvalidKeyException;
import com.mumfrey.webprefs.interfaces.IWebPreferences;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;

public abstract class CloudConfig {
    public static final int TICKS_PER_SECOND = 20;
    public static final int DEFAULT_UPDATE_INTERVAL = 100;
    private static final int POLL_UPDATE_INTERVAL = 20;
    private static final int POLL_RESET_INTERVAL = 1200;
    protected static final Pattern keyPattern = Pattern.compile("^[a-z0-9_\\-\\.]{1,32}$");
    protected static final Pattern fieldKeyPattern = Pattern.compile("(?i)^[a-z0-9_\\-\\$]{1,32}$");
    protected final WebPreferencesManager manager;
    protected final IWebPreferences preferences;
    private final List<TrackedField> fields = new ArrayList<TrackedField>();
    private final int desiredUpdateInterval;
    private int updateInterval;
    private int updateCounter;
    private int pendingResetCounter;

    protected CloudConfig(boolean privatePrefs) {
        this(WebPreferencesManager.getDefault(), privatePrefs, 100);
    }

    protected CloudConfig(WebPreferencesManager manager, boolean privatePrefs) {
        this(manager, privatePrefs, 100);
    }

    protected CloudConfig(WebPreferencesManager manager, boolean privatePrefs, int updateInterval) {
        this(manager, manager.getLocalPreferences(privatePrefs), updateInterval);
    }

    protected CloudConfig(WebPreferencesManager manager, aed player, boolean privatePrefs) {
        this(manager, player, privatePrefs, 100);
    }

    protected CloudConfig(WebPreferencesManager manager, aed player, boolean privatePrefs, int updateInterval) {
        this(manager, manager.getPreferences(player, privatePrefs), updateInterval);
    }

    protected CloudConfig(WebPreferencesManager manager, GameProfile profile, boolean privatePrefs) {
        this(manager, profile, privatePrefs, 100);
    }

    protected CloudConfig(WebPreferencesManager manager, GameProfile profile, boolean privatePrefs, int updateInterval) {
        this(manager, manager.getPreferences(profile, privatePrefs), updateInterval);
    }

    protected CloudConfig(WebPreferencesManager manager, UUID uuid, boolean privatePrefs) {
        this(manager, uuid, privatePrefs, 100);
    }

    protected CloudConfig(WebPreferencesManager manager, UUID uuid, boolean privatePrefs, int updateInterval) {
        this(manager, manager.getPreferences(uuid, privatePrefs), updateInterval);
    }

    private CloudConfig(WebPreferencesManager manager, IWebPreferences preferences, int updateInterval) {
        this.manager = manager;
        this.preferences = preferences;
        this.updateInterval = this.desiredUpdateInterval = updateInterval;
        this.initFields();
    }

    public final void poll() {
        this.preferences.poll();
        this.updateInterval = Math.min(this.desiredUpdateInterval, 20);
        this.pendingResetCounter = 1200;
    }

    public final void commit() {
        this.preferences.commit(false);
    }

    private void initFields() {
        for (Field field : this.getClass().getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) {
                LiteLoaderLogger.debug("Skipping transient field %s in %s", field.getName(), this.getClass().getName());
                continue;
            }
            if (!fieldKeyPattern.matcher(field.getName()).matches()) {
                LiteLoaderLogger.warning("Skipping field with invalid name %s in %s", field.getName(), this.getClass().getName());
                continue;
            }
            Class<?> type = field.getType();
            try {
                field.setAccessible(true);
                if (type == String.class) {
                    this.fields.add(new TrackedStringField(field));
                    continue;
                }
                if (type == Integer.TYPE) {
                    this.fields.add(new TrackedIntegerField(field));
                    continue;
                }
                if (type == Float.TYPE) {
                    this.fields.add(new TrackedFloatField(field));
                    continue;
                }
                if (type == Boolean.TYPE) {
                    this.fields.add(new TrackedBooleanField(field));
                    continue;
                }
            }
            catch (IllegalAccessException ex) {
                LiteLoaderLogger.warning("Skipping inaccessible field %s in %s", field.getName(), this.getClass().getName());
                ex.printStackTrace();
            }
            LiteLoaderLogger.warning("Skipping field %s with unsupported type %s in %s", field.getName(), type, this.getClass().getName());
        }
        if (this.fields.size() > 0) {
            UpdateTicker.getInstance().register(this);
        }
    }

    final void onTick() {
        if (this.pendingResetCounter > 0) {
            --this.pendingResetCounter;
            if (this.pendingResetCounter == 0) {
                this.updateInterval = this.desiredUpdateInterval;
            }
        }
        if (++this.updateCounter > this.updateInterval) {
            this.updateCounter = 0;
            boolean dirty = false;
            Iterator<TrackedField> iter = this.fields.iterator();
            while (iter.hasNext()) {
                TrackedField field = iter.next();
                try {
                    field.sync();
                    dirty |= field.isDirty();
                }
                catch (IllegalAccessException ex) {
                    LiteLoaderLogger.warning("Removing invalid field %s in %s", field, this.getClass().getName());
                    ex.printStackTrace();
                    iter.remove();
                }
            }
            if (dirty) {
                this.updateInterval = this.desiredUpdateInterval;
                this.pendingResetCounter = 0;
                this.onUpdated();
            }
        }
    }

    protected void onUpdated() {
    }

    protected String getPrefix() {
        return null;
    }

    static final class UpdateTicker
    implements InitCompleteListener,
    Tickable {
        private static UpdateTicker instance;
        private final List<CloudConfig> prefs = new ArrayList<CloudConfig>();

        static UpdateTicker getInstance() {
            if (instance == null) {
                instance = new UpdateTicker();
                LiteLoader.getInterfaceManager().registerListener(instance);
            }
            return instance;
        }

        private UpdateTicker() {
        }

        void register(CloudConfig pref) {
            this.prefs.add(pref);
        }

        @Override
        public void onTick(bib minecraft, float partialTicks, boolean inGame, boolean clock) {
            for (CloudConfig pref : this.prefs) {
                if (!clock) continue;
                pref.onTick();
            }
        }

        @Override
        public void onInitCompleted(bib minecraft, LiteLoader loader) {
            for (CloudConfig pref : this.prefs) {
                pref.poll();
            }
        }

        @Override
        public final String getVersion() {
            return "N/A";
        }

        @Override
        public final void init(File configPath) {
        }

        @Override
        public final void upgradeSettings(String version, File configPath, File oldConfigPath) {
        }

        @Override
        public final String getName() {
            return "UpdateTicker";
        }
    }

    class TrackedBooleanField
    extends TrackedField {
        private boolean localValue;

        TrackedBooleanField(Field handle) throws IllegalAccessException {
            super(handle);
            this.localValue = (Boolean)this.getValue();
        }

        @Override
        void sync() throws IllegalAccessException {
            boolean remoteValue;
            boolean value = (Boolean)this.getValue();
            if (this.initialUpdate) {
                this.initialUpdate = false;
            } else if (value != this.localValue) {
                CloudConfig.this.preferences.set(this.name, String.valueOf(value));
            } else if (CloudConfig.this.preferences.has(this.name) && value != (remoteValue = this.tryParse(CloudConfig.this.preferences.get(this.name), value))) {
                value = remoteValue;
                this.setValue(value);
            }
            this.localValue = value;
        }

        private boolean tryParse(String string, boolean value) {
            boolean isTrue = "true".equals(string);
            return isTrue || "false".equals(string) ? isTrue : value;
        }
    }

    class TrackedFloatField
    extends TrackedField {
        private float localValue;

        TrackedFloatField(Field handle) {
            super(handle);
        }

        @Override
        void sync() throws IllegalAccessException {
            float remoteValue;
            float value = ((Float)this.getValue()).floatValue();
            if (this.initialUpdate) {
                this.initialUpdate = false;
            } else if (value != this.localValue) {
                CloudConfig.this.preferences.set(this.name, String.valueOf(value));
            } else if (CloudConfig.this.preferences.has(this.name) && value != (remoteValue = this.tryParse(CloudConfig.this.preferences.get(this.name), value))) {
                value = remoteValue;
                this.setValue(Float.valueOf(value));
            }
            this.localValue = value;
        }

        private float tryParse(String string, float defaultValue) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }
    }

    class TrackedIntegerField
    extends TrackedField {
        private int localValue;

        TrackedIntegerField(Field handle) {
            super(handle);
        }

        @Override
        void sync() throws IllegalAccessException {
            int remoteValue;
            int value = (Integer)this.getValue();
            if (this.initialUpdate) {
                this.initialUpdate = false;
            } else if (value != this.localValue) {
                CloudConfig.this.preferences.set(this.name, String.valueOf(value));
            } else if (CloudConfig.this.preferences.has(this.name) && value != (remoteValue = this.tryParse(CloudConfig.this.preferences.get(this.name), value))) {
                value = remoteValue;
                this.setValue(value);
            }
            this.localValue = value;
        }

        private int tryParse(String string, int defaultValue) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }
    }

    class TrackedStringField
    extends TrackedField {
        private String localValue;

        TrackedStringField(Field handle) throws IllegalAccessException {
            super(handle);
            this.localValue = (String)this.getValue();
        }

        @Override
        void sync() throws IllegalAccessException {
            String remoteValue;
            String value = (String)this.getValue();
            if (this.initialUpdate) {
                this.initialUpdate = false;
            } else if (value != this.localValue && value != null) {
                if (value.length() > 255) {
                    LiteLoaderLogger.warning("Unable to synchronise setting [%s], length > 255 chars. The value will be truncated!", this.name);
                    value = value.substring(0, 255);
                    this.setValue(value);
                    this.isDirty();
                }
                CloudConfig.this.preferences.set(this.name, value);
            } else if (CloudConfig.this.preferences.has(this.name) && value != (remoteValue = CloudConfig.this.preferences.get(this.name))) {
                value = remoteValue;
                this.setValue(value);
            }
            this.localValue = value;
        }
    }

    abstract class TrackedField {
        protected final String name;
        private final Field handle;
        private boolean dirty;
        protected boolean initialUpdate = true;

        TrackedField(Field handle) {
            this.handle = handle;
            this.name = this.getName(handle);
        }

        private String getName(Field handle) {
            String name = handle.getName().replace("$", ".").toLowerCase();
            String prefix = CloudConfig.this.getPrefix();
            if (prefix == null) {
                return name;
            }
            String key = prefix + name;
            if (!keyPattern.matcher(key).matches()) {
                throw new InvalidKeyException("[" + key + "] is not a valid key PREFIX=" + prefix + " NAME=" + name);
            }
            return key;
        }

        protected <T> T getValue() throws IllegalAccessException {
            return (T)this.handle.get(CloudConfig.this);
        }

        protected <T> void setValue(T value) throws IllegalAccessException {
            this.handle.set(CloudConfig.this, value);
            this.dirty = true;
        }

        public final String toString() {
            return this.name;
        }

        final boolean isDirty() {
            boolean dirty = this.dirty;
            this.dirty = false;
            return dirty;
        }

        abstract void sync() throws IllegalAccessException;
    }
}

