/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.transformers.ByteCodeUtilities;

public class MethodInfo {
    public static final String INFLECT = "";
    final String owner;
    final String ownerRef;
    final String ownerObf;
    final String name;
    final String nameSrg;
    final String nameObf;
    final String desc;
    final String descObf;
    final String sig;
    final String sigSrg;
    final String sigObf;

    public MethodInfo(String owner) {
        this(owner, owner, INFLECT, INFLECT, INFLECT, null, null);
    }

    public MethodInfo(Obf owner) {
        this(owner.name, owner.obf, INFLECT, INFLECT, INFLECT, null, null);
    }

    public MethodInfo(String owner, String method) {
        this(owner, owner, method, method, method, null, null);
    }

    public MethodInfo(Obf owner, String method) {
        this(owner.name, owner.obf, method, method, method, null, null);
    }

    public MethodInfo(Obf owner, Obf method) {
        this(owner.name, owner.obf, method.name, method.srg, method.obf, null, null);
    }

    public MethodInfo(Obf owner, String method, String descriptor) {
        this(owner.name, owner.obf, method, method, method, descriptor, descriptor);
    }

    public MethodInfo(String owner, String method, String descriptor) {
        this(owner, owner, method, method, method, descriptor, descriptor);
    }

    public MethodInfo(Obf owner, Obf method, String descriptor) {
        this(owner.name, owner.obf, method.name, method.srg, method.obf, descriptor, descriptor);
    }

    public MethodInfo(Obf owner, String method, Object returnType, Object ... args) {
        this(owner.name, owner.obf, method, method, method, ByteCodeUtilities.generateDescriptor(0, returnType, args), ByteCodeUtilities.generateDescriptor(2, returnType, args));
    }

    public MethodInfo(Obf owner, Obf method, Object returnType, Object ... args) {
        this(owner.name, owner.obf, method.name, method.srg, method.obf, ByteCodeUtilities.generateDescriptor(0, returnType, args), ByteCodeUtilities.generateDescriptor(2, returnType, args));
    }

    MethodInfo(String owner, String ownerObf, String name, String nameSrg, String nameObf, String desc, String descObf) {
        this.owner = owner.replace('/', '.');
        this.ownerRef = owner.replace('.', '/');
        this.ownerObf = ownerObf;
        this.name = name;
        this.nameSrg = nameSrg;
        this.nameObf = nameObf;
        this.desc = desc;
        this.descObf = descObf;
        this.sig = MethodInfo.generateSignature(this.name, this.desc);
        this.sigSrg = MethodInfo.generateSignature(this.nameSrg, this.desc);
        this.sigObf = MethodInfo.generateSignature(this.nameObf, this.descObf);
    }

    public String getOwner() {
        return this.owner;
    }

    public String getOwnerObf() {
        return this.ownerObf;
    }

    public String[] getOwners() {
        return new String[]{this.ownerObf, this.owner, this.owner};
    }

    public String getName() {
        return this.name;
    }

    public String getOrInflectName(String context) {
        return this.name == INFLECT ? context : this.name;
    }

    public String getNameSrg() {
        return this.nameSrg;
    }

    public String getNameObf() {
        return this.nameObf;
    }

    public String[] getNames() {
        return new String[]{this.nameObf, this.nameSrg, this.name};
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDescObf() {
        return this.descObf;
    }

    public String[] getDescriptors() {
        String[] stringArray;
        if (this.desc == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[3];
            stringArray2[0] = this.descObf;
            stringArray2[1] = this.desc;
            stringArray = stringArray2;
            stringArray2[2] = this.desc;
        }
        return stringArray;
    }

    public boolean hasDesc() {
        return this.desc != null;
    }

    public String getSignature(int type) {
        if (type == 2) {
            return this.sigObf;
        }
        if (type == 1) {
            return this.sigSrg;
        }
        return this.sig;
    }

    public boolean matches(String method, String desc) {
        return this.matches(method, desc, null);
    }

    public boolean matches(String method, String desc, String className) {
        if ((className == null || this.ownerRef.equals(className)) && (this.name.equals(method) || this.nameSrg.equals(method))) {
            return this.desc == null || this.desc.equals(desc);
        }
        if ((className == null || this.ownerObf.equals(className)) && this.nameObf.equals(method)) {
            return this.descObf == null || this.descObf.equals(desc);
        }
        return false;
    }

    static String generateSignature(String methodName, String methodSignature) {
        return String.format("%s%s", methodName, methodSignature == null ? INFLECT : methodSignature);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MethodInfo) {
            return this.sig.equals(((MethodInfo)other).sig);
        }
        if (other instanceof String) {
            return this.sig.equals(other);
        }
        return false;
    }

    public String toString() {
        return this.sig;
    }

    public int hashCode() {
        return this.sig.hashCode();
    }
}

