/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event.inject;

import com.mumfrey.liteloader.transformers.event.Event;
import com.mumfrey.liteloader.transformers.event.InjectionPoint;
import java.util.Collection;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;

public class BeforeReturn
extends InjectionPoint {
    private final int ordinal;

    public BeforeReturn() {
        this(-1);
    }

    public BeforeReturn(int ordinal) {
        this.ordinal = Math.max(-1, ordinal);
    }

    @Override
    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes, Event event) {
        boolean found = false;
        int returnOpcode = Type.getReturnType((String)desc).getOpcode(172);
        int ordinal = 0;
        for (AbstractInsnNode insn : insns) {
            if (!(insn instanceof InsnNode) || insn.getOpcode() != returnOpcode) continue;
            if (this.ordinal == -1 || this.ordinal == ordinal) {
                nodes.add(insn);
                found = true;
            }
            ++ordinal;
        }
        return found;
    }
}

