/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones;

import javax.annotation.Nullable;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;

public class PlayerWaystoneHelper {
    public static final String WAYSTONES = "Waystones";
    public static final String WAYSTONE_LIST = "WaystoneList";
    public static final String LAST_FREE_WARP = "LastFreeWarp";
    public static final String LAST_WARP_STONE_USE = "LastWarpStoneUse";

    public static NBTTagCompound getWaystonesTag(EntityPlayer player) {
        return player.getEntityData().func_74775_l("PlayerPersisted").func_74775_l(WAYSTONES);
    }

    public static NBTTagCompound getOrCreateWaystonesTag(EntityPlayer player) {
        NBTTagCompound persistedTag = player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound waystonesTag = persistedTag.func_74775_l(WAYSTONES);
        persistedTag.func_74782_a(WAYSTONES, (NBTBase)waystonesTag);
        player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistedTag);
        return waystonesTag;
    }

    public static void store(EntityPlayer player, WaystoneEntry[] entries, long lastFreeWarp, long lastWarpStoneUse) {
        NBTTagCompound tagCompound = PlayerWaystoneHelper.getOrCreateWaystonesTag(player);
        NBTTagList tagList = new NBTTagList();
        for (WaystoneEntry entry : entries) {
            tagList.func_74742_a((NBTBase)entry.writeToNBT());
        }
        tagCompound.func_74782_a(WAYSTONE_LIST, (NBTBase)tagList);
        tagCompound.func_74772_a(LAST_FREE_WARP, lastFreeWarp);
        tagCompound.func_74772_a(LAST_WARP_STONE_USE, lastWarpStoneUse);
    }

    public static boolean canFreeWarp(EntityPlayer player) {
        return System.currentTimeMillis() - PlayerWaystoneHelper.getLastFreeWarp(player) > (long)(WaystoneConfig.general.teleportButtonCooldown * 1000);
    }

    public static boolean canUseWarpStone(EntityPlayer player) {
        return System.currentTimeMillis() - PlayerWaystoneHelper.getLastWarpStoneUse(player) > (long)(WaystoneConfig.general.warpStoneCooldown * 1000);
    }

    public static void setLastFreeWarp(EntityPlayer player, long lastFreeWarp) {
        PlayerWaystoneHelper.getOrCreateWaystonesTag(player).func_74772_a(LAST_FREE_WARP, lastFreeWarp);
    }

    public static long getLastFreeWarp(EntityPlayer player) {
        return PlayerWaystoneHelper.getWaystonesTag(player).func_74763_f(LAST_FREE_WARP);
    }

    public static void setLastWarpStoneUse(EntityPlayer player, long lastWarpStone) {
        PlayerWaystoneHelper.getOrCreateWaystonesTag(player).func_74772_a(LAST_WARP_STONE_USE, lastWarpStone);
    }

    public static long getLastWarpStoneUse(EntityPlayer player) {
        return PlayerWaystoneHelper.getWaystonesTag(player).func_74763_f(LAST_WARP_STONE_USE);
    }

    @Nullable
    public static WaystoneEntry getLastWaystone(EntityPlayer player) {
        NBTTagCompound tagCompound = PlayerWaystoneHelper.getWaystonesTag(player);
        NBTTagList tagList = tagCompound.func_150295_c(WAYSTONE_LIST, 10);
        if (tagList.func_74745_c() > 0) {
            return WaystoneEntry.read(tagList.func_150305_b(tagList.func_74745_c() - 1));
        }
        return null;
    }

    public static int getTravelCostByDistance(EntityPlayer player, WaystoneEntry waystone) {
        if (player.field_70170_p.field_73011_w.getDimension() != waystone.getDimensionId()) {
            return WaystoneConfig.general.dimensionalXpCost;
        }
        if (WaystoneConfig.general.blocksPerXPLevel <= 0) {
            return 0;
        }
        int dist = (int)Math.sqrt(player.func_174831_c(waystone.getPos()));
        int zeroBasedCost = MathHelper.func_76125_a((int)(dist / WaystoneConfig.general.blocksPerXPLevel), (int)0, (int)WaystoneConfig.general.maximumXpCost);
        if (!WaystoneConfig.general.shortTravelFree) {
            return zeroBasedCost + 1;
        }
        return zeroBasedCost;
    }
}

