/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.contents;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.parts.GuideChapterWithin;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.GuideText;
import buildcraft.lib.client.guide.parts.contents.IContentsNode;
import buildcraft.lib.client.guide.parts.contents.PageLink;
import buildcraft.lib.misc.StringUtilBC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public class ContentsNode
implements IContentsNode {
    public final String title;
    public final int indent;
    private final Map<String, IContentsNode> nodes = new HashMap<String, IContentsNode>();
    private IContentsNode[] sortedNodes = new IContentsNode[0];
    IContentsNode[] visibleNodes = new IContentsNode[0];
    private boolean needsSorting = false;

    public ContentsNode(String title, int indent) {
        this.title = title;
        this.indent = indent;
    }

    @Override
    public String getSearchName() {
        return this.title;
    }

    @Override
    public GuidePart createGuidePart(GuiGuide gui) {
        if (this.indent == 0) {
            return new GuideChapterWithin(gui, TextFormatting.UNDERLINE + this.title);
        }
        return new GuideText(gui, new PageLine(this.indent + 1, TextFormatting.UNDERLINE + this.title, false));
    }

    @Nullable
    public IContentsNode getChild(String childKey) {
        return this.nodes.get(childKey);
    }

    @Override
    public void addChild(IContentsNode node) {
        this.nodes.put(node.getSearchName(), node);
        this.needsSorting = true;
    }

    @Override
    public IContentsNode[] getVisibleChildren() {
        return this.visibleNodes;
    }

    @Override
    public boolean isVisible() {
        return this.visibleNodes.length != 0;
    }

    @Override
    public void sort() {
        if (!this.needsSorting) {
            return;
        }
        this.needsSorting = false;
        this.sortedNodes = this.nodes.values().toArray(new IContentsNode[0]);
        Arrays.sort(this.sortedNodes, StringUtilBC.compareBasicReadable(IContentsNode::getSearchName));
        for (IContentsNode node : this.sortedNodes) {
            node.sort();
        }
        this.calcVisibility();
    }

    @Override
    public void calcVisibility() {
        ArrayList<IContentsNode> visible = new ArrayList<IContentsNode>();
        for (IContentsNode node : this.sortedNodes) {
            if (!node.isVisible()) continue;
            visible.add(node);
        }
        this.visibleNodes = visible.toArray(new IContentsNode[0]);
    }

    @Override
    public void resetVisibility() {
        for (IContentsNode node : this.sortedNodes) {
            node.resetVisibility();
        }
        this.calcVisibility();
    }

    @Override
    public void setVisible(Set<PageLink> matches) {
        for (IContentsNode node : this.sortedNodes) {
            node.setVisible(matches);
        }
        this.calcVisibility();
    }
}

