/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IConstantNode;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.value.NodeVariableObject;
import java.util.EnumMap;
import java.util.Map;

public class NodeFuncMap<K extends Enum<K>, V>
implements INodeFunc.INodeFuncObject<V> {
    private final Class<K> keyClass;
    private final Class<V> valueClass;
    private final Map<K, NodeVariableObject<V>> variableMap;
    private final NodeVariableObject<V> nullEntry;

    public NodeFuncMap(Class<K> keyClass, Class<V> valueClass) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.variableMap = new EnumMap<K, NodeVariableObject<V>>(keyClass);
        for (Enum enumKey : (Enum[])keyClass.getEnumConstants()) {
            this.variableMap.put(enumKey, new NodeVariableObject<V>("entry_" + enumKey.name(), valueClass));
        }
        this.nullEntry = new NodeVariableObject<V>("null_entry", valueClass);
    }

    public void putAll(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put((Enum)entry.getKey(), entry.getValue());
        }
    }

    public void putAll(V value) {
        this.nullEntry.set(value);
        for (Enum key : (Enum[])this.keyClass.getEnumConstants()) {
            this.put(key, value);
        }
    }

    public void put(K key, V value) {
        if (key == null) {
            this.nullEntry.set(value);
        } else {
            IVariableNode.IVariableNodeObject node = this.variableMap.get(key);
            if (node == null) {
                throw new IllegalArgumentException("Unknown enum key " + key + " for " + key.getClass());
            }
            node.set(value);
        }
    }

    public NodeVariableObject<V> get(K key) {
        if (key == null) {
            return this.nullEntry;
        }
        NodeVariableObject<V> node = this.variableMap.get(key);
        if (node == null) {
            throw new IllegalArgumentException("Unknown enum key " + key + " for " + key.getClass());
        }
        return node;
    }

    @Override
    public IExpressionNode.INodeObject<V> getNode(INodeStack stack) throws InvalidExpressionException {
        return new Node(stack.popObject(this.keyClass));
    }

    @Override
    public Class<V> getType() {
        return this.valueClass;
    }

    private class Node
    implements IExpressionNode.INodeObject<V>,
    IDependantNode {
        private final IExpressionNode.INodeObject<K> input;

        public Node(IExpressionNode.INodeObject<K> input) {
            this.input = input;
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            visitor.dependOn((IExpressionNode)NodeFuncMap.this.nullEntry);
            visitor.dependOnNodes(NodeFuncMap.this.variableMap.values());
        }

        @Override
        public V evaluate() {
            return NodeFuncMap.this.get((Enum)this.input.evaluate()).evaluate();
        }

        @Override
        public Class<V> getType() {
            return NodeFuncMap.this.valueClass;
        }

        @Override
        public IExpressionNode.INodeObject<V> inline() {
            return NodeInliningHelper.tryInline(this, this.input, x$0 -> new Node(x$0), i -> {
                assert (i instanceof IConstantNode);
                Enum key = (Enum)i.evaluate();
                return NodeFuncMap.this.get(key).inline();
            });
        }
    }
}

