/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mods.octarinecore.client.render.Vertex;
import mods.octarinecore.common.Double3;
import mods.octarinecore.common.Rotation;
import mods.octarinecore.common.Rotation$WhenMappings;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u001e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u0019\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0086\bJ\u0011\u00107\u001a\u0002032\u0006\u00108\u001a\u00020\nH\u0086\bJ\u000e\u00109\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J\u0011\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\nH\u0086\bJ\u0011\u0010<\u001a\u0002032\u0006\u00108\u001a\u00020\nH\u0086\bJ\u0011\u0010=\u001a\u0002032\u0006\u0010>\u001a\u00020\u0004H\u0086\bJ\u0011\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020AH\u0086\bJ\u000e\u0010B\u001a\u00020\u00002\u0006\u00100\u001a\u000201R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0006\"\u0004\b\u0018\u0010\bR\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001a\u0010%\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001eR\u001a\u0010(\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001c\"\u0004\b*\u0010\u001e\u00a8\u0006C"}, d2={"Lmods/octarinecore/client/render/RenderVertex;", "", "()V", "blue", "", "getBlue", "()F", "setBlue", "(F)V", "brightness", "", "getBrightness", "()I", "setBrightness", "(I)V", "green", "getGreen", "setGreen", "rawData", "", "getRawData", "()[I", "red", "getRed", "setRed", "u", "", "getU", "()D", "setU", "(D)V", "v", "getV", "setV", "x", "getX", "setX", "y", "getY", "setY", "z", "getZ", "setZ", "init", "vertex", "Lmods/octarinecore/client/render/Vertex;", "rot", "Lmods/octarinecore/common/Rotation;", "trans", "Lmods/octarinecore/common/Double3;", "mirrorUV", "", "mirrorU", "", "mirrorV", "multiplyColor", "color", "rotate", "rotateUV", "n", "setColor", "setGrey", "level", "setIcon", "icon", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "translate", "BetterFoliage-MC1.12"})
public final class RenderVertex {
    private double x;
    private double y;
    private double z;
    private double u;
    private double v;
    private int brightness;
    private float red;
    private float green;
    private float blue;
    @NotNull
    private final int[] rawData = new int[7];

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public final double getU() {
        return this.u;
    }

    public final void setU(double d) {
        this.u = d;
    }

    public final double getV() {
        return this.v;
    }

    public final void setV(double d) {
        this.v = d;
    }

    public final int getBrightness() {
        return this.brightness;
    }

    public final void setBrightness(int n) {
        this.brightness = n;
    }

    public final float getRed() {
        return this.red;
    }

    public final void setRed(float f) {
        this.red = f;
    }

    public final float getGreen() {
        return this.green;
    }

    public final void setGreen(float f) {
        this.green = f;
    }

    public final float getBlue() {
        return this.blue;
    }

    public final void setBlue(float f) {
        this.blue = f;
    }

    @NotNull
    public final int[] getRawData() {
        return this.rawData;
    }

    @NotNull
    public final RenderVertex init(@NotNull Vertex vertex, @NotNull Rotation rot, @NotNull Double3 trans) {
        Intrinsics.checkParameterIsNotNull((Object)vertex, (String)"vertex");
        Intrinsics.checkParameterIsNotNull((Object)rot, (String)"rot");
        Intrinsics.checkParameterIsNotNull((Object)trans, (String)"trans");
        Double3 result = vertex.getXyz().rotate(rot).plus(trans);
        this.x = result.getX();
        this.y = result.getY();
        this.z = result.getZ();
        return this;
    }

    @NotNull
    public final RenderVertex init(@NotNull Vertex vertex) {
        Intrinsics.checkParameterIsNotNull((Object)vertex, (String)"vertex");
        this.x = vertex.getXyz().getX();
        this.y = vertex.getXyz().getY();
        this.z = vertex.getXyz().getZ();
        this.u = vertex.getUv().getU();
        this.v = vertex.getUv().getV();
        return this;
    }

    @NotNull
    public final RenderVertex translate(@NotNull Double3 trans) {
        Intrinsics.checkParameterIsNotNull((Object)trans, (String)"trans");
        this.x += trans.getX();
        this.y += trans.getY();
        this.z += trans.getZ();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RenderVertex rotate(@NotNull Rotation rot) {
        double d;
        void dir$iv;
        void this_$iv;
        double y$iv;
        double d2;
        void dir$iv2;
        void this_$iv2;
        double y$iv2;
        double d3;
        void dir$iv3;
        void this_$iv3;
        Intrinsics.checkParameterIsNotNull((Object)rot, (String)"rot");
        if (rot == Rotation.Companion.getIdentity()) {
            return this;
        }
        Rotation rotation = rot;
        EnumFacing enumFacing = EnumFacing.EAST;
        double d4 = this.x;
        double d5 = this.y;
        double z$iv = this.z;
        boolean $i$f$rotatedComponent = false;
        switch (Rotation$WhenMappings.$EnumSwitchMapping$1[this_$iv3.getReverse()[dir$iv3.ordinal()].ordinal()]) {
            case 1: {
                void x$iv;
                d3 = x$iv;
                break;
            }
            case 2: {
                void x$iv;
                d3 = -x$iv;
                break;
            }
            case 3: {
                d3 = y$iv2;
                break;
            }
            case 4: {
                d3 = -y$iv2;
                break;
            }
            case 5: {
                d3 = z$iv;
                break;
            }
            case 6: {
                d3 = -z$iv;
                break;
            }
            default: {
                d3 = 0.0;
            }
        }
        double rotX = d3;
        Rotation x$iv = rot;
        EnumFacing enumFacing2 = EnumFacing.UP;
        y$iv2 = this.x;
        z$iv = this.y;
        double z$iv2 = this.z;
        boolean $i$f$rotatedComponent2 = false;
        switch (Rotation$WhenMappings.$EnumSwitchMapping$1[this_$iv2.getReverse()[dir$iv2.ordinal()].ordinal()]) {
            case 1: {
                void x$iv2;
                d2 = x$iv2;
                break;
            }
            case 2: {
                void x$iv2;
                d2 = -x$iv2;
                break;
            }
            case 3: {
                d2 = y$iv;
                break;
            }
            case 4: {
                d2 = -y$iv;
                break;
            }
            case 5: {
                d2 = z$iv2;
                break;
            }
            case 6: {
                d2 = -z$iv2;
                break;
            }
            default: {
                d2 = 0.0;
            }
        }
        double rotY = d2;
        Rotation x$iv2 = rot;
        EnumFacing enumFacing3 = EnumFacing.SOUTH;
        y$iv = this.x;
        z$iv2 = this.y;
        double z$iv3 = this.z;
        boolean $i$f$rotatedComponent3 = false;
        switch (Rotation$WhenMappings.$EnumSwitchMapping$1[this_$iv.getReverse()[dir$iv.ordinal()].ordinal()]) {
            case 1: {
                void x$iv3;
                d = x$iv3;
                break;
            }
            case 2: {
                void x$iv3;
                d = -x$iv3;
                break;
            }
            case 3: {
                void y$iv3;
                d = y$iv3;
                break;
            }
            case 4: {
                void y$iv3;
                d = -y$iv3;
                break;
            }
            case 5: {
                d = z$iv3;
                break;
            }
            case 6: {
                d = -z$iv3;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        double rotZ = d;
        this.x = rotX;
        this.y = rotY;
        this.z = rotZ;
        return this;
    }

    @NotNull
    public final RenderVertex rotateUV(int n) {
        int $i$f$rotateUV = 0;
        switch (n % 4) {
            case 1: {
                double t = this.getV();
                this.setV(-this.getU());
                this.setU(t);
                return this;
            }
            case 2: {
                this.setU(-this.getU());
                this.setV(-this.getV());
                return this;
            }
            case 3: {
                double t = -this.getV();
                this.setV(this.getU());
                this.setU(t);
                return this;
            }
        }
        return this;
    }

    public final void mirrorUV(boolean mirrorU, boolean mirrorV) {
        int $i$f$mirrorUV = 0;
        if (mirrorU) {
            this.setU(-this.getU());
        }
        if (mirrorV) {
            this.setV(-this.getV());
        }
    }

    @NotNull
    public final RenderVertex setIcon(@NotNull TextureAtlasSprite icon) {
        int $i$f$setIcon = 0;
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        this.setU((double)(icon.func_94212_f() - icon.func_94209_e()) * (this.getU() + 0.5) + (double)icon.func_94209_e());
        this.setV((double)(icon.func_94210_h() - icon.func_94206_g()) * (this.getV() + 0.5) + (double)icon.func_94206_g());
        return this;
    }

    public final void setGrey(float level) {
        int $i$f$setGrey = 0;
        float grey = Math.min((this.getRed() + this.getGreen() + this.getBlue()) * 0.333f * level, 1.0f);
        this.setRed(grey);
        this.setGreen(grey);
        this.setBlue(grey);
    }

    public final void multiplyColor(int color) {
        int $i$f$multiplyColor = 0;
        RenderVertex renderVertex = this;
        renderVertex.setRed(renderVertex.getRed() * ((float)(color >> 16 & 0xFF) / 256.0f));
        RenderVertex renderVertex2 = this;
        renderVertex2.setGreen(renderVertex2.getGreen() * ((float)(color >> 8 & 0xFF) / 256.0f));
        RenderVertex renderVertex3 = this;
        renderVertex3.setBlue(renderVertex3.getBlue() * ((float)(color & 0xFF) / 256.0f));
    }

    public final void setColor(int color) {
        int $i$f$setColor = 0;
        this.setRed((float)(color >> 16 & 0xFF) / 256.0f);
        this.setGreen((float)(color >> 8 & 0xFF) / 256.0f);
        this.setBlue((float)(color & 0xFF) / 256.0f);
    }
}

