/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.api.material;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.api.material.AllowedProducts;
import zmaster587.libVulpes.api.material.Material;
import zmaster587.libVulpes.api.material.MixedMaterial;
import zmaster587.libVulpes.block.BlockOre;
import zmaster587.libVulpes.items.ItemOre;
import zmaster587.libVulpes.items.ItemOreProduct;
import zmaster587.libVulpes.util.ItemStackMapping;
import zmaster587.libVulpes.util.OreProductColorizer;

public class MaterialRegistry {
    static HashMap<Object, MixedMaterial> mixedMaterialList = new HashMap();
    static HashMap<AllowedProducts, List<Block>> productBlockListMapping;
    static List<MaterialRegistry> registries;
    @SideOnly(value=Side.CLIENT)
    static Object oreProductColorizer;
    public HashMap<String, Material> strToMaterial = new HashMap();
    public List<Material> materialList = new LinkedList<Material>();
    public Item[] oreProducts;

    public MaterialRegistry() {
        productBlockListMapping = new HashMap();
        registries.add(this);
    }

    public void registerMaterial(Material material) {
        this.strToMaterial.put(material.getUnlocalizedName(), material);
        material.setIndex(this.materialList.size());
        material.registry = this;
        this.materialList.add(material);
    }

    @SideOnly(value=Side.CLIENT)
    public void init() {
        if (oreProductColorizer == null) {
            oreProductColorizer = new OreProductColorizer();
        }
        for (Block block : this.getBlockListForProduct(AllowedProducts.getProductByName("BLOCK"))) {
            if (block == null || Item.func_150898_a((Block)block) == null) continue;
            Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)oreProductColorizer, new Block[]{block});
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)oreProductColorizer, new Item[]{Item.func_150898_a((Block)block)});
        }
        for (Block block : this.getBlockListForProduct(AllowedProducts.getProductByName("COIL"))) {
            if (block == null || Item.func_150898_a((Block)block) == null) continue;
            Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)oreProductColorizer, new Block[]{block});
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)oreProductColorizer, new Item[]{Item.func_150898_a((Block)block)});
        }
        for (int i = 0; i < AllowedProducts.getAllAllowedProducts().size(); ++i) {
            if (AllowedProducts.getAllAllowedProducts().get(i).isBlock()) continue;
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)((OreProductColorizer)oreProductColorizer), new Item[]{this.oreProducts[i]});
        }
    }

    public void registerOres(CreativeTabs tab) {
        int len = this.materialList.size();
        int numberOfOreBlocks = len / 16 + 1;
        List<AllowedProducts> allAllowedProducts = AllowedProducts.getAllAllowedProducts();
        this.oreProducts = new ItemOreProduct[allAllowedProducts.size()];
        for (int i = 0; i < allAllowedProducts.size(); ++i) {
            if (allAllowedProducts.get(i).isBlock()) continue;
            this.oreProducts[i] = new ItemOreProduct(allAllowedProducts.get(i).name().toLowerCase(Locale.ENGLISH)).func_77637_a(tab);
            LibVulpesBlocks.registerItem((Item)this.oreProducts[i].setRegistryName("product" + allAllowedProducts.get(i).getName().toLowerCase(Locale.ENGLISH)));
        }
        boolean oreAllowed = false;
        boolean blockAllowed = false;
        boolean coilAllowed = false;
        for (Material mat : this.materialList) {
            if (!oreAllowed) {
                oreAllowed = AllowedProducts.getProductByName("ORE").isOfType(mat.getAllowedProducts());
            }
            if (!blockAllowed) {
                blockAllowed = AllowedProducts.getProductByName("BLOCK").isOfType(mat.getAllowedProducts());
            }
            if (coilAllowed) continue;
            coilAllowed = AllowedProducts.getProductByName("COIL").isOfType(mat.getAllowedProducts());
        }
        for (int i = 0; i < numberOfOreBlocks; ++i) {
            String name = "ore";
            String metalBlockName = "metal";
            String coilName = "coil";
            BlockOre metalBlocks = new BlockOre(net.minecraft.block.material.Material.field_151576_e);
            metalBlocks.func_149663_c(metalBlockName).func_149647_a(tab).func_149711_c(4.0f);
            metalBlocks.numBlocks = (byte)Math.min(len - 16 * i, 16);
            metalBlocks.product = AllowedProducts.getProductByName("BLOCK");
            BlockOre ores = new BlockOre(net.minecraft.block.material.Material.field_151576_e);
            ores.func_149663_c(name).func_149647_a(tab).func_149711_c(4.0f);
            ores.numBlocks = (byte)Math.min(len - 16 * i, 16);
            ores.product = AllowedProducts.getProductByName("ORE");
            BlockOre coilBlocks = new BlockOre(net.minecraft.block.material.Material.field_151576_e);
            coilBlocks.func_149663_c(coilName).func_149647_a(tab).func_149711_c(4.0f);
            coilBlocks.numBlocks = (byte)Math.min(len - 16 * i, 16);
            coilBlocks.product = AllowedProducts.getProductByName("COIL");
            ores.setRegistryName(name + i);
            metalBlocks.setRegistryName(metalBlockName + i);
            coilBlocks.setRegistryName(coilName + i);
            if (oreAllowed) {
                LibVulpesBlocks.registerBlock(ores, ItemOre.class, false);
            }
            if (blockAllowed) {
                LibVulpesBlocks.registerBlock(metalBlocks, ItemOre.class, false);
            }
            if (coilAllowed) {
                LibVulpesBlocks.registerBlock(coilBlocks, ItemOre.class, false);
            }
            for (int j = 0; j < 16 && j < 16 * i + len % 16; ++j) {
                Material ore;
                int index = i * 16 + j;
                ores.ores[j] = ore = this.materialList.get(index);
                ores.setHarvestLevel(ore.getTool(), ore.getHarvestLevel(), ores.func_176203_a(j));
                metalBlocks.ores[j] = ore;
                metalBlocks.setHarvestLevel(ore.getTool(), ore.getHarvestLevel(), ores.func_176203_a(j));
                coilBlocks.ores[j] = ore;
                coilBlocks.setHarvestLevel(ore.getTool(), ore.getHarvestLevel(), ores.func_176203_a(j));
                for (AllowedProducts product : allAllowedProducts) {
                    if (product.isBlock() || !product.isOfType(ore.getAllowedProducts())) continue;
                    ((ItemOreProduct)this.oreProducts[product.ordinal()]).registerItem(index, ore);
                }
                for (int g = 0; g < ore.getOreDictNames().length; ++g) {
                    Item itemBlock;
                    String oreName;
                    String str = ore.getOreDictNames()[g];
                    if (AllowedProducts.getProductByName("ORE").isOfType(ore.getAllowedProducts())) {
                        oreName = "ore" + str;
                        OreDictionary.registerOre((String)oreName, (ItemStack)new ItemStack((Block)ores, 1, j));
                        if (FMLCommonHandler.instance().getSide().isClient() && g == 0) {
                            oreName = Loader.instance().activeModContainer().getModId() + ":" + oreName;
                            itemBlock = Item.func_150898_a((Block)ores);
                            ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)j, (ModelResourceLocation)new ModelResourceLocation(oreName, "inventory"));
                        }
                    }
                    if (AllowedProducts.getProductByName("BLOCK").isOfType(ore.getAllowedProducts())) {
                        oreName = "block" + str;
                        OreDictionary.registerOre((String)oreName, (ItemStack)new ItemStack((Block)metalBlocks, 1, j));
                        if (FMLCommonHandler.instance().getSide().isClient() && g == 0) {
                            oreName = Loader.instance().activeModContainer().getModId() + ":" + oreName;
                            itemBlock = Item.func_150898_a((Block)metalBlocks);
                            ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)j, (ModelResourceLocation)new ModelResourceLocation(oreName, "inventory"));
                        }
                    }
                    if (!AllowedProducts.getProductByName("COIL").isOfType(ore.getAllowedProducts())) continue;
                    oreName = "coil" + str;
                    OreDictionary.registerOre((String)oreName, (ItemStack)new ItemStack((Block)coilBlocks, 1, j));
                    OreDictionary.registerOre((String)"blockCoil", (ItemStack)new ItemStack((Block)coilBlocks, 1, j));
                    if (!FMLCommonHandler.instance().getSide().isClient() || g != 0) continue;
                    oreName = Loader.instance().activeModContainer().getModId() + ":" + oreName;
                    itemBlock = Item.func_150898_a((Block)coilBlocks);
                    ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)j, (ModelResourceLocation)new ModelResourceLocation(oreName, "inventory"));
                }
            }
            this.getBlockListForProduct(AllowedProducts.getProductByName("BLOCK")).add(metalBlocks);
            this.getBlockListForProduct(AllowedProducts.getProductByName("COIL")).add(coilBlocks);
            this.getBlockListForProduct(AllowedProducts.getProductByName("ORE")).add(ores);
        }
    }

    public List<Block> getBlockListForProduct(AllowedProducts product) {
        return productBlockListMapping.get(product);
    }

    public Block getBlockForProduct(AllowedProducts product, Material material, int index) {
        for (Block block : productBlockListMapping.get(product)) {
            if (((BlockOre)block).ores[index] != material) continue;
            return block;
        }
        return null;
    }

    public static Material getMaterialFromItemStack(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        for (MaterialRegistry registry : registries) {
            for (Item i : registry.oreProducts) {
                if (item != i) continue;
                return registry.materialList.get(stack.func_77952_i());
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            for (Material ore : registry.materialList) {
                for (String str : ore.getOreDictNames()) {
                    for (int i : ids) {
                        if (!OreDictionary.getOreName((int)i).contains(str)) continue;
                        return ore;
                    }
                }
            }
        }
        return null;
    }

    @Nonnull
    public static ItemStack getItemStackFromMaterialAndType(String material, AllowedProducts product) {
        return MaterialRegistry.getItemStackFromMaterialAndType(material, product, 1);
    }

    @Nonnull
    public static ItemStack getItemStackFromMaterialAndType(String ore, AllowedProducts product, int amount) {
        for (MaterialRegistry registry : registries) {
            Material ore2 = registry.strToMaterial.get(ore);
            if (ore2 == null || product == null) continue;
            return new ItemStack(registry.oreProducts[product.ordinal()], amount, ore2.index);
        }
        return ItemStack.field_190927_a;
    }

    public static void registerMixedMaterial(MixedMaterial material) {
        Object inputObj = material.getInput();
        if (inputObj instanceof ItemStack && !((ItemStack)inputObj).func_190926_b()) {
            mixedMaterialList.put(new ItemStackMapping((ItemStack)inputObj), material);
        } else {
            mixedMaterialList.put(inputObj, material);
        }
    }

    public MixedMaterial getMixedMaterial(@Nonnull ItemStack stack) {
        return mixedMaterialList.get(new ItemStackMapping(stack));
    }

    public MixedMaterial getMixedMaterial(String str) {
        return mixedMaterialList.get(str);
    }

    public static int getColorFromItemMaterial(@Nonnull ItemStack stack) {
        Material material = MaterialRegistry.getMaterialFromItemStack(stack);
        if (material == null) {
            return 0x7A7A7A;
        }
        return material.getColor();
    }

    public static Collection<MixedMaterial> getMixedMaterialList() {
        return mixedMaterialList.values();
    }

    public static Material getMaterialFromName(String string) {
        for (MaterialRegistry registry : registries) {
            Material material = registry.strToMaterial.get(string);
            if (material == null) continue;
            return material;
        }
        return null;
    }

    public static List<Material> getAllMaterials() {
        LinkedList<Material> list = new LinkedList<Material>();
        for (MaterialRegistry registry : registries) {
            list.addAll(registry.materialList);
        }
        return list;
    }

    static {
        registries = new LinkedList<MaterialRegistry>();
    }
}

