/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.block.multiblock;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.block.multiblock.BlockMultiblockStructure;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.tile.TilePointer;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.hatch.TileFluidHatch;
import zmaster587.libVulpes.tile.multiblock.hatch.TileInputHatch;
import zmaster587.libVulpes.tile.multiblock.hatch.TileInventoryHatch;
import zmaster587.libVulpes.tile.multiblock.hatch.TileOutputHatch;
import zmaster587.libVulpes.util.FluidUtils;

public class BlockHatch
extends BlockMultiblockStructure {
    private final Random random = new Random();

    public BlockHatch(Material material) {
        super(material);
        this.field_149758_A = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
        list.add((Object)new ItemStack((Block)this, 1, 2));
        list.add((Object)new ItemStack((Block)this, 1, 3));
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int metadata = (Integer)state.func_177229_b((IProperty)VARIANT);
        if ((metadata & 7) == 0) {
            return new TileInputHatch(4);
        }
        if ((metadata & 7) == 1) {
            return new TileOutputHatch(4);
        }
        if ((metadata & 7) == 2) {
            return new TileFluidHatch(false);
        }
        if ((metadata & 7) == 3) {
            return new TileFluidHatch(true);
        }
        return null;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                float mult = 0.05f;
                entityitem.field_70159_w = (float)this.random.nextGaussian() * mult;
                entityitem.field_70181_x = (float)this.random.nextGaussian() * mult + 0.2f;
                entityitem.field_70179_y = (float)this.random.nextGaussian() * mult;
                world.func_72838_d((Entity)entityitem);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileFluidHatch) {
            return 15 * ((TileFluidHatch)tile).getFluidTank().getFluidAmount() / ((TileFluidHatch)tile).getFluidTank().getCapacity();
        }
        if (tile instanceof TileInventoryHatch) {
            TileInventoryHatch tile2 = (TileInventoryHatch)tile;
            int i = 0;
            float f = 0.0f;
            for (int j = 0; j < tile2.func_70302_i_(); ++j) {
                ItemStack itemstack = tile2.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                f += (float)itemstack.func_190916_E() / (float)Math.min(tile2.func_70297_j_(), itemstack.func_77976_d());
                ++i;
            }
            return MathHelper.func_76141_d((float)((f /= (float)tile2.func_70302_i_()) * 14.0f)) + (i > 0 ? 1 : 0);
        }
        return 0;
    }

    @Override
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing direction) {
        boolean isPointer = blockAccess.func_175625_s(pos.func_177972_a(direction.func_176734_d())) instanceof TilePointer;
        if (isPointer) {
            isPointer = !(((TilePointer)blockAccess.func_175625_s(pos.func_177972_a(direction.func_176734_d()))).getMasterBlock() instanceof TileMultiBlock);
        }
        return (Integer)blockState.func_177229_b((IProperty)VARIANT) < 8;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int meta = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)VARIANT);
        TileEntity tile = worldIn.func_175625_s(pos);
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (FluidUtils.containsFluid(playerIn.func_184586_b(hand)) && tile instanceof TileFluidHatch) {
            IItemHandler playerInventory = (IItemHandler)playerIn.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (((TileFluidHatch)tile).isOutputOnly()) {
                FluidActionResult fluidActionResult = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)((TileFluidHatch)tile).getFluidTank(), (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)playerIn, (boolean)true);
                if (fluidActionResult.isSuccess()) {
                    playerIn.func_184611_a(hand, fluidActionResult.getResult());
                }
            } else {
                FluidActionResult fluidActionResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)((TileFluidHatch)tile).getFluidTank(), (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)playerIn, (boolean)true);
                if (fluidActionResult.isSuccess()) {
                    playerIn.func_184611_a(hand, fluidActionResult.getResult());
                }
            }
        } else if ((meta & 7) < 8 && !worldIn.field_72995_K) {
            playerIn.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULAR.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }
}

