/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.util.INetworkMachine;

public class PacketMachine
extends BasePacket {
    INetworkMachine machine;
    NBTTagCompound nbt = new NBTTagCompound();
    byte packetId;

    public PacketMachine() {
    }

    public PacketMachine(INetworkMachine machine, byte packetId) {
        this();
        this.machine = machine;
        this.packetId = packetId;
    }

    @Override
    public void write(ByteBuf outline) {
        outline.writeInt(((TileEntity)this.machine).func_145831_w().field_73011_w.getDimension());
        outline.writeInt(((TileEntity)this.machine).func_174877_v().func_177958_n());
        outline.writeInt(((TileEntity)this.machine).func_174877_v().func_177956_o());
        outline.writeInt(((TileEntity)this.machine).func_174877_v().func_177952_p());
        outline.writeByte((int)this.packetId);
        this.machine.writeDataToNetwork(outline, this.packetId);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readClient(ByteBuf in) {
        in.readInt();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int x = in.readInt();
        int y = in.readInt();
        int z = in.readInt();
        this.packetId = in.readByte();
        TileEntity ent = world.func_175625_s(new BlockPos(x, y, z));
        if (ent instanceof INetworkMachine) {
            this.machine = (INetworkMachine)ent;
            this.machine.readDataFromNetwork(in, this.packetId, this.nbt);
        }
    }

    @Override
    public void read(ByteBuf in) {
        TileEntity ent;
        int temp = in.readInt();
        WorldServer world = DimensionManager.getWorld((int)temp);
        int x = in.readInt();
        int y = in.readInt();
        int z = in.readInt();
        this.packetId = in.readByte();
        BlockPos pos = new BlockPos(x, y, z);
        Chunk chunk = world.func_175726_f(pos);
        if (chunk.func_177410_o() && (ent = world.func_175625_s(pos)) instanceof INetworkMachine) {
            this.machine = (INetworkMachine)ent;
            this.machine.readDataFromNetwork(in, this.packetId, this.nbt);
        }
    }

    @Override
    public void executeClient(EntityPlayer player) {
        if (this.machine != null) {
            this.machine.useNetworkData(player, Side.CLIENT, this.packetId, this.nbt);
        }
    }

    @Override
    public void executeServer(EntityPlayerMP player) {
        if (this.machine != null) {
            this.machine.useNetworkData((EntityPlayer)player, Side.SERVER, this.packetId, this.nbt);
        }
    }

    public void execute(EntityPlayer player, Side side) {
        if (this.machine != null) {
            this.machine.useNetworkData(player, side, this.packetId, this.nbt);
        }
    }
}

