/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.cap.ForgePowerCapability;
import zmaster587.libVulpes.cap.TeslaHandler;
import zmaster587.libVulpes.energy.IPower;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.util.UniversalBattery;

public abstract class TileEntityForgeProducer
extends TileEntity
implements IModularInventory,
IEnergyStorage,
IPower,
IUniversalEnergy,
ITickable {
    protected UniversalBattery energy;

    protected TileEntityForgeProducer(int energy) {
        this.energy = new UniversalBattery(energy);
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add(new ModulePower(18, 20, this.energy));
        return modules;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || TeslaHandler.hasTeslaCapability((ICapabilityProvider)this, capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)new ForgePowerCapability(this);
        }
        if (TeslaHandler.hasTeslaCapability((ICapabilityProvider)this, capability)) {
            return (T)TeslaHandler.getHandler(this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    @Override
    public boolean canExtract() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return false;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing arg0) {
        return true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.energy.writeToNBT(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy.readFromNBT(nbt);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.acceptEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.extractEnergy(maxExtract, simulate);
    }

    public boolean hasEnoughEnergyBuffer(int amt) {
        return this.getMaxEnergyStored() - this.getUniversalEnergyStored() >= amt;
    }

    public int getPowerPerOperation() {
        return 0;
    }

    public abstract boolean canGeneratePower();

    public void func_73660_a() {
        if (this.canGeneratePower()) {
            if (this.hasEnoughEnergyBuffer(this.getPowerPerOperation())) {
                if (!this.field_145850_b.field_72995_K) {
                    this.energy.acceptEnergy(this.getPowerPerOperation(), false);
                }
                this.onGeneratePower();
            } else {
                this.notEnoughBufferForFunction();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.transmitPower();
        }
    }

    protected void transmitPower() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IEnergyStorage storage;
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) || (storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) == null || !storage.canReceive()) continue;
            this.extractEnergy(storage.receiveEnergy(this.getUniversalEnergyStored(), false), false);
        }
    }

    public abstract void onGeneratePower();

    public void notEnoughBufferForFunction() {
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getUniversalEnergyStored();
    }

    public int getEnergyStored() {
        return this.energy.getUniversalEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    public boolean hasEnergy() {
        return this.energy.getUniversalEnergyStored() > 0;
    }

    @Override
    public void setEnergyStored(int value) {
        this.energy.setEnergyStored(value);
    }

    @Override
    public int extractEnergy(int amt, boolean simulate) {
        return this.energy.extractEnergy(amt, simulate);
    }

    @Override
    public int getUniversalEnergyStored() {
        return this.energy.getUniversalEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public void setMaxEnergyStored(int max) {
        this.energy.setEnergyStored(max);
    }

    @Override
    public int acceptEnergy(int amt, boolean simulate) {
        return this.energy.acceptEnergy(amt, simulate);
    }

    @Override
    public int receiveEnergy(int amt, boolean simulate) {
        return this.energy.acceptEnergy(amt, simulate);
    }
}

