/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class HashedBlockPosition {
    public int x;
    public int z;
    public short y;

    public HashedBlockPosition(int x, int y, int z) {
        this.x = x;
        this.y = (short)y;
        this.z = z;
    }

    public HashedBlockPosition(@Nonnull BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = (short)pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    @Nonnull
    public BlockPos getBlockPos() {
        return new BlockPos(this.x, (int)this.y, this.z);
    }

    @Nonnull
    public HashedBlockPosition getPositionAtOffset(int dx, int dy, int dz) {
        return new HashedBlockPosition(dx + this.x, dy + this.y, dz + this.z);
    }

    @Nonnull
    public HashedBlockPosition getPositionAtOffset(@Nonnull EnumFacing facing) {
        return new HashedBlockPosition(facing.func_82601_c() + this.x, facing.func_96559_d() + this.y, facing.func_82599_e() + this.z);
    }

    public double getDistance(@Nonnull HashedBlockPosition otherPos) {
        return Math.sqrt(Math.pow(this.x - otherPos.x, 2.0) + Math.pow(this.y - otherPos.y, 2.0) + Math.pow(this.z - otherPos.z, 2.0));
    }

    public int hashCode() {
        return this.x * 179425423 ^ this.z * 179426549 ^ this.y * 179424691;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof HashedBlockPosition) {
            return this.x == ((HashedBlockPosition)obj).x && this.y == ((HashedBlockPosition)obj).y && this.z == ((HashedBlockPosition)obj).z;
        }
        return super.equals(obj);
    }

    @Nonnull
    public String toString() {
        return this.x + " " + this.y + " " + this.z;
    }
}

