/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.stations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.ISpaceObjectManager;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.network.PacketSpaceStationInfo;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class SpaceObjectManager
implements ISpaceObjectManager {
    private int nextId = 1;
    public static final int WARPDIMID = Integer.MIN_VALUE;
    private long nextStationTransitionTick = -1L;
    HashMap<Integer, ISpaceObject> stationLocations = new HashMap();
    HashMap<Integer, List<ISpaceObject>> spaceStationOrbitMap = new HashMap();
    HashMap<Integer, Long> temporaryDimensions;
    HashMap<Integer, Integer> temporaryDimensionPlayerNumber;
    HashMap<String, Class> nameToClass = new HashMap();
    HashMap<Class, String> classToString = new HashMap();
    private static final SpaceObjectManager spaceObjectManager = new SpaceObjectManager();

    private SpaceObjectManager() {
        this.temporaryDimensions = new HashMap();
        AdvancedRocketryAPI.spaceObjectManager = this;
    }

    public static final SpaceObjectManager getSpaceManager() {
        return spaceObjectManager;
    }

    public ISpaceObject getSpaceStation(int id) {
        return this.stationLocations.get(id);
    }

    public Collection<ISpaceObject> getSpaceObjects() {
        return this.stationLocations.values();
    }

    public int getNextStationId() {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            if (this.stationLocations.containsKey(i)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    public void registerSpaceObjectType(String str, Class<? extends Object> clazz) {
        this.nameToClass.put(str, clazz);
        this.classToString.put(clazz, str);
    }

    public ISpaceObject getNewSpaceObjectFromIdentifier(String id) {
        Class clazz = this.nameToClass.get(id);
        try {
            return (ISpaceObject)clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getItentifierFromClass(Class<? extends ISpaceObject> clazz) {
        return this.classToString.get(clazz);
    }

    @Override
    public ISpaceObject getSpaceStationFromBlockCoords(BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        x = Math.round((float)x / (2.0f * (float)ARConfiguration.getCurrentConfig().stationSize));
        z = Math.round((float)z / (2.0f * (float)ARConfiguration.getCurrentConfig().stationSize));
        int radius = Math.max(Math.abs(x), Math.abs(z));
        int index = (int)Math.pow(2 * radius - 1, 2.0) + x + radius;
        if (Math.abs(z) != radius) {
            index = (int)Math.pow(2 * radius - 1, 2.0) + z + radius + (4 * radius + 2) - 1;
            if (x > 0) {
                index += 2 * radius - 1;
            }
        } else if (z > 0) {
            index += 2 * radius + 1;
        }
        return this.getSpaceStation(index);
    }

    public void registerSpaceObject(ISpaceObject object, int dimId, int stationId) {
        int z;
        int x;
        object.setId(stationId);
        this.stationLocations.put(stationId, object);
        int radius = (int)Math.floor(Math.ceil(Math.sqrt(stationId + 1)) / 2.0);
        int ringIndex = (int)((double)stationId - Math.pow(radius * 2 - 1, 2.0));
        if (ringIndex < (radius * 2 + 1) * 2) {
            x = ringIndex % (radius * 2 + 1) - radius;
            z = ringIndex < radius * 2 + 1 ? -radius : radius;
        } else {
            int newIndex = ringIndex - (radius * 2 + 1) * 2;
            z = newIndex % ((radius - 1) * 2 + 1) - (radius - 1);
            x = newIndex < (radius - 1) * 2 + 1 ? -radius : radius;
        }
        if (!object.hasCustomSpawnLocation()) {
            object.setSpawnLocation(2 * ARConfiguration.getCurrentConfig().stationSize * x + ARConfiguration.getCurrentConfig().stationSize / 2, 128, 2 * ARConfiguration.getCurrentConfig().stationSize * z + ARConfiguration.getCurrentConfig().stationSize / 2);
        }
        object.setOrbitingBody(dimId);
        this.moveStationToBody(object, dimId, false);
    }

    public void registerTemporarySpaceObject(ISpaceObject object, int dimId, long expireTime) {
        int nextDimId = this.getNextStationId();
        this.temporaryDimensions.put(nextDimId, expireTime);
        this.temporaryDimensionPlayerNumber.put(dimId, 0);
        this.registerSpaceObject(object, nextDimId);
    }

    public void registerSpaceObject(ISpaceObject object, int dimId) {
        this.registerSpaceObject(object, dimId, this.getNextStationId());
        PacketHandler.sendToAll((BasePacket)new PacketSpaceStationInfo(object.getId(), object));
    }

    public void unregisterSpaceObject(int id) {
        this.temporaryDimensions.remove(id);
        this.temporaryDimensionPlayerNumber.remove(id);
        this.spaceStationOrbitMap.remove(id);
        this.stationLocations.remove(id);
        PacketHandler.sendToAll((BasePacket)new PacketSpaceStationInfo(id, null));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSpaceObjectClient(ISpaceObject object, int dimId, int stationId) {
        this.registerSpaceObject(object, dimId, stationId);
    }

    public List<ISpaceObject> getSpaceStationsOrbitingPlanet(int planetId) {
        return this.spaceStationOrbitMap.get(planetId);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId) {
            int result;
            ISpaceObject object;
            if (event.player.field_70163_u < 0.0 && !event.player.field_70170_p.field_72995_K && (object = this.getSpaceStationFromBlockCoords(event.player.func_180425_c())) != null) {
                HashedBlockPosition loc = object.getSpawnLocation();
                event.player.field_70143_R = 0.0f;
                event.player.field_70181_x = 0.0;
                event.player.func_70634_a((double)loc.x, (double)(loc.y + 2), (double)loc.z);
                event.player.func_145747_a((ITextComponent)new TextComponentString("You wake up finding yourself back on the station"));
            }
            if ((result = Math.abs(2 * (((int)event.player.field_70161_v + ARConfiguration.getCurrentConfig().stationSize / 2) % (2 * ARConfiguration.getCurrentConfig().stationSize)) / ARConfiguration.getCurrentConfig().stationSize)) == 0 || result == 3) {
                event.player.field_70179_y = -event.player.field_70179_y;
                if (result == 0) {
                    event.player.func_70107_b(event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v + (event.player.field_70161_v < 0.0 ? Math.abs(event.player.field_70161_v % 16.0) : 16.0 - event.player.field_70161_v % 16.0));
                } else {
                    event.player.func_70107_b(event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v - (event.player.field_70161_v < 0.0 ? 16.0 - Math.abs(event.player.field_70161_v % 16.0) : event.player.field_70161_v % 16.0));
                }
            }
            result = Math.abs(2 * (((int)event.player.field_70165_t + ARConfiguration.getCurrentConfig().stationSize / 2) % (2 * ARConfiguration.getCurrentConfig().stationSize)) / ARConfiguration.getCurrentConfig().stationSize);
            if (event.player.field_70165_t < (double)(-ARConfiguration.getCurrentConfig().stationSize / 2)) {
                if (result == 3) {
                    result = 0;
                } else if (result == 0) {
                    result = 3;
                }
            }
            if (result == 0 || result == 3) {
                event.player.field_70159_w = -event.player.field_70159_w;
                if (result == 0) {
                    event.player.func_70107_b(event.player.field_70165_t + (event.player.field_70165_t < 0.0 ? Math.abs(event.player.field_70165_t % 16.0) : 16.0 - event.player.field_70165_t % 16.0), event.player.field_70163_u, event.player.field_70161_v);
                } else {
                    event.player.func_70107_b(event.player.field_70165_t - (event.player.field_70165_t < 0.0 ? 16.0 - Math.abs(event.player.field_70165_t % 16.0) : event.player.field_70165_t % 16.0), event.player.field_70163_u, event.player.field_70161_v);
                }
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (DimensionManager.getWorld((int)ARConfiguration.getCurrentConfig().spaceDimId) == null) {
            return;
        }
        long worldTime = DimensionManager.getWorld((int)ARConfiguration.getCurrentConfig().spaceDimId).func_82737_E();
        if (this.nextStationTransitionTick != -1L && worldTime >= this.nextStationTransitionTick && this.spaceStationOrbitMap.get(Integer.MIN_VALUE) != null || this.nextStationTransitionTick == -1L && this.spaceStationOrbitMap.get(Integer.MIN_VALUE) != null && !this.spaceStationOrbitMap.get(Integer.MIN_VALUE).isEmpty()) {
            long newNextTransitionTick = -1L;
            for (ISpaceObject obj : this.spaceStationOrbitMap.get(Integer.MIN_VALUE)) {
                if (obj.getTransitionTime() <= worldTime) {
                    this.moveStationToBody(obj, obj.getDestOrbitingBody());
                    this.spaceStationOrbitMap.get(Integer.MIN_VALUE).remove(obj);
                    continue;
                }
                if (newNextTransitionTick != -1L && obj.getTransitionTime() >= newNextTransitionTick) continue;
                newNextTransitionTick = obj.getTransitionTime();
            }
            this.nextStationTransitionTick = newNextTransitionTick;
        }
    }

    public void onServerStopped() {
        this.stationLocations.clear();
        this.spaceStationOrbitMap.clear();
        this.temporaryDimensions.clear();
        this.nextStationTransitionTick = -1L;
    }

    public void moveStationToBody(ISpaceObject station, int dimId) {
        this.moveStationToBody(station, dimId, true);
    }

    public void moveStationToBody(ISpaceObject station, int dimId, boolean update) {
        if (this.spaceStationOrbitMap.get(station.getOrbitingPlanetId()) != null) {
            this.spaceStationOrbitMap.get(station.getOrbitingPlanetId()).remove(station);
        }
        if (this.spaceStationOrbitMap.get(dimId) == null) {
            this.spaceStationOrbitMap.put(dimId, new LinkedList());
        }
        if (!this.spaceStationOrbitMap.get(dimId).contains(station)) {
            this.spaceStationOrbitMap.get(dimId).add(station);
        }
        station.setOrbitingBody(dimId);
        if (update) {
            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(station, PacketStationUpdate.Type.ORBIT_UPDATE));
            AdvancedRocketry.proxy.fireFogBurst(station);
        }
    }

    public void moveStationToBody(ISpaceObject station, int dimId, int timeDelta) {
        if (station.getOrbitingPlanetId() != Integer.MIN_VALUE && this.spaceStationOrbitMap.get(station.getOrbitingPlanetId()) != null) {
            this.spaceStationOrbitMap.get(station.getOrbitingPlanetId()).remove(station);
        }
        if (this.spaceStationOrbitMap.get(Integer.MIN_VALUE) == null) {
            this.spaceStationOrbitMap.put(Integer.MIN_VALUE, new LinkedList());
        }
        if (!this.spaceStationOrbitMap.get(Integer.MIN_VALUE).contains(station)) {
            this.spaceStationOrbitMap.get(Integer.MIN_VALUE).add(station);
        }
        station.setOrbitingBody(Integer.MIN_VALUE);
        PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(station, PacketStationUpdate.Type.ORBIT_UPDATE));
        AdvancedRocketry.proxy.fireFogBurst(station);
        ((DimensionProperties)station.getProperties()).setAtmosphereDensityDirect(0);
        this.nextStationTransitionTick = (long)((int)(ARConfiguration.getCurrentConfig().travelTimeMultiplier * (float)timeDelta)) + DimensionManager.getWorld((int)ARConfiguration.getCurrentConfig().spaceDimId).func_82737_E();
        station.beginTransition(this.nextStationTransitionTick);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        Iterator<ISpaceObject> iterator = this.stationLocations.values().iterator();
        NBTTagList nbtList = new NBTTagList();
        while (iterator.hasNext()) {
            ISpaceObject object = iterator.next();
            NBTTagCompound nbtTag = new NBTTagCompound();
            object.writeToNbt(nbtTag);
            nbtTag.func_74778_a("type", this.classToString.get(object.getClass()));
            if (this.temporaryDimensions.containsKey(object.getId())) {
                nbtTag.func_74772_a("expireTime", this.temporaryDimensions.get(object.getId()).longValue());
                nbtTag.func_74768_a("numPlayers", this.temporaryDimensionPlayerNumber.get(object.getId()).intValue());
            }
            nbtList.func_74742_a((NBTBase)nbtTag);
        }
        nbt.func_74782_a("spaceContents", (NBTBase)nbtList);
        nbt.func_74768_a("nextInt", this.nextId);
        nbt.func_74772_a("nextStationTransitionTick", this.nextStationTransitionTick);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("spaceContents", 10);
        this.nextId = nbt.func_74762_e("nextInt");
        this.nextStationTransitionTick = nbt.func_74763_f("nextStationTransitionTick");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            try {
                ISpaceObject object = (ISpaceObject)this.nameToClass.get(tag.func_74779_i("type")).newInstance();
                object.readFromNbt(tag);
                if (tag.func_74764_b("expireTime")) {
                    long expireTime = tag.func_74763_f("expireTime");
                    int numPlayers = tag.func_74762_e("numPlayers");
                    if (DimensionManager.getWorld((int)ARConfiguration.getCurrentConfig().spaceDimId).func_82737_E() >= expireTime && numPlayers == 0) continue;
                    this.temporaryDimensions.put(object.getId(), expireTime);
                    this.temporaryDimensionPlayerNumber.put(object.getId(), numPlayers);
                }
                this.registerSpaceObject(object, object.getOrbitingPlanetId(), object.getId());
                continue;
            }
            catch (Exception e) {
                System.out.println(tag.func_74779_i("type"));
                e.printStackTrace();
            }
        }
    }
}

